/*
 * Decompiled with CFR 0.152.
 */
package cc.gammasoft.date;

import cc.gammasoft.date.AbstractCalendarView;
import cc.gammasoft.date.CalendarController;
import cc.gammasoft.date.CalendarControllerEvent;
import cc.gammasoft.date.CalendarControllerListener;
import cc.gammasoft.date.DateEditor;
import cc.gammasoft.date.DatePickerComboUI;
import cc.gammasoft.date.DatePickerTableCellEditor;
import cc.gammasoft.date.DatePickerTableCellRenderer;
import cc.gammasoft.date.MonthView;
import cc.gammasoft.date.PickerPopup;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JComboBox;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class DatePicker
extends JComboBox
implements CalendarControllerListener {
    private DatePickerTableCellRenderer _$11788;
    private DatePickerTableCellEditor _$11828;
    protected AbstractCalendarView datePickerView;
    protected CalendarController controller;
    protected DateEditor dateEditor;
    protected PickerPopup pickerPopup;
    protected SimpleDateFormat dateFormat;
    public static final String BLANK1 = " ";
    public static final int MAXL = 40;
    private int _$11746 = 0;
    private int _$11750 = 0;
    private int _$11753 = 0;
    protected EventListenerList listenerList = new EventListenerList();
    protected DatePickerComboUI comboUI = new DatePickerComboUI(){

        protected ComboPopup createPopup() {
            return DatePicker.this.pickerPopup;
        }

        public void setPopupVisible(JComboBox c, boolean v) {
            if (v) {
                DatePicker.this.pickerPopup.showPicker();
            } else {
                DatePicker.this.pickerPopup.hidePicker();
            }
        }

        public boolean isPopupVisible(JComboBox c) {
            return DatePicker.this.pickerPopup.isVisible();
        }

        public boolean isFocusTraversable(JComboBox c) {
            return DatePicker.this.pickerPopup.isFocusTraversable();
        }
    };

    public DatePicker() {
        this(null, null);
    }

    public DatePicker(Calendar calendar) {
        this(null, calendar);
    }

    public DatePicker(String calendarString) {
        this(null, null);
        this.setDate(calendarString);
    }

    public DatePicker(SimpleDateFormat format) {
        this(format, null);
    }

    public DatePicker(SimpleDateFormat format, Calendar calendar) {
        this(format, calendar, new MonthView(format, calendar));
    }

    public DatePicker(SimpleDateFormat format, Calendar calendar, AbstractCalendarView datePickerView) {
        if (datePickerView == null) {
            throw new NullPointerException("Null View");
        }
        this.datePickerView = datePickerView;
        this.controller = datePickerView.getController();
        this.dateEditor = new DateEditor(this.controller.getDateFormat());
        this.pickerPopup = new PickerPopup(datePickerView, this);
        this.dateFormat = this.controller.getDateFormat();
        this.setUI(this.comboUI);
        this.setEditor(this.dateEditor);
        this.setEditable(true);
        this.dateEditor.txtDate.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DatePicker.this.editorFocusLost();
            }
        });
        this._$11547(calendar);
        this.controller.setCurrentDate(calendar);
        this.dateEditor.txtDate.setText(this.controller.formatCurrentDate());
        this.controller.addCalendarControllerListener(this);
    }

    public void updateUI() {
        this.setUI(this.comboUI);
    }

    public ComboBoxUI getUI() {
        return this.comboUI;
    }

    public void setSelectedItem(Object object) {
        if (object == null) {
            this.setDate("");
        } else {
            this.setDate(object.toString());
        }
    }

    public Object getSelectedItem() {
        this._$11547(this.getController().getCurrentDate());
        this.dateEditor.txtDate.setText(this.getController().formatCurrentDate());
        return this.getController().getSQLDate();
    }

    public void setDate(Calendar calendar) {
        this.datePickerView.setDate(calendar);
        if (calendar != null) {
            this.dateEditor.txtDate.setText("");
        } else {
            this.dateEditor.txtDate.setText(this.datePickerView.getController().formatCurrentDate());
        }
    }

    public void setDate(String calendar) {
        this.datePickerView.setDate(calendar);
        if (calendar.equals("")) {
            this.dateEditor.txtDate.setText("");
        } else {
            this.dateEditor.txtDate.setText(this.datePickerView.getController().formatCurrentDate());
        }
    }

    public void setSQLDate(String calendar) {
        this.setDate(calendar);
    }

    public Calendar getDate() {
        this._$11615();
        return this.datePickerView.getDate();
    }

    public String getSQLDate() {
        return this.datePickerView.getSQLDate();
    }

    public void calendarControllerChanged(CalendarControllerEvent e) {
        if (this.datePickerView.getDate() == null) {
            ((DateEditor)this.getEditor().getEditorComponent()).txtDate.setText("");
            return;
        }
        if (e.getChangeType() == 2) {
            this._$11615();
            ((DateEditor)this.getEditor().getEditorComponent()).txtDate.setText(this.controller.formatCalendar(this.datePickerView.getDate()));
            ((DateEditor)this.getEditor().getEditorComponent()).txtDate.transferFocus();
            this.pickerPopup.hidePicker();
        }
    }

    public void editorFocusLost() {
        if (this.pickerPopup.isVisible()) {
            return;
        }
        if (this.dateEditor.txtDate.getText().equals("")) {
            this.setDate("");
            return;
        }
        Object date = null;
        boolean error = false;
        try {
            this.controller.getDateFormat().parse(this.dateEditor.txtDate.getText());
        }
        catch (Exception ex) {
            error = true;
        }
        if (error) {
            this.dateEditor.txtDate.setText(this.controller.formatCurrentDate());
        } else {
            Calendar c = (Calendar)this.controller.getDateFormat().getCalendar().clone();
            if (!c.equals(this.datePickerView.getDate())) {
                this._$11547(c);
                this._$11615();
                this.datePickerView.setDate((Calendar)this.controller.getDateFormat().getCalendar().clone());
            }
        }
    }

    public DateEditor getDateEditor() {
        return this.dateEditor;
    }

    public CalendarController getController() {
        return this.controller;
    }

    public AbstractCalendarView getView() {
        return this.datePickerView;
    }

    public PickerPopup getPopup() {
        return this.pickerPopup;
    }

    public void setEditable(boolean newValue) {
        super.setEditable(newValue);
        if (newValue) {
            this.setBorder(null);
        } else {
            this.setBorder(new SoftBevelBorder(1));
            this.setBackground(Color.white);
        }
    }

    private void _$11547(Calendar calendar) {
        if (calendar == null) {
            return;
        }
        this._$11746 = calendar.get(10);
        this._$11750 = calendar.get(12);
        this._$11753 = calendar.get(13);
    }

    private void _$11615() {
        if (this.datePickerView.getDate() == null) {
            return;
        }
        this.datePickerView.getDate().set(10, this._$11746);
        this.datePickerView.getDate().set(12, this._$11750);
        this.datePickerView.getDate().set(13, this._$11753);
    }

    public TableCellRenderer getCellRenderer() {
        if (this._$11788 == null) {
            this._$11788 = new DatePickerTableCellRenderer(this.getView().getController().getDateFormat());
        }
        return this._$11788;
    }

    public TableCellEditor getCellEditor() {
        if (this._$11828 == null) {
            this._$11828 = new DatePickerTableCellEditor(this);
        }
        return this._$11828;
    }

    public String getSQLTimestamp() {
        if (this.getDate() != null) {
            return CalendarController.getSQLTimestamp(this.getDate());
        }
        return "";
    }

    public String getSQLTime() {
        if (this.getDate() != null) {
            return CalendarController.getSQLTime(this.getDate());
        }
        return "";
    }
}

