/*  Project leowl_5
    xor@aysoft.com
    Copyright  1996. AY Software Corporation. All Rights Reserved.

    SUBSYSTEM:    leowl_5.exe Application
    FILE:         leowl_5.cpp
    AUTHOR:       Andrey B. Yastrebov


    OVERVIEW
    ========
    Source file for implementation of leowl_5 (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop


#include "leowl_5.h"
#include "leowl_5e.h"

//{{leowl_5 Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(leowl_5, TApplication)
//{{leowl_5RSP_TBL_BEGIN}}
//{{leowl_5RSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// leowl_5
// =====
//
leowl_5::leowl_5 () : TApplication("leowl_5")
{
}


leowl_5::~leowl_5 ()
{
}


//////////////////////////////////////////////////////////
// leowl_5
// =====
// Application intialization.
//
void leowl_5::InitMainWindow ()
{
    if (nCmdShow != SW_HIDE)
        nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWNORMAL : nCmdShow;

    TFrameWindow *frame = new TFrameWindow(0, GetName(),
		new leowl_5Edit(0,0,0), FALSE);

    //
    // Assign ICON w/ this application.
    //
    frame->SetIcon(this, IDI_SDIAPPLICATION);

    //
    // Menu associated with window and accelerator table associated with table.
    //
    frame->AssignMenu(SDI_MENU);

    //
    // Associate with the accelerator table.
    //
    frame->Attr.AccelTable = SDI_MENU;


    SetMainWindow(frame);

    frame->SetMenuDescr(TMenuDescr(SDI_MENU,0,2,1,0,0,0));
}

int OwlMain (int , char* [])
{
    try {
        leowl_5    app;
        return app.Run();
    }
    catch (xmsg& x) {
        ::MessageBox(0, x.why().c_str(), "Exception", MB_OK);
    }

    return -1;
}
