//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "lebcb_4a.h"
//---------------------------------------------------------------------------
char far* PreWords[PRE_WORD_COUNT] = {
  "define","error","include","elif","if","line","else","ifdef",
  "pragma","endif","ifndef","undef"
};

char far* Words[WORD_COUNT] = {
  "auto","break","case","catch","char","class","const","continue",
  "default","delete","do","double","else","enum","extern","float",
  "for","friend","goto","if","inline","int","long","main",
  "new","operator","private","protected","public","register","return","short",
  "signed","sizeof","static","struct","switch","template","this","throw",
  "try","typedef","union","unsigned","virtual","void","volatile","while",
  "wmain","xalloc"
};
//---------------------------------------------------------------------------
#pragma link "LEBCB"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::New1Click(TObject *Sender)
{
  LEdit1->NewFile();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Open1Click(TObject *Sender)
{
  LEdit1->OpenFile();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCloseQuery(TObject *Sender, bool &CanClose)
{
   CanClose = LEdit1->CanClose;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Save1Click(TObject *Sender)
{
  LEdit1->SaveFile();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SaveAs1Click(TObject *Sender)
{
  LEdit1->SaveFileAs();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Exit1Click(TObject *Sender)
{
  Close();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Cut1Click(TObject *Sender)
{
  LEdit1->CutToClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Copy1Click(TObject *Sender)
{
  LEdit1->CopyToClipboard();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Paste1Click(TObject *Sender)
{
  LEdit1->PasteFromClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Find1Click(TObject *Sender)
{
  LEdit1->ShowFindDialog();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FindNext1Click(TObject *Sender)
{
   LEdit1->FindNext();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Replace1Click(TObject *Sender)
{
  LEdit1->ShowReplaceDialog();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Font1Click(TObject *Sender)
{
   LEdit1->ShowFontDialog();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::WordWrap1Click(TObject *Sender)
{
   LEdit1->WordWrap = ! LEdit1->WordWrap;
   WordWrap1->Checked = LEdit1->WordWrap;
   LEdit1->ScrollBars = (LEdit1->WordWrap) ? lsbVertical : lsbBoth;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::AutoIndent1Click(TObject *Sender)
{
   LEdit1->AutoIndent = ! LEdit1->AutoIndent;
   AutoIndent1->Checked = LEdit1->AutoIndent;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::File1Click(TObject *Sender)
{
  Save1->Enabled = LEdit1->CanExecuteCommand(EC_FILESAVE);
  SaveAs1->Enabled = LEdit1->CanExecuteCommand(EC_FILESAVEAS);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Edit1Click(TObject *Sender)
{
  Find1->Enabled = LEdit1->CanExecuteCommand(EC_SEARCHFIND);
  FindNext1->Enabled = LEdit1->CanFindNext;
  Replace1->Enabled = LEdit1->CanExecuteCommand(EC_SEARCHREPLACE);
  Cut1->Enabled = LEdit1->CanExecuteCommand(EC_EDITCUT);
  Copy1->Enabled = LEdit1->CanExecuteCommand(EC_EDITCOPY);
  Paste1->Enabled = LEdit1->CanExecuteCommand(EC_EDITPASTE);
  FindBrace1->Enabled = LEdit1->CanExecuteCommand(EC_SEARCHBRACE);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::LEdit1ControlHighlight(TObject *Sender, PWordDesc pWD,
	int hDC)
{
   switch (pWD->wCode)
   {
      case WD_SIMPLEWORD:
      {
        /* Do binary search here. This is probably fast enough, but
          table search would be better */
        int left;
        int middle;
        int right;
        int i;

        if (pWD->caWord[0] == '#')
        {
          left = 0;
          right = PRE_WORD_COUNT + 1;
          while ((right-left) > 1)
          {
            middle = (left + right) / 2;
            i = lstrcmp(pWD->caWord + 1,PreWords[middle-1]);
            if (i == 0)
            {
              // color for pre-processor keywords keywords
              SetTextColor((void *)hDC,RGB(255,0,255));
              return;
            }
            ((i < 0) ? right : left) = middle;
          }
        }

        left = 0;
        right = WORD_COUNT+1;
        while ((right-left) > 1)
        {
          middle = (left + right) / 2;
          i = lstrcmp(pWD->caWord,Words[middle-1]);
          if (i == 0)
          {
            // color for keywords
            SetTextColor((void *)hDC,RGB(0,0,255));
            return;
          }
          ((i < 0) ? right : left) = middle;
        }
        // color for the rest of the words
        SetTextColor((void *)hDC,RGB(0,0,0));
        break;
      }
      case WD_SYNTAXITEM:
      {
        SetTextColor((void *)hDC,RGB(0,0,192));
        break;
      }
      case WD_QUOTEDTEXT:
      case WD_BADLYQUOTEDTEXT:
      {
        SetTextColor((void *)hDC,(HiWord(pWD->dwValue)) ? RGB(0,128,0) : RGB(255,0,0));
        break;
      }
      default: SetTextColor((void *)hDC,RGB(0,128,0));
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FindBrace1Click(TObject *Sender)
{
   LEdit1->FindBrace();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::LEdit1FindBrace(TObject *Sender, PWordDesc pWD,
	short &Response)
{
  if (pWD->wCode == WD_SYNTAXITEM)
  {
    switch (HiWord(pWD->dwValue))
    {
      case 5:
      {
        pWD->dwValue = MAKELONG(0,6);
        Response = EMF_HASRIGHT;
        break;
      }
      case 6:
      {
        pWD->dwValue = MAKELONG(0,5);
        Response = EMF_HASLEFT;
        break;
      }
    }
  }
}
//---------------------------------------------------------------------------
