#include "Particles.h"
#include "Random.h"
#include <CON_Bitmap.h>
#include <2D_World.h>
#include <math.h>

Random R;

ParticleSystem::ParticleSystem(int Width, int Height, int ParticlesNumber) : 
  AnimatedSprite(), 
  m_Canvas(newBitmap(Width,Height)),
  m_Sprite(new Sprite(m_Canvas)),
  m_Particles(new PParticle[ParticlesNumber]),
  m_ParticlesNumber(ParticlesNumber),
  m_Status(0)
{
  for(int i=0;i<m_ParticlesNumber;i++) 
    m_Particles[i]=new Particle(m_Canvas);
  addAnimationFrame(m_Sprite,100.0f);
  m_Canvas->setTransparentColor(0);
}

ParticleSystem::~ParticleSystem()
{
  for(int i=0;i<m_ParticlesNumber;i++) 
    delete m_Particles[i];
  delete[] m_Particles;
  delete m_Sprite;
  m_Canvas->release();
}

void ParticleSystem::reset()
{
  for(int i=0;i<m_ParticlesNumber;i++) 
    m_Particles[i]->reset();
}

long ParticleSystem::render(View& view)
{
  m_Canvas->clear();
  m_Status=m_Canvas->lock(1);
  if (m_Status!=0) return m_Status;
  for(int i=0;i<m_ParticlesNumber;i++) m_Particles[i]->render();
  m_Status=m_Canvas->unlock();
  if (m_Status!=0) return m_Status;
  return AnimatedSprite::render(view);
}

long ParticleSystem::advance(float Fraction)
{
  int DeadNum=0;
  for(int i=0;i<m_ParticlesNumber;i++) 
    DeadNum+=m_Particles[i]->advance(Fraction);
  if (DeadNum>=m_ParticlesNumber) return rcDELETE;
  return AnimatedSprite::advance(Fraction);
}

Vector2D getRandomVelocity(float Speed)
{
  float x=R(-1.0f,1.0f);
  float y=R(-1.0f,1.0f);
  float len=(float)sqrt(x*x+y*y);
  if (len!=0.0f) len=1.0f/len;
  float RSpeed=R(Speed);
  x*=len*RSpeed;
  y*=len*RSpeed;
  return fVector2D(x,y);
}

Particle::Particle(Bitmap* BM) :
  m_Bitmap(BM),
  m_Position(BM->getWidth()*0.5f,BM->getHeight()*0.5f),
  m_Speed(R(5.0f,15.0f)),
  m_Velocity(getRandomVelocity(m_Speed)),
  m_Red(255.0f),
  m_Green(255.0f),
  m_Life(R(10.0f,20.0f)),
  m_Color(0xffe0)
{}  

static fVector2D Gravity(0.0f,25.0f);

int Particle::advance(float Fraction)
{
  m_Velocity=m_Velocity+Fraction*Gravity;
  fVector2D Move(m_Velocity.getX()*Fraction,m_Velocity.getY()*Fraction);
  m_Position=m_Position+Move;
  float Decay=m_Speed*Fraction*(20.0f-m_Life);
  m_Red-=Decay;
  if (m_Red<0.0f) m_Red=0.0f;
  m_Green-=4*Decay;
  if (m_Green<0.0f) m_Green=0.0f;
  m_Life-=Fraction*5.0f;
  m_Color=m_Bitmap->getColor((int)m_Red,(int)m_Green,0);
  return (m_Life<=0.0f);
}

int Particle::render()
{
  int SubParticles=R(7)+1;
  while (SubParticles--)
  {
    int dx=R(3)-1;
    int dy=R(3)-1;
    Vector2D P=m_Position;
    P+=Vector2D(dx,dy);
    m_Bitmap->drawHLine(P.getY(),P.getX(),P.getX(),m_Color);
  }
  return 0;
}

void Particle::reset()
{
  m_Position=fVector2D(m_Bitmap->getWidth()*0.5f,m_Bitmap->getHeight()*0.5f),
  m_Velocity=getRandomVelocity(8.0f);
  m_Red=255.0f;
  m_Green=255.0f;
  m_Life=R(10.0f,20.0f);
  m_Color=0xffe0;
}



