#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>
#include <CON_All.h>
#include <3D_View.h>
#include <3D_SpecObject3D.h>

int initConsole(int& Width, int& Height, int& FullScreen, int& Flags, Screen* S)
{
  if (S->isModeAvailable(640,480)==0) return -1;
  Width=640;
  Height=480;
  FullScreen=1;
  Flags=0;
  return 0;
}

// An object subclass that will rotate in place.
class MyShip : public Object3D
{
public:
  MyShip(Mesh* M) : Object3D(M)
  {
    setPosition(Vector3D(0.0f,0.0f,20.0f));
  }

  long advance(float Fraction)
  {
    //rotate(Vector3D(0.07f*Fraction,0.04f*Fraction,0.15f*Fraction));
    rotate(Vector3D(0.17f*Fraction,0.0f,0.0f));
    //m_Mesh->forward(10.0f*Fraction);
    return Object3D::advance(Fraction);
  }
};

// A camera associated object, that will move according to keyboard presses.
class MyViewer : public Viewer
{
public:
   MyViewer(Camera *Cam, Keyboard& K, Mesh* M) :
    Viewer(Cam, M),
    m_K(K)
  {}

  long advance(float Fraction)
  {
    float Rot=1.0f,Adv=100.0f;
    if (m_K[DIK_LEFT])     rotate(Vector3D(0.0f,0.0f,-Rot*Fraction));
    if (m_K[DIK_RIGHT])    rotate(Vector3D(0.0f,0.0f, Rot*Fraction));
    if (m_K[DIK_DOWN])     rotate(Vector3D( Rot*Fraction,0.0f,0.0f));
    if (m_K[DIK_UP])       rotate(Vector3D(-Rot*Fraction,0.0f,0.0f));
    if (m_K[DIK_ADD])      forward( Adv*Fraction);
    if (m_K[DIK_SUBTRACT]) 
      forward(-Adv*Fraction);
    return Viewer::advance(Fraction);
  }

  Keyboard& m_K;
};

// A simple radar to track other objects.
class MyRadar : public Radar
{
public:
  MyRadar(Screen* S, int x, int y, int Width, int Height) :
    Radar(),
    m_Screen(S),
    m_x(x),
    m_y(y),
    m_DrawRadar(newBitmap(Width,Height))
  {
    setRange(500.0f,100);
  }

  ~MyRadar()
  {
    m_DrawRadar->release();
  }

  long render()
  {
    long rc;
    if ((rc=m_DrawRadar->clear())!=0) return rc;
    if ((rc=m_DrawRadar->beginDraw())!=0) return rc;
    for(int i=5;i<m_DrawRadar->getWidth();i+=20)
      m_DrawRadar->line(0,i,m_DrawRadar->getHeight()-1,i);
    for(i=5;i<m_DrawRadar->getHeight();i+=20)
      m_DrawRadar->line(i,0,i,m_DrawRadar->getWidth()-1);
    int x,y,z;
    iterate();
    int Midx=m_DrawRadar->getWidth()/2;
    int Midy=m_DrawRadar->getHeight()/2;
    int ONum=0;
    while (getNext(x,y,z)==0)
    {
      ONum++;
      char buf[20];
      sprintf(buf,"%d",y);
      m_DrawRadar->printXY(Midx+x,Midy-z,0xffffffff,buf);
    }
    m_DrawRadar->endDraw();
    clear();
    return m_Screen->copy(m_DrawRadar,m_x,m_y);
  }

  int     m_x,m_y;
  Screen* m_Screen;
  Bitmap* m_DrawRadar;
};

// An object that will rotate a mesh (loaded as a sphere).
class MyPlanet : public Object3D
{
public:
  MyPlanet(Mesh* M) : Object3D(M) {}

  long advance(float Fraction)
  {
    rotate(Vector3D(0.0f,Fraction/3,0.0f));
    Object3D::advance(Fraction);
    return 0;
  }
};

int oldcnt=0,curcnt=0;
int Frames=0;
int LastFrame=0;
int FPS=0;
int InitCount=3;
ResourceStream *RS=NULL;
TextureCache   *TC=NULL;
Light          *SL=NULL;
Light          *SPL=NULL;
World3D        *W=NULL;
Viewer         *V=NULL;
Mesh          *VO=NULL;
MeshBuilder*   MB=NULL;
View3D*        v3D=NULL;

int action(Console* C)
{
  Keyboard& K=*(C->getKeyboard());
  K.update();
  Screen& S=*C->getScreen();

  if (W==NULL)
  {
    // Initialize all global variables.
    RS=newResourceStream();
    TC=newTextureCache(RS);
    MB=newMeshBuilder();
    W=new World3D();
    if (W->status()!=OK) 
    {
      ReportError(W->status(),"Cannot create world.");
      delete W;
      return -1;
    }
    v3D = new View3D(Rect2D(200,10,599,309));

    v3D->getCamera()->setStars(1000);
    v3D->getCamera()->setBackgroundColor(S.getColor(0,0,32));
    {
      V=new MyViewer(v3D->getCamera(),K,NULL);
      W->add(V);
    }
    {
      Vector3D Pos(0.0f,0.0f,-13500.0f);

      Mesh* SunMesh = MB->createBillBoardSphere(Vector3D::Zero, 3000.0f,230,230,30);
      MB->rebuild(SunMesh);
      Mesh* SunMesh2 = MB->createMesh(0.0f);
      MB->clear();
      SunMesh2->m_Transform = SunMesh->m_Transform;

      Object3D* SSun=new Object3D(SunMesh2);
      SSun->setPosition(Pos);
      W->add(SSun);
      long rc;

      SL=newSunLight(Pos,fColor(0.0f,0.3f,0.4f));
      if (SL->status()!=OK) ReportError(SL->status(),"Sun light constructor failed.");
      rc=v3D->getCamera()->addLight(SL);
      if (rc!=OK) ReportError(rc,"Add Sun light failed.");

      SPL=newSpotLight(Vector3D(0.0f,0.0f,0.0f), Vector3D(0.0f,0.0f,1.0f),
                       fColor(1.0f,1.0f,0.0f),50.0f);
      if (SPL->status()!=OK) ReportError(SL->status(),"Spot light constructor failed.");
      rc=v3D->getCamera()->addLight(SPL);
      if (rc!=OK) ReportError(rc,"Add Spot light failed.");
    }

    Radar* R=new MyRadar(&S,10,10,100,100);
    v3D->setRadar(R);

    {
      Texture* t=TC->load("earth.bmp");
      if (t!=NULL)
      {
        Mesh* Earth=MB->createSphere(Vector3D::Zero, 4500.0f,t);
        long rc=MB->status();
        if (rc==0) 
        {
          MyPlanet* PEarth=new MyPlanet(Earth);
          PEarth->setPosition(Vector3D(0.0f, 0.0f, 7500.0f));
          W->add(PEarth);
        }
      }
    }
  
    {
      Mesh* O3D;
      if (0==loadXFile("flat.x",O3D,NULL,0.5f))
         //"\\Platform SDK\\samples\\Multimedia\\D3DIM\\media\\tiger.x"
      {
//       MB->rebuild(O3D);
//       O3D->release();
//       MeshBuilder* MB2=MB->calculateNormals();
//       MB->release();
//       MeshBuilder* MB3=MB->createReducedObject();
//       MB->release();
//       O3D = MB->createMesh(0, 60.0f*fDTOR);

        MyShip* ship=new MyShip(O3D);
        if (C->getSound()!=NULL)
        {
          istream* is=RS->getStream("hum.wav");
          if (is!=NULL) 
          {
            int len=RS->getLength("hum.wav");
            SoundClip* SC=loadWaveFile(is,SoundAccel|Sound3D);
            SC->set3DMode(1);
            ship->startSound(SC);
            RS->freeStream(is);
          }
        }
        W->add(ship);
      }
      else O3D->release();
    }

    MB->release();
    //C->getScreen3D()->setFog(0x707070,20.0f,200.0f);
  }

  S.clear();
  W->render(*v3D);
  W->advance(getFrameTime(), 0.005f);
  
  Frames++;
  curcnt=GetTickCount();
  if (oldcnt==0) oldcnt=curcnt;
  else
  {
    if ((curcnt-oldcnt)>1000) 
    { 
      FPS=(Frames-LastFrame);
      LastFrame=Frames;
      oldcnt+=1000;
    }
  }

  char buf[512];
  S.beginDraw();
  sprintf(buf,"FPS: %d",FPS);
  S.printXY(10,450,-1,buf);
  sprintf(buf,"Pos: %f,%f,%f",V->getPosition().x,V->getPosition().y,V->getPosition().z);
  S.printXY(10,400,-1,buf);
  S.printXY(10,350,-1,"Use Arrows, +- to control camera position.    ESC to exit");
  S.endDraw();
  S.flip();
  if (K[DIK_ESCAPE])
  {
    ReportInfo("Exiting");
    if (SL!=NULL) SL->release();
    if (SPL!=NULL) SPL->release();
    delete v3D;
    if (TC!=NULL) TC->release();
    if (RS!=NULL) RS->release();
    delete W;
    return 1; // Terminate application
  }
  return 0;
}