/*************************************************************************
** interpcom-2.3   (command interpreter)                                 **
** test_in.c : test program for the command interpreter                  **
**          Shows how to use the command interpreter in a non            **
**          interactive way                                              **
**                                                                       **
** Copyright (C) 2001  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France                                                           **
**                                                                       **
 *************************************************************************/

#include "interp.h"

FUNCTION           *Funcs;
FUNCTIONC          *Funcs_C;

pfi                *proc[]={
    NULL,
};

FUNCTIONGen        *Funcs_Gen[] = {
    NULL,
};


int
main(void)
{
    char            h[50],
                    h2[1000],
                   *k[3];


/*------ Initialization of the command interpreter ---------------*/
    Funcs = Funcs_interp;
    Funcs_C = Funcs_interp_C;
    _NBFONC_C = _NBFONC0_C;
    _NBFONC = _NBFONC0;
    prog_c(0, NULL, "interp.ini", NULL, 0, NULL, 1);
/*----------------------------------------------------------------*/


/*------ We load the program file 'magic' ------------------------*/
    if (loadcmd("magic") == 0)
        printf("magic loaded\n");
    else
        return 1;
/*----------------------------------------------------------------*/


/*------ We run one of the programs ------------------------------*/
    sprintf(h, "magic7 x\n");
    Exec_interp_command(h);
/*----------------------------------------------------------------*/


/*------ We write a program ('example') in
         the string h2 -------------------------------------------*/
    memset(h , 0, 50);
    memset(h2 , 0, 1000);
    sprintf(h, ":example\n");
    strcat(h2, h);
    memset(h , 0, 50);
    sprintf(h, "1\n");
    strcat(h2, h);
    memset(h , 0, 50);
    sprintf(h, "0\n");
    strcat(h2, h);
    memset(h , 0, 50);
    sprintf(h, "-1\n");
    strcat(h2, h);
    memset(h , 0, 50);
    sprintf(h, "mon test_x.out\n");
    strcat(h2, h);
    memset(h , 0, 50);
    sprintf(h, "magicb\n");
    strcat(h2, h);
    memset(h , 0, 50);
    sprintf(h, "end_mon\n");
    strcat(h2, h);
    k[0] = NULL;
    k[1] = h2;
/*----------------------------------------------------------------*/


/*------  We load this program in the command interpreter --------*/
    load_cmd(0, k);
/*----------------------------------------------------------------*/


/*------ We execute the program 'example' ------------------------*/
    sprintf(h, "example\n");
    Exec_interp_command(h);
/*----------------------------------------------------------------*/


/*------ We clean the memory used by the interpreter -------------*/
    clean_exit_interp(&flow_I[0]);
/*----------------------------------------------------------------*/

    return 0;
}

void
init_prog(flow_data *flow_interp)
{
}

void
exit_prog()
{
    exit(0);
}

void
dest_prop(int typ, int i0, flow_data *flow_interp)
{
}

void
init_thread_param(flow_data *flow_interp)
{
}

void init_expr_GEN(flow_data *flow_interp)
{
}

void
clean_thread_param(flow_data *flow_interp)
{
}

