
/*
 * Copyright (C) 1994,95 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "fab.h"

@implementation Fabclass

- name:aname supername:bname ivars:block maturity:mindex
{
    cname = aname;sname = bname;ivars = block;
    maturity=mindex; /* can be nil */
    return self;
}

+ name:aname supername:bname ivars:block maturity:mindex
{
    return [[super new] name:aname supername:bname ivars:block maturity:mindex];
}

- dumpsource:(FILE *)f
{
    if (fabtestmode) {
	return self;
    } else {
	fprintf(f,"@implementation %s\n",[cname str]);return self;
    }
}

- dumpheader:(FILE *)f
{
    if (fabtestmode) {
	return self;
    } else {
	fprintf(f,"@interface %s : %s\n",[cname str],[sname str]);
	[ivars print:f];return self;
    }
}

- paragraphs:aCltn
{
  id text;
  unsigned n;
  static id title,subtitle,docstyle;

  if (!title) {
    title = [TextStyle named:"Title"];
    docstyle = [TextStyle named:"Doc"];
    subtitle = [TextStyle named:"Subtitle"];
  }

  text = [cname asText];
  [aCltn add:[Paragraph withText:text style:title]];

  text = [Text str:"Inherits from: "];
  n    = [text size] - 2;
  [text makeBoldFrom:0 to:n];
  [text addAttribute:[TextAttribute emphasiscode:SWISS] from:0 to:n];

  text = [sname asText:text];
  [aCltn add:[Paragraph withText:text style:docstyle]];

  if (maturity) {
    text = [Text str:"Maturity Index: "];
    n    = [text size] - 2;
    [text makeBoldFrom:0 to:n];
    [text addAttribute:[TextAttribute emphasiscode:SWISS] from:0 to:n];
    text = [maturity asText:text];
    [aCltn add:[Paragraph withText:text style:docstyle]];
  }

  text = [Text str:"Class Description"];
  [aCltn add:[Paragraph withText:text style:subtitle]];

  return aCltn;
}

@end

