#if !defined(__BORDAO_H)
#define __BORDAO_H

#undef EOF	//It conflicts with C library
#include "dao2535.tlh"	//#import generated header
using namespace DAO;

extern _DBEnginePtr dbeng;	//Global DBEngine object

extern DatabasePtr dbase;	//Global Database object

extern VARIANT vtNull;	//Useful null VARIANT

extern int _cndig;	//Global # of digits for currency 

extern int _nndig;	//Global # of digits for numbers

extern char _cdeci[2];	//Global decimal separator for currency

extern char _ndeci[2];	//Global decimal separator for numbers

HRESULT CreateDBEngine();	//Helper for DBEngine creation

bool OpenDatabase(_bstr_t DatabaseName);	//Helper for Database opening

void Show(_com_error& e, HWND hWnd = 0);	//Error messages

_variant_t getdate();	//Gets current date/time

_bstr_t shortdate(_variant_t);	//Extracts date from datetime
		
//Converts and formats variants into strings
_bstr_t VarToStr(_variant_t var, int ndec = 0);

//Wrapper for Recordsets
class DaoRecordset : public RecordsetPtr
{
public:
	//Creates a recordset from a string
	DaoRecordset(_bstr_t sql);
	//Default ctor
	DaoRecordset() {};
	//Copy ctor
	DaoRecordset(DaoRecordset& rs);
	//Assigns a string to a recordset
	DaoRecordset& operator=(_bstr_t sql);
};

#endif
