<?php
include("phpchartdir.php");

#
#Sample data for the HLOC chart. Represents the high, low, open and close
#values for 31 days
#
$high = array( 
	2043, 2039, 2076, 2064, 2048, NoValue, NoValue, 2058, 2070, 2033, 2027, 
	2029, NoValue, NoValue, 2071, 2085, 2034, 2031, 2056, NoValue, NoValue, 
	2128, 2180,	2183, 2192, 2213, NoValue, NoValue, 2230, 2281, 2272 
);
$low = array( 
	1931, 1921, 1985, 2028, 1986, NoValue, NoValue, 1994, 1999, 1958, 1943, 
	1944, NoValue, NoValue, 1962, 2011, 1975, 1962, 1928, NoValue, NoValue, 
	2059, 2112, 2103, 2151, 2127, NoValue, NoValue, 2123, 2152, 2212 
);
$open = array( 
	2000, 1957, 1993, 2037, 2018, NoValue, NoValue, 2021, 2045, 2009, 1959, 
	1985, NoValue, NoValue, 2008, 2048, 2006, 2010, 1971, NoValue, NoValue, 
	2080, 2116, 2137, 2170, 2172, NoValue, NoValue, 2171, 2191, 2240 
);
$close = array( 
	1950, 1991, 2026, 2029, 2004, NoValue, NoValue, 2053, 2011, 1962, 1987, 
	2019, NoValue, NoValue, 2040, 2016, 1996, 1985, 2006, NoValue, NoValue, 
	2113, 2142, 2167, 2158, 2201, NoValue, NoValue, 2188, 2231, 2242 
);

#
#The labels for the HLOC chart
#
$labels = array( 
	"Mon 1",  "Tue 2",  "Wed 3",  "Thu 4",  "Fri 5",  "Sat 6",  "Sun 7", 
	"Mon 8",  "Tue 9",  "Wed 10", "Thu 11", "Fri 12", "Sat 13", "Sun 14", 
	"Mon 15", "Tue 16", "Wed 17", "Thu 18", "Fri 19", "Sat 20", "Sun 21", 
	"Mon 22", "Tue 23", "Wed 24", "Thu 25", "Fri 26", "Sat 27", "Sun 28", 
	"Mon 29", "Tue 30", "Wed 31" 
);

#First, create a XYChart of size 600 pixels x 350 pixels
$c = new XYChart(600, 350);

#the plotarea at (50, 25) and of sizes 500(w) x 250(h). Make both the 
#horizontal and vertical grids visible by setting their colors
$plotarea = $c->setPlotArea(50, 25, 500, 250);
$plotarea->setGridColor(0xc0c0c0, 0xc0c0c0);

#Add a title to the chart
$c->addTitle("Universal Stock Index on Jan 2001");

#Add a custom text at (51, 21) (the upper left corner of the plotarea).
#Use 12 point Arial bold (arialbd.ttf) as the font, and pale green as 
#the color (0x40c040).
$c->addText(51, 21, "(c) Global XYZ ABC Company", "arialbd.ttf", 
	12, 0x40c040);

#Add a title to the x axis
$c->xAxis->setTitle("Jan 2001");

#the x axis labels. Display the labels at 45 deg rotation.
$textBox = $c->xAxis->setLabels($labels);
$textBox->setFontAngle(45);

#Add a title to the y axis
$c->yAxis->setTitle("Universal Stock Index");

#Display the y axis on the right hand side of the plotarea
$c->setYAxisOnRight(1);

#Leave a 10% margin on top and bottom when performing auto-scaling. The 
#margin ensures there are spaces on the top and bottom of the plot area
#for custom text. 
$c->yAxis->setAutoScale(0.1, 0.1);

#Add an HLOC layer. Set the color to blue (0x0000ff)
$layer = $c->addHLOCLayer($high, $low, $open, $close, 0x0000ff);

#the line width to 2 for a thicker line
$layer->setLineWidth(2);

#Layout the chart without drawing it. This computes the scaling factors 
#of the x and y axes, so we can use them to locate the custom text below. 
$c->layout();

#Add a custom text to annotate the highest point. For our sample data, the
#highest point is 2281 at the 30th data point (index = 29). Note we use 
#the getXCoor and getYCoor to get the (x, y) coor of the text 
$c->addText($layer->getXCoor(29), $layer->getYCoor(2281), 
	"High 2281\nTue 30 Jan, 2001", "", 7.5, 0, BottomRight);

#Similarly, add a custom text to annotate the lowest point, which is the
#1921 at the 2nd sample.
$c->addText($layer->getXCoor(1), $layer->getYCoor(1921), 
	"Low 1921\nTue 2 Jan, 2001", "", 7.5, 0, TopLeft);

#output the chart
header("Content-type: image/png");
print($c->makeChart2(PNG));
?>