#include "chartdir.h"

int main(int argc, char *argv[])
{
	//The data for the pie chart
	double data[] = { 25, 18, 15, 12, 8, 30, 35 };

	//The labels for the pie chart
	const char *labels[] = { "Labor", "Licenses", "Taxes", "Legal",
		"Insurance", "Facilities", "Production" }; 

	//First, create a PieChart of size 360 pixels x 300 pixels
	PieChart *c = PieChart::create(360, 300);	

	//Set the center of the pie at (180, 140) and the radius to 100 pixels
	c->setPieSize(180, 140, 100);

	//Set the pie data and the pie labels
	c->setData(sizeof(data)/sizeof(data[0]), data, labels);

	//output the chart as a PNG file
	c->makeChart("simplepie.png");

	//destroy the chart to free up resources
	c->destroy();
	
	return 0;
}

