// NodARBB.h: interface for the NodARBB class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_NODARBB_H__2FA32405_0A4C_11D4_BC5C_EFDE26819337__INCLUDED_)
#define AFX_NODARBB_H__2FA32405_0A4C_11D4_BC5C_EFDE26819337__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Defs.h"

/*
	Clasa pur virtuala ce constituie clasa de baza
	pentru obiecte care for face parte din arborii B.
	A se deriva!
*/

class ARBBDLL_API NodARBB {

public:
	
	// Constructor
	NodARBB ();

	// Destructor
	virtual ~NodARBB ();

	/* Creeaza o copie identica cu *this si returneaza un pointer la ea.
		Fiecare clasa derivata are o implementare proprie!
	*/
	virtual NodARBB* Clone () const=0;

	/* Operatorii esentiali ce alcatuiesc relatiile de ordine in domeniul
		obiectelor claselor derivate. Sunt pur virtuali, deci trebuie sa fie
		supraincarcati.
	*/
	virtual BOOL operator== ( const NodARBB& rNod ) const =0;
	virtual BOOL operator< ( const NodARBB& rNod ) const =0;
	
	// Operatorii neesentiali, nu trebuie supraincarcati.
	BOOL operator!= ( const NodARBB& rNod ) const;
	BOOL operator>  ( const NodARBB& rNod ) const;
	BOOL operator<= ( const NodARBB& rNod ) const;
	BOOL operator>= ( const NodARBB& rNod ) const;

};

#endif // !defined(AFX_NODARBB_H__2FA32405_0A4C_11D4_BC5C_EFDE26819337__INCLUDED_)
