/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Menu;

class FileList {
    Menu menu;
    String[] paths;
    String[] names;
    int index;
    int maxsize;

    public FileList(int n) {
        this.maxsize = n;
        this.paths = new String[n];
        this.names = new String[n];
        this.index = 0;
    }

    public FileList() {
        this(8);
    }

    public FileList(Menu menu) {
        this();
        this.menu = menu;
    }

    public void setSize(int n) {
        this.maxsize = n;
        while (this.index > this.maxsize) {
            this.remove(0);
        }
    }

    public boolean add(String string, String string2) {
        if (this.index >= this.maxsize) {
            this.remove(0);
        }
        this.paths[this.index] = string;
        this.names[this.index] = string2;
        ++this.index;
        return true;
    }

    public boolean add(String string) {
        Path.split(string);
        return this.add(Path.ADir, Path.Filename);
    }

    public boolean already(String string, String string2) {
        return this.find(string, string2) != -1;
    }

    public int find(String string, String string2) {
        for (int i = 0; i < this.index; ++i) {
            if (!string2.equalsIgnoreCase(this.names[i]) || !string.equalsIgnoreCase(this.paths[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean addUnic(String string, String string2) {
        if (this.already(string, string2)) {
            return false;
        }
        return this.add(string, string2);
    }

    public void remove(int n) {
        if (n < 0) {
            return;
        }
        if (n >= this.index) {
            return;
        }
        int n2 = this.index - 1;
        for (int i = n; i < n2; ++i) {
            this.paths[i] = this.paths[i + 1];
            this.names[i] = this.names[i + 1];
        }
        --this.index;
    }

    public void remove(String string, String string2) {
        this.remove(this.find(string, string2));
    }

    public String get(int n) {
        return Path.merge(this.paths[n], this.names[n]);
    }

    public void clear() {
        this.index = 0;
        for (int i = 0; i < this.maxsize; ++i) {
            this.names[i] = "";
        }
    }

    public String getName(int n) {
        return this.names[n];
    }

    public String getDir(int n) {
        return this.paths[n];
    }

    public String getFullPath(int n) {
        return this.get(n);
    }
}

