

#define SERIAL_IO_BLOCKSIZE			16		// size of serial tx chunk

#define DATABLOCK_SIZE				1024	// size of datablock buffer

#define DATABLOCK_FILLTHRESHOLD		64		// free buffer space block commit threshold

#define DATABLOCK_MAXUNUSED			2000	// max number of free blocks, extras are deleted by block release code

#define DATABLOCK_MINRESERVED		100		// min number of free blocks to leave after old ones are pruned by timer routine

#define DATABLOCK_MAXAGE			250		// max age before commiting a partially filled block




class CDataBlock : public CObject
{
public:
	inline int blkAge(void)
	{
		if( !blkLen ) return 0;				// no age timer if the block is empty
		return (int)GetElapsedTicks( timeMark );
	}

	inline void blkStartTimer(void)
	{
		timeMark = GetTickCount();
	}


	inline int blkLeft(void){ return DATABLOCK_SIZE - blkLen; }

	BYTE	blkData[ DATABLOCK_SIZE ];
	int		blkLen;
	int		blkSent;
	DWORD	timeMark;
};









class CPortServer: public CObject
{
public:
	CPortServer( CString serviceName, CString cstrPortDesc, CString cname, int cbaud, int cparity, int cbits, int cstops, int options, CString cstrKey );
	~CPortServer();

	inline BOOL svrIsTerminated(){ return m_IsTerminated; }

	inline CString	svrGetStatusText()		{ return m_cstrServerStatus; }
	inline BOOL		svrIsConnected()		{ return m_boolIsConnected; }

	inline CString	svrCommGetPort()		{ return m_commPortName; }
	inline CString	svrCommGetPortDesc()	{ return m_commPortDesc; }
	inline int		svrCommGetBaud()		{ return m_commBaud; }
	inline int		svrCommGetParity()		{ return m_commParity; }
	inline int		svrCommGetDataBits()	{ return m_commDataBits; }
	inline int		svrCommGetStopBits()	{ return m_commStops; }

	inline CString	svrGetServiceName()		{ return m_serviceName; }
	inline CString	svrGetMasterKey()		{ return m_CryptKeyMaster; }
	inline CString	svrGetEffectiveKey()	{ return m_CryptKeyEffective; }
	
	void	svrTerminate();
	void	svrClosePorts();
	void	svrReleaseDataBlocks();

	void	svrThreadEntry();

	void svrCreateDeltaKey( CString *txtKeyDelta, CString *newEffectiveKey );
	inline void	svrSetEffectiveKey( CString cstrNewKey )
	{
		m_CryptKeyEffective = cstrNewKey;
	}

	void	svrConnectIncomingNetPort( CString cstrUser, CAsyncSocket *newSocket, int keyIndexRcv, int keyIndexXmt);

	CObList			m_listNetTransmit;
	CObList			m_listNetReceive;

	int				m_nKeyIndexNetRead, m_nKeyIndexNetWrite;
	CString			m_CryptKeyMaster;
	CString			m_CryptKeyEffective;

	volatile BOOL	isTranceiving;

	volatile int	nBytesRead;
	volatile int	nBytesWritten;


private:
	void	svrSignalServiceThread();

	volatile BOOL	m_criticalSignal;


	CWinThread		*m_SvrThread;

	CNetworkPort	*m_portNet;
	CSerialPort		*m_portComm;

	volatile BOOL	m_IsTerminated;
	volatile BOOL	m_TerminateFlag;
	volatile BOOL	m_boolIsConnected;

	CAsyncSocket	*m_newSocket;

	CString		m_cstrServerStatus;
	CString		m_cstrConnectedUser;

	CString		m_serviceName;

	CString		m_commPortName;
	CString		m_commPortDesc;
	int			m_commBaud;
	int			m_commParity;
	int			m_commDataBits;
	int			m_commStops;
	int			m_Options;
};

// eof

