
#include "stdafx.h"
#include "SerialRedirect.h"

#include "serialports.h"
#include "networkports.h"
#include "portserver.h"



#define	SIGNAL_LOCKED		0
#define SIGNAL_UNLOCKED		1
#define	SIGNAL_RUNNING		2



static UINT serverEntry( LPVOID pParam )
{
	CPortServer *lpSvr = (CPortServer *)pParam;
	lpSvr->svrThreadEntry();
	return 0;
}





CPortServer::CPortServer( CString serviceName, CString cstrPortDesc, CString cname, int cbaud, int cparity, int cbits, int cstops, int options, CString cstrKey )
{
	m_serviceName	= serviceName;

	nBytesRead		= nBytesWritten = 0;
	isTranceiving	= FALSE;

	m_IsTerminated	= FALSE;
	m_TerminateFlag	= FALSE;
	m_boolIsConnected = FALSE;

	m_portNet		= NULL;
	m_portComm		= NULL;

	m_commBaud		= cbaud;
	m_commDataBits	= cbits;
	m_commParity	= cparity;
	m_commPortName	= cname;
	m_commStops		= cstops;

	m_commPortDesc  = cstrPortDesc;

	m_CryptKeyMaster	= cstrKey;
	m_CryptKeyEffective = "";

	m_Options		= options;

	m_newSocket		= NULL;

	m_criticalSignal = SIGNAL_LOCKED;	// the lock is initially set

	m_SvrThread = AfxBeginThread( (AFX_THREADPROC)serverEntry, (LPVOID)this, 0, 0, 0, NULL );
	m_SvrThread->m_bAutoDelete = TRUE;
}




CPortServer::~CPortServer()
{
	svrTerminate();
	svrClosePorts();
}



void CPortServer::svrTerminate()
{
	if( m_SvrThread )
	{
		m_TerminateFlag = TRUE;
		svrSignalServiceThread();

		while( !m_IsTerminated ) Sleep(10);
		Sleep(10);

		m_SvrThread = NULL;
	}
}








void CPortServer::svrClosePorts()
{
	svrReleaseDataBlocks();

	if( m_portComm ) 
	{
		m_portComm->prtCloseCommPort();
		delete m_portComm;
		m_portComm = NULL;
	}

	if( m_portNet )
	{
		m_portNet->prtCloseNetPort();
		delete m_portNet;
		m_portNet = NULL;
	}
}









void CPortServer::svrReleaseDataBlocks()
{
	while( !m_listNetReceive.IsEmpty() ) theApp.dblkRelease( (CDataBlock *)m_listNetReceive.RemoveHead() );
	while( !m_listNetTransmit.IsEmpty() ) theApp.dblkRelease( (CDataBlock *)m_listNetTransmit.RemoveHead() );

	return;
}







void CPortServer::svrCreateDeltaKey( CString *txtKeyDelta, CString *newEffectiveKey )
{
	CString	cstrNewKey;
	int		j,i,nIteration,complete,keylen = 0, keyTest;
	WORD	rnum;
	BYTE	kbyte, *keyText, *keyBuff;

	ASSERT( m_CryptKeyMaster.GetLength() > 0 );

	while( !keylen )
	{
		keylen = GetTickCount();

		while( keylen )
		{
			keyTest = (keylen & 255);

			if( keyTest >= 16 && keyTest <= 64 )
			{
				keylen = keyTest;
				break;
			}
			keylen = keylen / 2;
		}
	}




	srand( (unsigned)time( NULL ) );

	keyText = (BYTE *)new char[ (keylen*2)+1 ];
	keyBuff = (BYTE *)new char[ keylen+1 ];

	keyText[0]= 0;

	for(i=0; i< keylen; i++)
	{
		if( !(i&1) )
		{
			rnum = (WORD)rand();
			kbyte = (BYTE)(rnum & 255);
		}
		else kbyte = (BYTE)(rnum / 256);

		sprintf( (char *)&keyText[ strlen((const char *)keyText) ],"%02X", (unsigned char)kbyte );

		keyBuff[i]= kbyte;
	}

	/*
	FILE	*fout2= fopen("c:\\temp\\vcdeltakey.txt","wt");
	for(i=0; i<keylen; i++)
	{
		fprintf(fout2, "%3i   %02X\n", i+1, keyBuff[i]);
	}
	fclose(fout2);
	*/

	*txtKeyDelta = CString( (LPCTSTR)keyText );
	delete [] keyText;


	i= j= 0;
	complete = 0;
	nIteration = 0;
	cstrNewKey = "";

	while( complete != 3)
	{
		if( (nIteration++ & 1) == 0 )
		{
			cstrNewKey += CString( (TCHAR)keyBuff[ i++ ] );
			if(i == keylen) 
				complete|=1,i=0;
		}
		else
		{
			cstrNewKey += m_CryptKeyMaster.Mid( j++ , 1);
			if( j == m_CryptKeyMaster.GetLength() ) 
				complete|=2,j=0;
		}
	}

	delete [] keyBuff;

	/*
	FILE	*fout= fopen("c:\\temp\\vcoutkey.txt","wt");
	fprintf(fout,"master: [%s]\n", (LPCTSTR)m_CryptKeyMaster);
	for(i=0; i<cstrNewKey.GetLength(); i++)
	{
		fprintf(fout, "%3i   %02X\n", i+1, (unsigned char)cstrNewKey.GetAt(i));
	}
	fclose(fout);
	*/

	*newEffectiveKey= cstrNewKey;
	return;
}




void CPortServer::svrConnectIncomingNetPort( CString cstrUser, CAsyncSocket *newSocket, int keyIndexRcv, int keyIndexXmt )
{
	m_nKeyIndexNetRead	= keyIndexRcv;
	m_nKeyIndexNetWrite = keyIndexXmt;

	m_cstrConnectedUser = cstrUser;
	m_newSocket			= newSocket;

	svrSignalServiceThread();
}







void CPortServer::svrSignalServiceThread()
{
	DWORD	dwSuspend;

	while( (dwSuspend= ResumeThread( m_SvrThread->m_hThread )) > 1 )
		if( dwSuspend == 0xFFFFFFFF )
			return;

	while( m_criticalSignal != SIGNAL_RUNNING ) Sleep(10);

	m_criticalSignal = SIGNAL_LOCKED;

	return;
}






void CPortServer::svrThreadEntry()
{
	DWORD			tmark;
	int				nSleepLevel;

	if( !m_commBaud )
	{
		m_cstrServerStatus.LoadString( IDS_MSG_COMINFOINVALID );
		goto brkthread;
	}

	m_portComm = new CSerialPort(this);

	if( !(m_Options & COPT_OPENONCONNECT) )
	{
		if( !m_portComm->prtOpenCommPort( m_commPortName, m_commBaud, m_commParity, m_commDataBits, m_commStops, m_Options ) )
		{
			m_cstrServerStatus.LoadString( IDS_MSG_COMMALWAYSOPENFAILED );
			goto brkthread;
		}
	}

	while( ! m_TerminateFlag )
	{
		m_portNet = new CNetworkPort(this);
		m_cstrServerStatus.LoadString( IDS_MSG_CONNECTWAIT );

		m_boolIsConnected = FALSE;



		//
		// Make sure signal is initialized before we wait on it
		//
		while( m_criticalSignal != 	SIGNAL_LOCKED ) Sleep(50);

		SuspendThread( m_SvrThread->m_hThread );

		// somebody woke us so, signal we're running
		//
		m_criticalSignal = SIGNAL_RUNNING;

		if( m_TerminateFlag ) goto brkthread;		// catch termination signal

		ASSERT( m_newSocket );

		m_portNet->prtSetNetPort( m_newSocket );
		m_newSocket = NULL;



		if( m_Options & COPT_OPENONCONNECT )
		{
			if( !m_portComm->prtOpenCommPort( m_commPortName, m_commBaud, m_commParity, m_commDataBits, m_commStops, m_Options ) )
			{
				m_cstrServerStatus.LoadString( IDS_MSG_COMMOPENCONNECTFAILED );
				goto openfail;
			}
		}

		m_boolIsConnected = TRUE;
		m_cstrServerStatus.Format( IDS_MSG_CONNECTED, (LPCTSTR)m_cstrConnectedUser );


		
		//
		// Now connected to net with comm port open, service ports until
		// terminated or net connection is lost.
		//

		tmark		= 0;
		nSleepLevel	= 0;

		while( m_portNet->prtIsConnected() )
		{
			if( m_TerminateFlag ) goto brkthread;

			isTranceiving = FALSE;

			m_portNet->prtServiceNetPort();
			m_portComm->prtServiceCommPort();

			if( isTranceiving )
			{
				nSleepLevel = 0;
			}
			else
			{
				if( nSleepLevel != -1 )
				{
					if( nSleepLevel == 0 ) nSleepLevel++, tmark = GetTickCount();

					if( GetElapsedTicks(tmark) > 2000 ) 
					{
						// If no data is exchanged for 2 seconds, switch to slow polling mode
						//
						nSleepLevel = -1;
					}
					else
					{
						// Before the 2 seconds expire, stay in fast polling mode.
						//
						Sleep(5);
					}
				}
				else 
					Sleep(50);
			}
		}

		if( m_Options & COPT_OPENONCONNECT ) m_portComm->prtCloseCommPort();

openfail:
		m_portNet->prtCloseNetPort();
		delete m_portNet;
		m_portNet = NULL;

		svrReleaseDataBlocks();
	}


brkthread:
	svrClosePorts();
	m_IsTerminated	= TRUE;
}


// eof
