// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "SerialRedirect.h"

#include "SerialPorts.h"
#include "NetworkPorts.h"
#include "PortServer.h"

#include "Main.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif




/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_SIZE()
	ON_WM_DESTROY()
	ON_WM_CREATE()
	ON_WM_TIMER()
	ON_WM_GETMINMAXINFO()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	m_rectWinMinMax.left = m_rectWinMinMax.top = 0;
	m_rectWinMinMax.right = m_rectWinMinMax.bottom = 0;
}

CMainFrame::~CMainFrame()
{
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.hwndParent = theApp.m_wndInvisibleParent.m_hWnd;
	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers



int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	theApp.SetMainFrame(this);
	theApp.SetTaskbarIcon( 0 );

	timerScreenUpdate = SetTimer( 1, 500, NULL );
	return 0;
}




void CMainFrame::OnTimer(UINT nIDEvent) 
{
	CMain	*view = (CMain *)GetActiveView();

	view->TimerTick();

	CFrameWnd::OnTimer(nIDEvent);
}








LRESULT CMainFrame::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if( message == WM_TASKBARACTION )
	{
		if( lParam == WM_LBUTTONDBLCLK )
		{
			ActivateFrame();		// beat on window until it activates
			SetForegroundWindow();
		}
		return TRUE;
	}
	else if( message == WM_PAINT )
	{
		if( IsIconic() )
		{
			ShowWindow(SW_HIDE);
			return -1;
		}
	}

	return CFrameWnd::WindowProc(message, wParam, lParam);
}






void CMainFrame::OnSize(UINT nType, int cx, int cy) 
{
	if( nType == SIZE_MINIMIZED ) 
		ShowWindow( SW_HIDE );
	else
		CFrameWnd::OnSize(nType, cx, cy);
}








void CMainFrame::OnDestroy() 
{
	KillTimer( timerScreenUpdate );

    NOTIFYICONDATA tnid; 
 
    tnid.cbSize = sizeof(NOTIFYICONDATA); 
    tnid.hWnd = ((CWnd *)this)->m_hWnd; 
    tnid.uID = 0; 
         
    Shell_NotifyIcon(NIM_DELETE, &tnid); 

	CFrameWnd::OnDestroy();
}






void CMainFrame::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI) 
{
	if( m_rectWinMinMax.Width() )
	{
		lpMMI->ptMaxSize.x = lpMMI->ptMinTrackSize.x = lpMMI->ptMaxTrackSize.x = m_rectWinMinMax.Width();
		lpMMI->ptMaxSize.y = lpMMI->ptMinTrackSize.y = lpMMI->ptMaxTrackSize.y = m_rectWinMinMax.Height();
	}
	CFrameWnd::OnGetMinMaxInfo(lpMMI);
}





void CMainFrame::OnClose() 
{
	CPortServer		*cps;
	POSITION		pos;

	pos = theApp.m_listPortServers.GetHeadPosition();

	while(pos)
	{
		cps = (CPortServer *)theApp.m_listPortServers.GetNext(pos);

		if( cps->svrIsConnected() )
		{
			if( AfxMessageBox( IDS_MSG_USERS, MB_ICONQUESTION | MB_YESNO ) != IDYES ) 
				return;

			break;
		}
	}

	theApp.appShutdown();
	
	CFrameWnd::OnClose();
}
