package org.phoenix.jtools.jtelnet;

import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;
import javax.swing.*;
import javax.swing.border.*;

import javax.swing.event.*;

import org.phoenix.util.*;
import org.phoenix.jtools.util.*;


public class jtelnet extends JPanel implements Runnable {
	colorTextPane textArea;
	jtextfield name;
	jtextfield port;
	JTextField command;
	JCheckBox echo;

	JScrollBar vertical;
	boolean connected = false;
	public final static String dnsServer = "156.46.133.10";
	public final static int IAC = 255;
	public final static int WILL = 251;
	public final static int WONT = 252;
	public final static int DO = 253;
	public final static int DONT = 254;

	InputStream in;
	OutputStream out;
	
	String currentName;
	int currentPort;

	public static void main(String args[]) {
		JFrame f = new JFrame("JTelnet");
		f.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent evt) {
				System.exit(0);
			}
		});
		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
		f.setBounds(0, 0, dim.width, dim.height);
		f.getContentPane().add(new jtelnet());
		f.setVisible(true);
	}
	public jtelnet() {
		name = new jtextfield("Name", 15);
		port = new jtextfield("Port", 4);
		echo = new JCheckBox("Local Echo");
		echo.setSelected(false);
		JButton start = new JButton("Connect");
		start.addActionListener(new StartActionListener());
		JButton stop = new JButton("Disconnect");
		stop.addActionListener(new StopActionListener());
		
		JPanel top = new JPanel();
		top.setLayout(new FlowLayout());
		top.add(name);
		top.add(port);

		JPanel middle = new JPanel();
		middle.setLayout(new FlowLayout());
		middle.add(echo);
		middle.add(start);
		middle.add(stop);

		JPanel bottom = new JPanel();
		bottom.setLayout(new FlowLayout());
		bottom.add(new JLabel("Command:"));
		command = new JTextField(30);
		command.addActionListener(new TextActionListener());
		bottom.add(command);
		JButton send = new JButton("Send");
		send.addActionListener(new TextActionListener());
		bottom.add(send);

		JPanel p = new JPanel();
		p.setLayout(new BorderLayout());
		p.add(top, "North");
		p.add(middle, "Center");
		p.add(bottom, "South");

		textArea = new colorTextPane();

 		JScrollPane scrollArea = new JScrollPane(textArea);
		textArea.setScrollPane(scrollArea);


		setLayout(new BorderLayout());
		add(p, "North");
		add(scrollArea, "Center");
	}
	class StartActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			(new Thread((Runnable) jtelnet.this)).start();
		}
	}
	class StopActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			jtelnet.this.disconnect();
		}		
	}
	class TextActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			String send = command.getText();
			if (connected) {
				if (echo.isSelected()) {
					textArea.writeText(send, Color.orange);
				}
				for (int i = 0; i < send.length(); i++) {
					try {
						out.write(send.charAt(i));
					} catch (Exception ex) {
						textArea.writeText(ex.toString(), Color.red);
					}
				}
				try {
					out.write('\r');
					out.write('\n');
					out.flush();
				} catch (Exception ex) {
					textArea.writeText(ex.toString(), Color.red);
				}
			}
			command.setText("");
		}
	}
	static void handleControlChar(InputStream in, OutputStream out) {
		try {
			int c1 = in.read();
			int c2 = in.read();
			if (c1 == DO) {
				out.write(IAC);
				out.write(WONT);
				out.write(c2);
			}
		} catch (IOException e) {
		}
	}
	public void disconnect() {
			try {
				in.close();
			} catch (IOException ex) {
			}
			try {
				out.flush();
			} catch (IOException ex) {
			}
			try {
				out.close();
			} catch (IOException ex) {
			}
			textArea.writeText("Disconnected from  " + jtelnet.this.currentName + ": " + jtelnet.this.currentPort, Color.green);
			connected = false;
	}
	public void run() {
		if (connected) {
			disconnect();
		}
		currentName = this.name.getText();
		currentPort = Integer.parseInt(this.port.getText());

		try {
			Socket s = new Socket(currentName, currentPort);
			textArea.writeText("Connected to " + currentName + ": " + currentPort, Color.green);
			connected = true;
			in = s.getInputStream();
			out = s.getOutputStream();
		} catch(Exception e) {
			textArea.writeText("Connection to " + currentName + ": " + currentPort + " failed: " + e.toString(), Color.red);
			return;
		}
		while (connected) {
			try {
				int ch = in.read();
				if (ch == -1) {
					break;
				}
				if (ch == IAC) {
					handleControlChar(in, out);
				} else {
					textArea.write((char) ch + "", Color.blue);

				}
			} catch(Exception e) {
				break;
			}
		}
		if (connected) {
			disconnect();
		}
	}
}