package org.phoenix.jtools.jscanner;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

import org.phoenix.util.*;
import org.phoenix.jtools.util.*;
import org.phoenix.datatypes.*;

public class jscanner extends JPanel implements Runnable {

	jtextfield ip;

	jtextfield port;
	static String dnsServer = "207.250.6.10";
	
	scannerTableModel model;
	
	JLabel status;
	JProgressBar progress;

	boolean running = false;
	Thread t;
	public static void main(String args[]) {
		JFrame f = new JFrame("JScanner");
		f.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent evt) {
				System.exit(0);
			}
		});
		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
		f.setBounds(0, 0, dim.width, dim.height);
		f.getContentPane().add(new jscanner());
		f.setVisible(true);
	}
	public jscanner() {
		ip = new jtextfield("IP Address(es)", 20);
		port = new jtextfield("Port(s)", 7);
		JButton start = new JButton("Start");
		start.addActionListener(new StartActionListener());
		JButton clear = new JButton("Clear");
		clear.addActionListener(new ClearActionListener());
		JButton stop = new JButton("Stop");
		stop.addActionListener(new StopActionListener());
		
		JPanel p = new JPanel();
		p.setLayout(new FlowLayout());
		p.add(ip);
		p.add(port);
		p.add(start);
		p.add(stop);
		p.add(clear);

		setLayout(new BorderLayout());
		add(p, "North");

		model = new scannerTableModel();
		TableSorter sorter = new TableSorter(model);
		JTable table = new JTable(sorter);
		table.setDefaultRenderer(table.getColumnClass(0), new portRenderer());
		String vers = System.getProperty("java.version");
		sorterHeaderRenderer headerRenderer = new sorterHeaderRenderer(sorter);
		headerRenderer.setBackground(Color.lightGray);
		if (vers.compareTo("1.3") >= 0) {
			table.getTableHeader().setDefaultRenderer(headerRenderer);
		} else {
			TableColumnModel cm = table.getColumnModel();
			for (int i = 0; i < cm.getColumnCount(); i++) {
				TableColumn column = table.getColumnModel().getColumn(i);
				column.setHeaderRenderer(headerRenderer);
			}
		}
		sorter.addSorterListener(table);
		JScrollPane jsp = new JScrollPane(table);
		add(jsp, "Center");

		JPanel p2 = new JPanel();
		p2.setLayout(new BorderLayout());
		status = new JLabel("Ready");
		progress = new JProgressBar(0, 100);
		p2.add(status);
		p2.add(progress, "East");
		add(p2, "South");		
	}
	public void setDefaultDNS(String server) {
		dnsServer = server;
	}
	class StartActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			if (!running) {
				t = new Thread((Runnable) jscanner.this);
				t.start();
			}
		}
	}
	class ClearActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			model.clear();
		}
	}
	class StopActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			running = false;
			t.interrupt();
		}
	}
	public void run() {
		running = true;
		Vector names = parseIP(this.ip.getText());
		Vector ports = parsePort(this.port.getText());
		
		dnsBean dns = new dnsBean();
		scan:
		
		for (int i = 0; i < names.size(); i++) {
			String host = (String) names.elementAt(i);
			String ip = (String) names.elementAt(i);
			try {
				if (!Character.isDigit(ip.charAt(0))) {
					try {
						dns.setServer(dnsServer);
						dns.setName(ip);
						dns.setType(dnsBean.A);
						dns.send();
						ip = dns.getReply();
					} catch (SocketException e) {
						ip = "Unknown IP";
					} catch (UnknownHostException e) {
						ip = "Unknown IP";
					} catch (IOException e) {
						ip = "Unknown IP";
					}
				}

				dns.setServer(dnsServer);
				dns.setName(dns.reverse(ip));
				dns.setType(dnsBean.PTR);
				dns.send();
				host = dns.getReply();
				
			} catch (SocketException e) {
				host = ip;
			} catch (UnknownHostException e) {
				host = ip;
			} catch (IOException e) {
				host = ip;
			}
			
			for (int j = 0; j < ports.size(); j++) {
				int portNumber = Integer.parseInt((String) ports.elementAt(j));
				try {
					progress.setValue(((i * ports.size() + j) * 100) / (names.size() * ports.size()));
					status.setText("Checking " + host + " - " + ip + " - " + portNumber);
						
					if (check.check(ip, portNumber)) {
						model.add(new ip(ip), new domain(host), new port(portNumber, true));
					} else {
						model.add(new ip(ip), new domain(host), new port(portNumber, false));
					}
				} catch (NumberFormatException nfe) {
						try {
							model.add(new ip(ip), new domain(host), new port(portNumber, false));
						} catch (Exception ex) {
							model.add(new ip(0, 0, 0, 0), new domain(host), new port(portNumber, false));
						}
				} catch (Exception e) {
					System.out.println("Error: " + e.toString());
				}
				if (!running) {
					break scan;
				}
			}
		}
		progress.setValue(0);
		status.setText("Done");
		running = false;
	}
	Vector parseIP(String ipString) {
		Vector v = new Vector();
		
		StringTokenizer st = new StringTokenizer(ipString, ",");
		while (st.hasMoreTokens()) {
			String substring = st.nextToken().trim();
			if (substring.indexOf("-") != -1) {
				StringTokenizer subst = new StringTokenizer(substring, "-");
				Vector temp = new Vector();
				while (subst.hasMoreTokens()) {
					temp.addElement(subst.nextToken().trim());
				}
				if (temp.size() != 2) {
					JOptionPane.showMessageDialog(this,
						"Error parsing input",
						"Parse Error",
						JOptionPane.ERROR_MESSAGE);
					v = new Vector();
					break;
				} else {
					try {
						ip startip = new ip((String) temp.elementAt(0));
						ip endip = new ip((String) temp.elementAt(1));
						v.addElement(startip.toString());
						if (startip.compareTo(endip) < 0) {
							while (startip.compareTo(endip) < 0) {
								startip = startip.next();
								v.addElement(startip.toString());
							}
						} else {
							JOptionPane.showMessageDialog(this,
								"Error parsing input",
								"Parse Error",
								JOptionPane.ERROR_MESSAGE);
							v = new Vector();
							break;
						}
					} catch (NumberFormatException e) {
						JOptionPane.showMessageDialog(this,
							"Error parsing input",
							"Parse Error",
							JOptionPane.ERROR_MESSAGE);
						v = new Vector();
						break;
					}
				}
			} else {
				v.addElement(substring);
			}
		}
		return v;
	}
	Vector parsePort(String portString) {
		Vector v = new Vector();
		
		StringTokenizer st = new StringTokenizer(portString, ",");
		while (st.hasMoreTokens()) {
			String substring = st.nextToken().trim();
			if (substring.indexOf("-") != -1) {
				StringTokenizer subst = new StringTokenizer(substring, "-");
				Vector temp = new Vector();
				while (subst.hasMoreTokens()) {
					temp.addElement(subst.nextToken().trim());
				}
				if (temp.size() != 2) {
					JOptionPane.showMessageDialog(this,
						"Error parsing input",
						"Parse Error",
						JOptionPane.ERROR_MESSAGE);
					v = new Vector();
					break;
				} else {
					try {
						port startport = new port((String) temp.elementAt(0));
						port endport = new port((String) temp.elementAt(1));
						v.addElement(startport.toString());
						if (startport.compareTo(endport) < 0) {
							while (startport.compareTo(endport) < 0) {
								startport = startport.next();
								v.addElement(startport.toString());
							}
						} else {
							JOptionPane.showMessageDialog(this,
								"Error parsing input",
								"Parse Error",
								JOptionPane.ERROR_MESSAGE);
							v = new Vector();
							break;
						}
					} catch (NumberFormatException e) {
						JOptionPane.showMessageDialog(this,
							"Error parsing input",
							"Parse Error",
							JOptionPane.ERROR_MESSAGE);
						v = new Vector();
						break;
					}
				}
			} else {
				try {
					Integer.parseInt(substring);
					v.addElement(substring);
				} catch (NumberFormatException e) {
						JOptionPane.showMessageDialog(this,
							"Error parsing input",
							"Parse Error",
							JOptionPane.ERROR_MESSAGE);
						v = new Vector();
						break;
				}
			}
		}
		return v;
	}
	
}