/*
 * Decompiled with CFR 0.152.
 */
package org.phoenix.util;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.phoenix.util.TableElement;

public class TableSorter
extends AbstractTableModel
implements TableModelListener {
    protected TableModel model;
    Vector data = new Vector();
    boolean sorted = false;
    int column = -1;
    boolean descending = false;

    public TableSorter(TableModel tableModel) {
        this.model = tableModel;
        tableModel.addTableModelListener(this);
    }

    public void setSortColumn(int n, boolean bl) {
        this.sorted = true;
        this.column = n;
        this.descending = bl;
        Vector vector = this.data;
        this.data = new Vector();
        if (this.model.getRowCount() > 0) {
            int n2 = 0;
            while (n2 < this.model.getRowCount()) {
                if (vector != null && vector.size() == this.model.getRowCount()) {
                    TableElement tableElement = (TableElement)vector.elementAt(n2);
                    this.data.addElement(new TableElement(tableElement.getIndex(), this.model.getValueAt(tableElement.getIndex(), n)));
                } else {
                    this.data.addElement(new TableElement(n2, this.model.getValueAt(n2, n)));
                }
                ++n2;
            }
            Collections.sort(this.data);
            if (!bl) {
                Collections.reverse(this.data);
            }
        }
    }

    public String getColumnName(int n) {
        return this.model.getColumnName(n);
    }

    public int getSortedColumn() {
        int n = -1;
        if (this.sorted) {
            n = this.column;
        }
        return n;
    }

    public boolean isDescending() {
        if (this.sorted) {
            return this.descending;
        }
        return false;
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public int getRowCount() {
        if (this.data.size() != this.model.getRowCount()) {
            if (this.column != -1) {
                this.setSortColumn(this.getSortedColumn(), this.isDescending());
            } else {
                return this.model.getRowCount();
            }
        }
        return this.model.getRowCount();
    }

    public Object getValueAt(int n, int n2) {
        if (!this.sorted) {
            return this.model.getValueAt(n, n2);
        }
        TableElement tableElement = (TableElement)this.data.elementAt(n);
        return this.model.getValueAt(tableElement.getIndex(), n2);
    }

    public void addSorterListener(JTable jTable) {
        final JTable jTable2 = jTable;
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = jTable2.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable2.convertColumnIndexToModel(n);
                if (TableSorter.this.getSortedColumn() == n2) {
                    TableSorter.this.setSortColumn(n2, !TableSorter.this.isDescending());
                } else {
                    TableSorter.this.setSortColumn(n2, true);
                }
            }
        };
        JTableHeader jTableHeader = jTable.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }
}

