/*
 * Decompiled with CFR 0.152.
 */
package org.phoenix.jtools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.phoenix.jtools.about;
import org.phoenix.jtools.jlookup.jlookup;
import org.phoenix.jtools.jscanner.jscanner;
import org.phoenix.jtools.jtelnet.jtelnet;
import org.phoenix.util.splash;

public class jtools
extends JFrame
implements ActionListener {
    jscanner scanner = new jscanner();
    jlookup lookup = new jlookup();
    jtelnet telnet = new jtelnet();
    public static final String iniFile = "jtools.ini";
    static String dnsServer = "207.250.6.10";

    public static void main(String[] stringArray) {
        jtools jtools2 = new jtools();
        splash splash2 = new splash(jtools2.getClass().getResource("resources/jtoolsSplash.gif"));
        long l = System.currentTimeMillis();
        int n = 0;
        while (System.currentTimeMillis() - l < 1500L) {
            ++n;
        }
        jtools2.show();
        splash2.dispose();
    }

    public jtools() {
        this.setTitle("JTools");
        this.loadDNS();
        this.lookup.setDefaultDNS(dnsServer);
        this.scanner.setDefaultDNS(dnsServer);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setBounds(0, 0, dimension.width, dimension.height);
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        jTabbedPane.addTab("Port Scan", null, this.scanner, "Port Scan - a utility to scan tcp ports");
        jTabbedPane.addTab("Dns Lookup", null, this.lookup, "Dns Lookup - a dns client utility");
        jTabbedPane.addTab("Telnet", null, this.telnet, "Telnet - a telnet client utility");
        this.getContentPane().add(jTabbedPane);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.setJMenuBar(this.getMenu());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getText();
        if (string.equals("Quit")) {
            System.exit(0);
        } else if (string.equals("Preferences...")) {
            this.editDNS();
        } else if (string.equals("About...")) {
            about about2 = new about(this.getClass().getResource("resources/aboutHeader.gif"));
            JDialog jDialog = new JDialog(this, "About Jtools", true);
            jDialog.getContentPane().add(about2);
            about2.setParent(jDialog);
            jDialog.setResizable(false);
            jDialog.doLayout();
            ((Component)jDialog).setBounds(0, 0, about2.getSize().width, about2.getSize().height);
            ((Component)jDialog).setLocation((this.getSize().width - jDialog.getSize().width) / 2, (this.getSize().height - jDialog.getSize().height) / 2);
            jDialog.show();
        }
    }

    public JMenuBar getMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Preferences...");
        JMenuItem jMenuItem2 = new JMenuItem("Quit");
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenuItem.addActionListener(this);
        jMenuItem2.addActionListener(this);
        JMenu jMenu2 = new JMenu("Help");
        JMenuItem jMenuItem3 = new JMenuItem("About...");
        jMenu2.add(jMenuItem3);
        jMenuItem3.addActionListener(this);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        return jMenuBar;
    }

    public void editDNS() {
        JPanel jPanel = new JPanel();
        final JTextField jTextField = new JTextField(dnsServer, 20);
        jPanel.add(new JLabel("Default DNS server"));
        jPanel.add(jTextField);
        final JDialog jDialog = new JDialog((Frame)this, true);
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dnsServer = jTextField.getText();
                jtools.this.lookup.setDefaultDNS(dnsServer);
                jtools.this.scanner.setDefaultDNS(dnsServer);
                jDialog.dispose();
                jtools.this.saveDNS();
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("North", jPanel);
        jPanel3.add("South", jPanel2);
        jDialog.getContentPane().add(jPanel3);
        jDialog.doLayout();
        ((Component)jDialog).setLocation((this.getSize().width - jPanel3.getPreferredSize().width) / 2, (this.getSize().height - jPanel3.getPreferredSize().height) / 2);
        jDialog.pack();
        jDialog.show();
    }

    public void loadDNS() {
        try {
            FileInputStream fileInputStream = new FileInputStream(iniFile);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            dnsServer = properties.getProperty("dnsServer");
        }
        catch (Exception exception) {
            System.out.println("Error Loading Properties");
        }
    }

    public void saveDNS() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(iniFile);
            Properties properties = new Properties();
            properties.setProperty("dnsServer", dnsServer);
            properties.store(fileOutputStream, "");
        }
        catch (Exception exception) {
            System.out.println("Error Saving Properties");
        }
    }
}

