/*
 * Decompiled with CFR 0.152.
 */
package org.phoenix.jtools.jscanner;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.phoenix.datatypes.domain;
import org.phoenix.datatypes.ip;
import org.phoenix.datatypes.port;
import org.phoenix.jtools.jscanner.portRenderer;
import org.phoenix.jtools.jscanner.scannerTableModel;
import org.phoenix.jtools.util.check;
import org.phoenix.util.TableSorter;
import org.phoenix.util.dnsBean;
import org.phoenix.util.jtextfield;
import org.phoenix.util.sorterHeaderRenderer;

public class jscanner
extends JPanel
implements Runnable {
    jtextfield ip = new jtextfield("IP Address(es)", 20);
    jtextfield port = new jtextfield("Port(s)", 7);
    static String dnsServer = "207.250.6.10";
    scannerTableModel model;
    JLabel status;
    JProgressBar progress;
    boolean running = false;
    Thread t;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JScanner");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setBounds(0, 0, dimension.width, dimension.height);
        jFrame.getContentPane().add(new jscanner());
        ((Component)jFrame).setVisible(true);
    }

    public jscanner() {
        Object object;
        JButton jButton = new JButton("Start");
        jButton.addActionListener(new StartActionListener());
        JButton jButton2 = new JButton("Clear");
        jButton2.addActionListener(new ClearActionListener());
        JButton jButton3 = new JButton("Stop");
        jButton3.addActionListener(new StopActionListener());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.ip);
        jPanel.add(this.port);
        jPanel.add(jButton);
        jPanel.add(jButton3);
        jPanel.add(jButton2);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.model = new scannerTableModel();
        TableSorter tableSorter = new TableSorter(this.model);
        JTable jTable = new JTable(tableSorter);
        jTable.setDefaultRenderer(jTable.getColumnClass(0), new portRenderer());
        String string = System.getProperty("java.version");
        sorterHeaderRenderer sorterHeaderRenderer2 = new sorterHeaderRenderer(tableSorter);
        sorterHeaderRenderer2.setBackground(Color.lightGray);
        if (string.compareTo("1.3") >= 0) {
            jTable.getTableHeader().setDefaultRenderer(sorterHeaderRenderer2);
        } else {
            object = jTable.getColumnModel();
            int n = 0;
            while (n < object.getColumnCount()) {
                TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
                tableColumn.setHeaderRenderer(sorterHeaderRenderer2);
                ++n;
            }
        }
        tableSorter.addSorterListener(jTable);
        object = new JScrollPane(jTable);
        this.add((Component)object, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.status = new JLabel("Ready");
        this.progress = new JProgressBar(0, 100);
        jPanel2.add(this.status);
        jPanel2.add((Component)this.progress, "East");
        this.add((Component)jPanel2, "South");
    }

    public void setDefaultDNS(String string) {
        dnsServer = string;
    }

    public void run() {
        this.running = true;
        Vector vector = this.parseIP(this.ip.getText());
        Vector vector2 = this.parsePort(this.port.getText());
        dnsBean dnsBean2 = new dnsBean();
        int n = 0;
        block13: while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            String string2 = (String)vector.elementAt(n);
            try {
                if (!Character.isDigit(string2.charAt(0))) {
                    try {
                        dnsBean2.setServer(dnsServer);
                        dnsBean2.setName(string2);
                        dnsBean2.setType('\u0001');
                        dnsBean2.send();
                        string2 = dnsBean2.getReply();
                    }
                    catch (SocketException socketException) {
                        string2 = "Unknown IP";
                    }
                    catch (UnknownHostException unknownHostException) {
                        string2 = "Unknown IP";
                    }
                    catch (IOException iOException) {
                        string2 = "Unknown IP";
                    }
                }
                dnsBean2.setServer(dnsServer);
                dnsBean2.setName(dnsBean2.reverse(string2));
                dnsBean2.setType('\f');
                dnsBean2.send();
                string = dnsBean2.getReply();
            }
            catch (SocketException socketException) {
                string = string2;
            }
            catch (UnknownHostException unknownHostException) {
                string = string2;
            }
            catch (IOException iOException) {
                string = string2;
            }
            int n2 = 0;
            while (n2 < vector2.size()) {
                int n3 = Integer.parseInt((String)vector2.elementAt(n2));
                try {
                    this.progress.setValue((n * vector2.size() + n2) * 100 / (vector.size() * vector2.size()));
                    this.status.setText("Checking " + string + " - " + string2 + " - " + n3);
                    if (check.check(string2, n3)) {
                        this.model.add(new ip(string2), new domain(string), new port(n3, true));
                    } else {
                        this.model.add(new ip(string2), new domain(string), new port(n3, false));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        this.model.add(new ip(string2), new domain(string), new port(n3, false));
                    }
                    catch (Exception exception) {
                        this.model.add(new ip(0, 0, 0, 0), new domain(string), new port(n3, false));
                    }
                }
                catch (Exception exception) {
                    System.out.println("Error: " + exception.toString());
                }
                if (!this.running) break block13;
                ++n2;
            }
            ++n;
        }
        this.progress.setValue(0);
        this.status.setText("Done");
        this.running = false;
    }

    Vector parseIP(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.indexOf("-") != -1) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-");
                Vector<String> vector2 = new Vector<String>();
                while (stringTokenizer2.hasMoreTokens()) {
                    vector2.addElement(stringTokenizer2.nextToken().trim());
                }
                if (vector2.size() != 2) {
                    JOptionPane.showMessageDialog(this, "Error parsing input", "Parse Error", 0);
                    vector = new Vector();
                    break;
                }
                try {
                    ip ip2 = new ip((String)vector2.elementAt(0));
                    ip ip3 = new ip((String)vector2.elementAt(1));
                    vector.addElement(ip2.toString());
                    if (ip2.compareTo(ip3) < 0) {
                        while (ip2.compareTo(ip3) < 0) {
                            ip2 = ip2.next();
                            vector.addElement(ip2.toString());
                        }
                        continue;
                    }
                    JOptionPane.showMessageDialog(this, "Error parsing input", "Parse Error", 0);
                    vector = new Vector();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Error parsing input", "Parse Error", 0);
                    vector = new Vector();
                }
                break;
            }
            vector.addElement(string2);
        }
        return vector;
    }

    Vector parsePort(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.indexOf("-") != -1) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-");
                Vector<String> vector2 = new Vector<String>();
                while (stringTokenizer2.hasMoreTokens()) {
                    vector2.addElement(stringTokenizer2.nextToken().trim());
                }
                if (vector2.size() != 2) {
                    JOptionPane.showMessageDialog(this, "Error parsing input", "Parse Error", 0);
                    vector = new Vector();
                    break;
                }
                try {
                    port port2 = new port((String)vector2.elementAt(0));
                    port port3 = new port((String)vector2.elementAt(1));
                    vector.addElement(port2.toString());
                    if (port2.compareTo(port3) < 0) {
                        while (port2.compareTo(port3) < 0) {
                            port2 = port2.next();
                            vector.addElement(port2.toString());
                        }
                        continue;
                    }
                    JOptionPane.showMessageDialog(this, "Error parsing input", "Parse Error", 0);
                    vector = new Vector();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Error parsing input", "Parse Error", 0);
                    vector = new Vector();
                }
                break;
            }
            try {
                Integer.parseInt(string2);
                vector.addElement(string2);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Error parsing input", "Parse Error", 0);
                vector = new Vector();
                break;
            }
        }
        return vector;
    }

    class StopActionListener
    implements ActionListener {
        StopActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            jscanner.this.running = false;
            jscanner.this.t.interrupt();
        }
    }

    class ClearActionListener
    implements ActionListener {
        ClearActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            jscanner.this.model.clear();
        }
    }

    class StartActionListener
    implements ActionListener {
        StartActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!jscanner.this.running) {
                jscanner.this.t = new Thread(jscanner.this);
                jscanner.this.t.start();
            }
        }
    }
}

