/*
 * Decompiled with CFR 0.152.
 */
package org.phoenix.jtools.jlookup;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.phoenix.datatypes.domain;
import org.phoenix.jtools.jlookup.lookupTableModel;
import org.phoenix.util.TableSorter;
import org.phoenix.util.dnsBean;
import org.phoenix.util.jtextfield;
import org.phoenix.util.sorterHeaderRenderer;

public class jlookup
extends JPanel
implements Runnable {
    lookupTableModel model;
    jtextfield name = new jtextfield("Name", 15);
    jtextfield server = new jtextfield("Server", 15);
    JComboBox type;
    static String dnsServer = "156.46.133.10";
    JLabel status;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JLookup");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setBounds(0, 0, dimension.width, dimension.height);
        jFrame.getContentPane().add(new jlookup());
        ((Component)jFrame).setVisible(true);
    }

    public jlookup() {
        Object object;
        String[] stringArray = new String[]{"A", "NS", "CNAME", "SOA", "PTR", "HINFO", "MX", "AXFR"};
        this.type = new JComboBox<String>(stringArray);
        JButton jButton = new JButton("Lookup");
        jButton.addActionListener(new LookupActionListener());
        JButton jButton2 = new JButton("Clear");
        jButton2.addActionListener(new ClearActionListener());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.type);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.name, "North");
        jPanel2.add((Component)this.server, "Center");
        jPanel2.add((Component)jPanel, "South");
        this.model = new lookupTableModel();
        TableSorter tableSorter = new TableSorter(this.model);
        JTable jTable = new JTable(tableSorter);
        String string = System.getProperty("java.version");
        sorterHeaderRenderer sorterHeaderRenderer2 = new sorterHeaderRenderer(tableSorter);
        sorterHeaderRenderer2.setBackground(Color.lightGray);
        if (string.compareTo("1.3") >= 0) {
            jTable.getTableHeader().setDefaultRenderer(sorterHeaderRenderer2);
        } else {
            object = jTable.getColumnModel();
            int n = 0;
            while (n < object.getColumnCount()) {
                TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
                tableColumn.setHeaderRenderer(sorterHeaderRenderer2);
                ++n;
            }
        }
        tableSorter.addSorterListener(jTable);
        object = new JScrollPane(jTable);
        this.status = new JLabel();
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.status);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel2, "North");
        this.add((Component)object, "Center");
        this.add((Component)jPanel3, "South");
    }

    public void setDefaultDNS(String string) {
        dnsServer = string;
        if (string != null) {
            this.server.setText(string);
        }
    }

    public void run() {
        String string = this.name.getText();
        String string2 = this.server.getText();
        this.status.setText("Looking up " + string);
        try {
            dnsBean dnsBean2 = new dnsBean();
            dnsBean2.setServer(string2);
            dnsBean2.setName(string);
            dnsBean2.setType('\u0001');
            String string3 = (String)this.type.getSelectedItem();
            if (string3.equals("A")) {
                dnsBean2.setType('\u0001');
            } else if (string3.equals("NS")) {
                dnsBean2.setType('\u0002');
            } else if (string3.equals("CNAME")) {
                dnsBean2.setType('\u0005');
            } else if (string3.equals("SOA")) {
                dnsBean2.setType('\u0006');
            } else if (string3.equals("PTR")) {
                dnsBean2.setName(dnsBean2.reverse(string));
                dnsBean2.setType('\f');
            } else if (string3.equals("HINFO")) {
                dnsBean2.setType('\r');
            } else if (string3.equals("MX")) {
                dnsBean2.setType('\u000f');
            } else if (string3.equals("AXFR")) {
                dnsBean2.setDataConnection(2);
                dnsBean2.setType('\u00fc');
            }
            dnsBean2.send();
            if (!string3.equals("AXFR")) {
                dnsBean2.getReply();
            }
            Vector vector = dnsBean2.getRNames();
            Vector vector2 = dnsBean2.getTypes();
            Vector vector3 = dnsBean2.getAnswers();
            if (vector.size() > 0) {
                int n = 0;
                while (n < vector.size()) {
                    this.model.add(new domain(vector.elementAt(n).toString()), vector2.elementAt(n).toString(), vector3.elementAt(n).toString());
                    ++n;
                }
            } else {
                JOptionPane.showMessageDialog(this, "Nameserver returned 0 records", "Query Error", 0);
            }
            this.status.setText("Done");
        }
        catch (SocketException socketException) {
            this.status.setText(string + ": Error - " + socketException.toString() + "\n");
        }
        catch (UnknownHostException unknownHostException) {
            JOptionPane.showMessageDialog(this, "Host is Unknown", "Query Error", 0);
            this.status.setText(string + ": Error - " + unknownHostException.toString() + "\n");
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Nameserver returned an Error", "Query Error", 0);
            this.status.setText(string + ": Error - " + iOException.toString() + "\n");
        }
    }

    class ClearActionListener
    implements ActionListener {
        ClearActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            jlookup.this.model.clear();
        }
    }

    class LookupActionListener
    implements ActionListener {
        LookupActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new Thread(jlookup.this).start();
        }
    }
}

