/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletException;
import stec.iws.AdminContext;
import stec.iws.AdminUtils;
import stec.iws.IOManager;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public class AdminMessages {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";

    protected static void displayMessageEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("message_entry");
        Hashtable hashtable = adminContext.data;
        String string = adminContext.template;
        string = Utils.getItem(IOManager.getHandler(iws.basedir, string));
        string = DString.replace(string, "%error_message%", adminContext.error_message.toString());
        Object object = hashtable.get("error_code");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%error_code%", (String)object);
        object = hashtable.get("title");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%title%", (String)object);
        object = hashtable.get("message");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%message%", (String)object);
        object = hashtable.get("key");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%key%", (String)object);
        AdminUtils.sendItem(adminContext.response, string);
    }

    protected static void displayMessages(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("messages");
        AdminUtils.displayList(adminContext);
    }

    protected static void doMessageEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("message_entry");
        String string = AdminUtils.getAction(adminContext);
        if (string == null) {
            if (AdminMessages.verifyMessageEntry(adminContext)) {
                AdminMessages.updateMessageEntry(adminContext);
                adminContext.setForm("messages");
                AdminUtils.displayList(adminContext);
                return;
            }
        } else {
            if (string.equals("help")) {
                AdminUtils.help(adminContext, "messages", "#entry");
                return;
            }
            if (string.equals("ok")) {
                if (AdminMessages.verifyMessageEntry(adminContext)) {
                    AdminMessages.updateMessageEntry(adminContext);
                    adminContext.setForm("messages");
                    AdminUtils.displayList(adminContext);
                    return;
                }
            } else if (string.equals("cancel")) {
                adminContext.setForm("messages");
                AdminUtils.displayList(adminContext);
                return;
            }
        }
        AdminMessages.displayMessageEntry(adminContext);
    }

    protected static void doMessages(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("messages");
        if (AdminUtils.doListAction(adminContext)) {
            return;
        }
        if (adminContext.action.equals("add")) {
            AdminMessages.displayMessageEntry(adminContext);
            return;
        }
        if (adminContext.action.equals("edit")) {
            if (AdminUtils.doEdit(adminContext)) {
                AdminMessages.parseMessageEntry(adminContext);
                AdminMessages.displayMessageEntry(adminContext);
                return;
            }
        } else {
            AdminUtils.displayList(adminContext);
        }
    }

    protected static Hashtable getMessageEntry(AdminContext adminContext, Hashtable hashtable) {
        Object v = hashtable.get("key");
        if (v == null) {
            return hashtable;
        }
        String string = (String)v;
        hashtable.put("key", string);
        hashtable.put("error_code", string);
        String string2 = (String)hashtable.get("entry");
        int n = string2.indexOf(59);
        if (n == -1) {
            hashtable.put("title", string2);
        } else {
            hashtable.put("title", string2.substring(0, n));
            String string3 = string2.substring(n + 1);
            hashtable.put("message", string3);
        }
        return hashtable;
    }

    protected static void parseMessageEntry(AdminContext adminContext) {
        Hashtable hashtable = adminContext.data;
        AdminMessages.getMessageEntry(adminContext, hashtable);
    }

    protected static void updateMessageEntry(AdminContext adminContext) throws IOException, ServletException {
        String string;
        Hashtable hashtable = adminContext.data;
        String string2 = (String)hashtable.get("error_code");
        String string3 = (String)hashtable.get("title");
        Object v = hashtable.get("message");
        if (v != null && (string = DString.trim((String)v)).length() > 0) {
            string = DString.replace(string, "\n", " ");
            string = DString.replace(string, "\r", "");
            string3 = String.valueOf(string3) + ";" + string;
        }
        hashtable = AdminUtils.getSessionData(adminContext, "messages");
        hashtable.put(string2, string3);
        AdminUtils.putSessionData(adminContext, "messages", hashtable);
    }

    protected static boolean verifyMessageEntry(AdminContext adminContext) throws IOException, ServletException {
        String string;
        Hashtable hashtable = AdminMessages.getMessageEntry(adminContext, AdminUtils.getFormData(adminContext, "messages"));
        adminContext.error_message.setLength(0);
        Hashtable hashtable2 = adminContext.data;
        String string2 = "";
        String string3 = adminContext.request.getParameter("key");
        if (string3 != null) {
            string2 = string3;
            hashtable2.put("key", string2);
        }
        if ((string3 = adminContext.request.getParameter("error_code")) == null) {
            adminContext.error_message.append("Error Code is required.<br>");
            string3 = hashtable.get("error_code");
            if (string3 != null) {
                hashtable2.put("error_code", string3);
            }
        } else {
            string = DString.trim(string3);
            if (string.length() == 0) {
                adminContext.error_message.append("Error Code is required.<br>");
                string3 = hashtable.get("error_code");
                if (string3 != null) {
                    hashtable2.put("error_code", string3);
                }
            } else if (string2.equals(string)) {
                hashtable2.put("error_code", string);
            } else if (AdminUtils.getFormEntry(adminContext, "messages", string) != null) {
                adminContext.error_message.append("Message already exists.<br>");
                string3 = hashtable.get("error_code");
                if (string3 != null) {
                    hashtable2.put("error_code", string3);
                }
            } else {
                hashtable2.put("error_code", string);
            }
        }
        if ((string3 = adminContext.request.getParameter("title")) == null) {
            adminContext.error_message.append("Title is required.<br>");
            string3 = hashtable.get("title");
            if (string3 != null) {
                hashtable2.put("title", string3);
            }
        } else {
            string = DString.trim(string3);
            if (string.length() == 0) {
                adminContext.error_message.append("Title is required.<br>");
                string3 = hashtable.get("title");
                if (string3 != null) {
                    hashtable2.put("title", string3);
                }
            } else {
                hashtable2.put("title", string3);
            }
        }
        if ((string3 = adminContext.request.getParameter("message")) != null && (string = DString.trim(string3)).length() > 0) {
            hashtable2.put("message", string3);
        }
        return adminContext.error_message.length() <= 0;
    }
}

