/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;

public class CaptureClipboard
extends Thread
implements ClipboardOwner {
    private Clipboard clipboard;
    private String lastClipContents = "";
    private PlayListEditor thisPlayListEditor;

    public CaptureClipboard(Component component) {
        this.thisPlayListEditor = (PlayListEditor)component;
        this.clipboard = component.getToolkit().getSystemClipboard();
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        System.err.println("Clipboard lost ownership...");
    }

    public void run() {
        this.checkNewClips();
    }

    public void checkNewClips() {
        while (true) {
            Transferable transferable;
            if (!this.thisPlayListEditor.captureClipboardTracks || (transferable = this.clipboard.getContents(this)) == null || !transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                continue;
            }
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                if (string.indexOf(this.lastClipContents) < 0) {
                    System.err.println(string);
                    File file = new File(string);
                    if (file.exists()) {
                        PlayListEditor.thePlayList.addTrack(file.getAbsolutePath());
                    } else {
                        PlayListEditor.thePlayList.addTrack(string);
                    }
                    this.thisPlayListEditor.setPlayList(PlayListEditor.thePlayList);
                }
                this.lastClipContents = string;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }
}

