/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer.video;

import com.sun.media.BasicPlugIn;
import com.sun.media.format.AviVideoFormat;
import com.sun.media.format.WavAudioFormat;
import com.sun.media.multiplexer.BasicMux;
import com.sun.media.parser.BasicPullParser;
import com.sun.media.util.ByteBuffer;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.ContentDescriptor;

public class AVIMux
extends BasicMux {
    private int[] suggestedBufferSizes;
    private int[] suggestedBufferSizeOffsets;
    private int[] scaleOffsets;
    private boolean[] endOfMediaStatus;
    private int numberOfEoms;
    private int width;
    private int height;
    private static final int MAX_FRAMES_STORED = 20000;
    private static final int AVIH_HEADER_LENGTH = 56;
    private static final int STRH_HEADER_LENGTH = 56;
    private static final int STRF_VIDEO_HEADER_LENGTH = 40;
    private static final int STRF_AUDIO_HEADER_LENGTH = 16;
    static final String AUDIO = "auds";
    static final String VIDEO = "vids";
    static final int AVIF_HASINDEX = 16;
    static final int AVIF_MUSTUSEINDEX = 32;
    static final int AVIF_ISINTERLEAVED = 256;
    static final int AVIF_WASCAPTUREFILE = 65536;
    static final int AVIF_COPYRIGHTED = 131072;
    static final int AVIF_KEYFRAME = 16;
    private int usecPerFrame = 100000;
    private float frameRate = -1.0f;
    private int maxBytesPerSecond;
    private int paddingGranularity;
    private int flags = 48;
    private int totalDataLength;
    private int totalFrames;
    private int totalVideoFrames;
    private int initialFrames;
    private int[] reserved = new int[4];
    private Vector chunkList = new Vector(1);
    private final int BUF_SIZE = 16384;
    private ByteBuffer bbuf = new ByteBuffer(16384);
    private int chunkOffset = 4;
    private int moviOffset;
    private int avihOffset;
    private int hdrlSizeOffset;
    private int totalStrlLength;
    static final String LISTRECORDCHUNK = "rec ";
    static final String VIDEO_MAGIC = "dc";
    static final String VIDEO_MAGIC_JPEG = "db";
    static final String VIDEO_MAGIC_IV32a = "iv";
    static final String VIDEO_MAGIC_IV32b = "32";
    static final String VIDEO_MAGIC_IV31 = "31";
    static final String VIDEO_MAGIC_CVID = "id";
    static final String AUDIO_MAGIC = "wb";
    Format littleEndian = new AudioFormat(null, -1.0, -1, -1, 0, -1);
    Format signed = new AudioFormat(null, -1.0, -1, -1, 0, 1);
    Format unsigned = new AudioFormat(null, -1.0, -1, -1, 0, 0);

    public AVIMux() {
        this.supportedInputs = new Format[2];
        this.supportedInputs[0] = new AudioFormat(null);
        this.supportedInputs[1] = new VideoFormat(null);
        this.supportedOutputs = new ContentDescriptor[1];
        this.supportedOutputs[0] = new ContentDescriptor("video.x_msvideo");
        this.chunkList.addElement(this.bbuf);
    }

    private Format[] createRGBFormats(Dimension size) {
        int NS = -1;
        Format[] rgbFormats = new Format[]{new RGBFormat(size, size.width * size.height * 2, Format.byteArray, NS, 16, 0, 31744, 992, 31, 2, size.width * 2, 1, 1), new RGBFormat(size, size.width * size.height * 3, Format.byteArray, NS, 24, 0, 3, 2, 1, 3, size.width * 3, 1, NS), new RGBFormat(size, size.width * size.height * 4, Format.byteArray, NS, 32, 0, 3, 2, 1, 4, size.width * 4, 1, NS)};
        return rgbFormats;
    }

    private Format[] createYUVFormats(Dimension size) {
        int NS = -1;
        Format[] yuvFormats = new Format[]{new YUVFormat(size, size.width * size.height * 2, Format.byteArray, NS, 32, size.width * 2, size.width * 2, 1, 0, 2), new YUVFormat(size, size.width * size.height * 2, Format.byteArray, NS, 32, size.width * 2, size.width * 2, 0, 1, 3), new YUVFormat(size, size.width * size.height * 3 / 2, Format.byteArray, NS, 2, size.width, size.width / 2, 0, size.width * size.height, size.width * size.height * 5 / 4), new YUVFormat(size, size.width * size.height * 3 / 2, Format.byteArray, NS, 2, size.width, size.width / 2, 0, size.width * size.height * 5 / 4, size.width * size.height)};
        return yuvFormats;
    }

    public String getName() {
        return "AVI Multiplexer";
    }

    /*
     * Unable to fully structure code
     */
    public Format setInputFormat(Format input, int trackID) {
        block32: {
            block31: {
                reason = null;
                if (!(input instanceof AudioFormat)) break block31;
                af = (AudioFormat)input;
                wavAudioFormat = null;
                if (input instanceof WavAudioFormat) {
                    wavAudioFormat = (WavAudioFormat)input;
                }
                if ((encoding = af.getEncoding()) == null) {
                    return null;
                }
                if (encoding.equals("LINEAR")) {
                    if (af.getSampleSizeInBits() > 8) {
                        if (af.getEndian() == 1) {
                            return null;
                        }
                        if (af.getSigned() == 0) {
                            return null;
                        }
                        if (af.getEndian() == -1 || af.getSigned() == -1) {
                            input = (AudioFormat)af.intersects(this.signed);
                        }
                    } else {
                        if (af.getSigned() == 1) {
                            return null;
                        }
                        if (af.getEndian() == -1 || af.getSigned() == -1) {
                            input = (AudioFormat)af.intersects(this.unsigned);
                        }
                    }
                }
                if ((formatTag = (Integer)WavAudioFormat.reverseFormatMapper.get(encoding)) == null) {
                    reason = "Cannot handle format";
                    return null;
                }
                wFormatTag = formatTag.shortValue();
                switch (wFormatTag) {
                    case 2: 
                    case 17: 
                    case 49: {
                        if (wavAudioFormat == null) {
                            reason = "A WavAudioFormat is required  to provide encoding specific information for this encoding " + wFormatTag;
                            return null;
                        }
                        ** GOTO lbl58
                    }
                    default: {
                        if (reason == null) break block32;
                    }
                }
            }
            if (input instanceof VideoFormat) {
                vf = (VideoFormat)input;
                encoding = vf.getEncoding();
                size = vf.getSize();
                if (encoding == null) {
                    return null;
                }
                if (encoding.equalsIgnoreCase("rgb")) {
                    if (BasicPlugIn.matches(vf, this.createRGBFormats(size)) == null) {
                        return null;
                    }
                } else if (encoding.equalsIgnoreCase("yuv")) {
                    if (BasicPlugIn.matches(vf, this.createYUVFormats(size)) == null) {
                        return null;
                    }
                } else {
                    if (encoding.equalsIgnoreCase("jpeg")) {
                        return null;
                    }
                    if (encoding.length() > 4) {
                        return null;
                    }
                }
                this.frameRate = vf.getFrameRate();
                if (this.frameRate > 0.0f) {
                    this.usecPerFrame = (int)(1.0f / this.frameRate * 1000000.0f);
                }
            } else {
                reason = "Can only support Audio and Video formats";
            }
lbl58:
            // 3 sources

            if (reason == null) break block32;
            return null;
        }
        this.inputs[trackID] = input;
        return input;
    }

    public int setNumTracks(int nTracks) {
        if (nTracks > 2) {
            return 2;
        }
        this.suggestedBufferSizeOffsets = new int[nTracks];
        this.suggestedBufferSizes = new int[nTracks];
        this.endOfMediaStatus = new boolean[nTracks];
        int i2 = 0;
        while (i2 < nTracks) {
            this.suggestedBufferSizes[i2] = -1;
            this.suggestedBufferSizeOffsets[i2] = -1;
            ++i2;
        }
        return super.setNumTracks(nTracks);
    }

    public synchronized int doProcess(Buffer buffer, int trackID) {
        if (buffer.isEOM()) {
            ++this.numberOfEoms;
            if (this.numberOfEoms >= this.numTracks) {
                return super.doProcess(buffer, trackID);
            }
            return 0;
        }
        if (buffer.getData() == null) {
            return 0;
        }
        boolean isVideoFormat = buffer.getFormat() instanceof VideoFormat;
        int length = buffer.getLength();
        int pad = (length & 1) > 0 ? 1 : 0;
        String aviEncodingMagic = this.getAviEncodingMagic(trackID, isVideoFormat);
        this.bufClear();
        this.bufWriteBytes(aviEncodingMagic);
        this.bufWriteIntLittleEndian(length + pad);
        this.bufFlush();
        this.write((byte[])buffer.getData(), buffer.getOffset(), length);
        if (pad > 0) {
            this.bufClear();
            this.bufWriteByte((byte)0);
            this.bufFlush();
        }
        this.totalDataLength += length + pad;
        if (length > this.suggestedBufferSizes[trackID]) {
            this.suggestedBufferSizes[trackID] = length;
        }
        if (this.bbuf.length == 16384) {
            this.bbuf = new ByteBuffer(16384);
            this.chunkList.addElement(this.bbuf);
        }
        this.bbuf.writeBytes(aviEncodingMagic);
        int flag = (buffer.getFlags() & 0x10) != 0 ? 16 : 0;
        this.bbuf.writeIntLittleEndian(flag);
        this.bbuf.writeIntLittleEndian(this.chunkOffset);
        this.bbuf.writeIntLittleEndian(length);
        this.chunkOffset += length + pad + 8;
        if (isVideoFormat) {
            ++this.totalVideoFrames;
        }
        ++this.totalFrames;
        return 0;
    }

    protected void writeHeader() {
        this.bufClear();
        this.bufWriteBytes("RIFF");
        this.bufSkip(4);
        this.bufWriteBytes("AVI ");
        this.bufWriteBytes("LIST");
        this.hdrlSizeOffset = this.filePointer;
        this.bufSkip(4);
        this.bufWriteBytes("hdrl");
        this.bufWriteBytes("avih");
        this.bufWriteIntLittleEndian(56);
        this.avihOffset = this.filePointer;
        this.bufSkip(56);
        this.scaleOffsets = new int[this.numTracks];
        int i2 = 0;
        while (i2 < this.numTracks) {
            Format format = this.inputs[i2];
            boolean isVideo = format instanceof VideoFormat;
            this.bufWriteBytes("LIST");
            byte[] codecSpecificHeader = null;
            int extraByteLength = 0;
            AviVideoFormat aviVideoFormat = null;
            WavAudioFormat wavAudioFormat = null;
            int planes = 1;
            int depth = 16;
            String yuvEncoding = null;
            if (isVideo) {
                int bytesInBitmap = 40;
                RGBFormat rgbFormat = null;
                if (format instanceof RGBFormat) {
                    rgbFormat = (RGBFormat)format;
                } else if (format instanceof YUVFormat) {
                    YUVFormat yuv = (YUVFormat)format;
                    if (yuv.getYuvType() == 32 && yuv.getStrideY() == yuv.getSize().width * 2 && yuv.getOffsetY() == 0 && yuv.getOffsetU() == 1 && yuv.getOffsetV() == 3) {
                        yuvEncoding = "YUY2";
                    } else if (yuv.getYuvType() == 32 && yuv.getStrideY() == yuv.getSize().width * 2 && yuv.getOffsetY() == 1 && yuv.getOffsetU() == 0 && yuv.getOffsetV() == 2) {
                        yuvEncoding = "UYVY";
                    } else if (yuv.getYuvType() == 32 && yuv.getStrideY() == yuv.getSize().width * 2 && yuv.getOffsetY() == 0 && yuv.getOffsetU() == 3 && yuv.getOffsetV() == 1) {
                        yuvEncoding = "YVYU";
                    } else if (yuv.getYuvType() == 2 && yuv.getStrideY() == yuv.getSize().width && yuv.getStrideUV() == yuv.getSize().width / 2) {
                        yuvEncoding = yuv.getOffsetU() < yuv.getOffsetV() ? "I420" : "YV12";
                    }
                }
                if (format instanceof AviVideoFormat) {
                    aviVideoFormat = (AviVideoFormat)format;
                }
                if (aviVideoFormat != null) {
                    planes = aviVideoFormat.getPlanes();
                    depth = aviVideoFormat.getBitsPerPixel();
                    codecSpecificHeader = aviVideoFormat.getCodecSpecificHeader();
                } else if (rgbFormat != null) {
                    depth = rgbFormat.getBitsPerPixel();
                }
            } else if (format instanceof WavAudioFormat) {
                wavAudioFormat = (WavAudioFormat)format;
                codecSpecificHeader = wavAudioFormat.getCodecSpecificHeader();
            }
            if (codecSpecificHeader != null) {
                extraByteLength = codecSpecificHeader.length;
            }
            int strlLength = 0;
            if (isVideo) {
                strlLength = 116 + extraByteLength;
                this.bufWriteIntLittleEndian(strlLength);
            } else if (extraByteLength > 0) {
                strlLength = 92 + extraByteLength + 2;
                this.bufWriteIntLittleEndian(strlLength);
            } else {
                strlLength = 92;
                this.bufWriteIntLittleEndian(strlLength);
            }
            this.totalStrlLength += strlLength;
            this.bufWriteBytes("strl");
            this.bufWriteBytes("strh");
            this.bufWriteIntLittleEndian(56);
            String encoding = format.getEncoding();
            if (isVideo) {
                this.bufWriteBytes(VIDEO);
                if (encoding.startsWith("rgb")) {
                    encoding = "DIB ";
                } else if (yuvEncoding != null) {
                    encoding = yuvEncoding;
                }
                this.bufWriteBytes(encoding);
            } else {
                this.bufWriteBytes(AUDIO);
                this.bufWriteIntLittleEndian(0);
            }
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(0);
            this.scaleOffsets[i2] = this.filePointer;
            this.bufWriteIntLittleEndian(1);
            this.bufWriteIntLittleEndian(15);
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(0);
            this.suggestedBufferSizeOffsets[i2] = this.filePointer;
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(10000);
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(0);
            this.bufWriteBytes("strf");
            if (isVideo) {
                this.bufWriteIntLittleEndian(40 + extraByteLength);
                this.bufWriteIntLittleEndian(40 + extraByteLength);
                this.width = ((VideoFormat)format).getSize().width;
                this.height = ((VideoFormat)format).getSize().height;
                this.bufWriteIntLittleEndian(this.width);
                this.bufWriteIntLittleEndian(this.height);
                this.bufWriteShortLittleEndian((short)planes);
                this.bufWriteShortLittleEndian((short)depth);
                if (encoding.startsWith("DIB")) {
                    this.bufWriteIntLittleEndian(0);
                } else {
                    this.bufWriteBytes(encoding);
                }
                int biSizeImage = 0;
                int biXPelsPerMeter = 0;
                int biYPelsPerMeter = 0;
                int biClrUsed = 0;
                int biClrImportant = 0;
                if (aviVideoFormat != null) {
                    if (aviVideoFormat.getImageSize() != -1) {
                        biSizeImage = aviVideoFormat.getImageSize();
                    }
                    if (aviVideoFormat.getXPelsPerMeter() != -1) {
                        biXPelsPerMeter = aviVideoFormat.getXPelsPerMeter();
                    }
                    if (aviVideoFormat.getYPelsPerMeter() != -1) {
                        biYPelsPerMeter = aviVideoFormat.getYPelsPerMeter();
                    }
                    if (aviVideoFormat.getClrUsed() != -1) {
                        biClrUsed = aviVideoFormat.getClrUsed();
                    }
                    if (aviVideoFormat.getClrImportant() != -1) {
                        biClrImportant = aviVideoFormat.getClrImportant();
                    }
                }
                this.bufWriteIntLittleEndian(biSizeImage);
                this.bufWriteIntLittleEndian(biXPelsPerMeter);
                this.bufWriteIntLittleEndian(biYPelsPerMeter);
                this.bufWriteIntLittleEndian(biClrUsed);
                this.bufWriteIntLittleEndian(biClrImportant);
            } else {
                Integer formatTag;
                AudioFormat audioFormat = (AudioFormat)format;
                if (extraByteLength > 0) {
                    this.bufWriteIntLittleEndian(16 + extraByteLength + 2);
                } else {
                    this.bufWriteIntLittleEndian(16);
                }
                if (encoding.equals("unknown")) {
                    encoding = "LINEAR";
                }
                if ((formatTag = (Integer)WavAudioFormat.reverseFormatMapper.get(encoding)) != null) {
                    this.bufWriteShortLittleEndian(formatTag.shortValue());
                    this.bufWriteShortLittleEndian((short)audioFormat.getChannels());
                    this.bufWriteIntLittleEndian((int)audioFormat.getSampleRate());
                    if (wavAudioFormat != null) {
                        this.bufWriteIntLittleEndian(wavAudioFormat.getAverageBytesPerSecond());
                    } else {
                        this.bufWriteIntLittleEndian(32768);
                    }
                    this.bufWriteShortLittleEndian((short)(audioFormat.getFrameSizeInBits() / 8));
                    this.bufWriteShortLittleEndian((short)audioFormat.getSampleSizeInBits());
                }
            }
            if (extraByteLength > 0) {
                if (!isVideo) {
                    this.bufWriteShortLittleEndian((short)extraByteLength);
                }
                this.bufWriteBytes(codecSpecificHeader);
            }
            ++i2;
        }
        this.bufWriteBytes("LIST");
        this.moviOffset = this.filePointer;
        this.bufSkip(4);
        this.bufWriteBytes("movi");
        this.bufFlush();
        this.seek(this.hdrlSizeOffset);
        int hdrlSize = this.totalStrlLength + 56 + 4 * (3 + 2 * this.numTracks);
        this.bufClear();
        this.bufWriteIntLittleEndian(hdrlSize);
        this.bufFlush();
        this.seek(this.moviOffset + 8);
    }

    protected void writeFooter() {
        this.writeIDX1Chunk();
        this.writeAVIH();
        this.seek(this.moviOffset);
        this.bufClear();
        this.bufWriteIntLittleEndian(4 + this.totalDataLength + this.totalFrames * 8);
        this.bufFlush();
        int i2 = 0;
        while (i2 < this.numTracks) {
            int offset = this.suggestedBufferSizeOffsets[i2];
            if (offset > 0) {
                this.seek(offset);
                this.bufClear();
                this.bufWriteIntLittleEndian(this.suggestedBufferSizes[i2]);
                this.bufFlush();
            }
            this.seek(this.scaleOffsets[i2]);
            if (this.inputs[i2] instanceof VideoFormat) {
                this.seek(this.filePointer + 4);
                this.bufClear();
                this.bufWriteIntLittleEndian((int)((double)this.frameRate + 0.05));
                this.bufFlush();
            } else {
                WavAudioFormat wavAudioFormat;
                byte[] codecSpecificHeader;
                AudioFormat audioFormat = (AudioFormat)this.inputs[i2];
                int blockAlign = audioFormat.getFrameSizeInBits() / 8;
                this.bufClear();
                this.bufWriteIntLittleEndian(blockAlign);
                this.bufFlush();
                short samplesPerBlock = 1;
                if (audioFormat instanceof WavAudioFormat && (codecSpecificHeader = (wavAudioFormat = (WavAudioFormat)audioFormat).getCodecSpecificHeader()) != null && codecSpecificHeader.length >= 2) {
                    try {
                        samplesPerBlock = BasicPullParser.parseShortFromArray(codecSpecificHeader, false);
                    }
                    catch (IOException iOException) {
                        System.err.println("Unable to parse codecSpecificHeader");
                        samplesPerBlock = 1;
                    }
                }
                int rate = (int)(audioFormat.getSampleRate() / (double)samplesPerBlock * (double)blockAlign);
                this.bufClear();
                this.bufWriteIntLittleEndian(rate);
                this.bufFlush();
                this.seek(this.filePointer + 16);
                this.bufClear();
                this.bufWriteIntLittleEndian(blockAlign);
                this.bufFlush();
            }
            ++i2;
        }
        this.seek(4);
        this.bufClear();
        this.bufWriteIntLittleEndian(this.fileSize);
        this.bufFlush();
    }

    private void writeIDX1Chunk() {
        this.bufClear();
        this.bufWriteBytes("idx1");
        this.bufWriteIntLittleEndian(this.totalFrames * 16);
        this.bufFlush();
        int i2 = 0;
        while (i2 < this.chunkList.size()) {
            ByteBuffer bbuf = (ByteBuffer)this.chunkList.elementAt(i2);
            this.write(bbuf.buffer, 0, bbuf.length);
            ++i2;
        }
    }

    private void writeAVIH() {
        this.seek(this.avihOffset);
        this.bufClear();
        this.bufWriteIntLittleEndian(this.usecPerFrame);
        this.bufWriteIntLittleEndian(this.maxBytesPerSecond);
        this.bufWriteIntLittleEndian(this.paddingGranularity);
        this.bufWriteIntLittleEndian(this.flags);
        this.bufWriteIntLittleEndian(this.totalVideoFrames);
        this.bufWriteIntLittleEndian(this.initialFrames);
        this.bufWriteIntLittleEndian(this.numTracks);
        this.bufWriteIntLittleEndian(32768);
        this.bufWriteIntLittleEndian(this.width);
        this.bufWriteIntLittleEndian(this.height);
        this.bufWriteIntLittleEndian(0);
        this.bufWriteIntLittleEndian(0);
        this.bufWriteIntLittleEndian(0);
        this.bufWriteIntLittleEndian(0);
        this.bufFlush();
    }

    private String getAviEncodingMagic(int streamNumber, boolean isVideoFormat) {
        String encoding = this.inputs[streamNumber].getEncoding();
        String magic = isVideoFormat ? (encoding.equals("cvid") ? VIDEO_MAGIC_CVID : (encoding.toLowerCase().startsWith("iv32") ? VIDEO_MAGIC_IV32b : (encoding.toLowerCase().startsWith("iv31") ? VIDEO_MAGIC_IV31 : (encoding.toLowerCase().startsWith(VIDEO_MAGIC_IV32a) ? VIDEO_MAGIC_IV32a : VIDEO_MAGIC)))) : AUDIO_MAGIC;
        String streamPrefix = null;
        if (streamNumber == 0) {
            streamPrefix = "00";
        } else if (streamNumber == 1) {
            streamPrefix = "01";
        } else if (streamNumber == 2) {
            streamPrefix = "02";
        } else if (streamNumber == 3) {
            streamPrefix = "03";
        } else if (streamNumber == 4) {
            streamPrefix = "04";
        }
        return String.valueOf(streamPrefix) + magic;
    }
}

