/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.datasink.rtp;

import com.sun.media.rtp.RTPMediaLocator;
import com.sun.media.rtp.RTPSessionMgr;
import java.awt.Component;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import javax.media.DataSink;
import javax.media.IncompatibleSourceException;
import javax.media.MediaLocator;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionManager;
import javax.media.rtp.rtcp.SourceDescription;

public class Handler
implements DataSink {
    private RTPMediaLocator rtpmrl;
    SessionManager rtpmanager;
    PushBufferDataSource source;
    SendStream rtpsendstream;

    public Object getControl(String controlType) {
        return null;
    }

    public Object[] getControls() {
        return new Object[1];
    }

    public Component getControlComponent() {
        return null;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PushBufferDataSource)) {
            throw new IncompatibleSourceException("Only supports PushBufferDataSource");
        }
        this.source = (PushBufferDataSource)source;
        PushBufferStream[] streams = this.source.getStreams();
        int numStreams = streams.length;
        System.out.println("streams is " + streams + " : " + numStreams);
        if (streams == null || numStreams <= 0) {
            throw new IOException("source " + source + " doesn't have any streams");
        }
    }

    public void setOutputLocator(MediaLocator output) {
        if (this.rtpmrl == null) {
            System.out.println("sink: setOutputLocator " + output);
            try {
                this.rtpmrl = new RTPMediaLocator(output.toString());
            }
            catch (MalformedURLException malformedURLException) {
                this.rtpmrl = null;
            }
        } else {
            throw new Error("setOutputLocator cannot be called more than once");
        }
    }

    public MediaLocator getOutputLocator() {
        return this.rtpmrl;
    }

    public void start() throws IOException {
        this.rtpsendstream.start();
    }

    public void stop() throws IOException {
        this.rtpsendstream.stop();
    }

    public void open() throws IOException, SecurityException {
        if (this.rtpmrl == null) {
            throw new IOException("No Valid RTP MediaLocator");
        }
        try {
            String address = this.rtpmrl.getSessionAddress();
            int port = this.rtpmrl.getSessionPort();
            int ttl = this.rtpmrl.getTTL();
            this.rtpmanager = new RTPSessionMgr();
            String cname = this.rtpmanager.generateCNAME();
            String username = null;
            try {
                username = System.getProperty("user.name");
            }
            catch (Exception exception) {
                username = "jmf-user";
            }
            SessionAddress localaddr = new SessionAddress();
            InetAddress destaddr = InetAddress.getByName(address);
            SessionAddress sessaddr = new SessionAddress(destaddr, port, destaddr, port + 1);
            SourceDescription[] userdesclist = new SourceDescription[]{new SourceDescription(3, "jmf-user@sun.com", 1, false), new SourceDescription(1, cname, 1, false), new SourceDescription(6, "JMF RTP Player v2.0", 1, false)};
            this.rtpmanager.initSession(localaddr, userdesclist, 0.05, 0.25);
            this.rtpmanager.startSession(sessaddr, ttl, null);
            this.rtpsendstream = this.rtpmanager.createSendStream(this.source, 0);
        }
        catch (Exception e2) {
            throw new IOException(e2.getMessage());
        }
    }

    public void close() {
        if (this.rtpmanager != null) {
            this.rtpmanager.closeSession("DataSink closed");
        }
    }

    public String getContentType() {
        return "RTP";
    }
}

