/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.BasicInputConnector;
import com.sun.media.BasicSinkModule;
import com.sun.media.Connector;
import com.sun.media.CreateWorkThreadAction;
import com.sun.media.InputConnector;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.MediaEngine;
import com.sun.media.RenderThread;
import com.sun.media.util.jdk12;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.Format;
import javax.media.Prefetchable;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.renderer.VideoRenderer;

public class BasicRendererModule
extends BasicSinkModule {
    protected Renderer renderer;
    protected InputConnector ic;
    protected int framesPlayed;
    protected float frameRate = 30.0f;
    protected boolean framesWereBehind = false;
    protected boolean prefetching = false;
    protected boolean started = false;
    private boolean opened = false;
    private int chunkSize = Integer.MAX_VALUE;
    private long prefetchedAudioDuration;
    RenderThread renderThread;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private Object prefetchSync = new Object();
    private long LEEWAY = 10L;
    private long lastRendered;
    private boolean initFailed = false;
    private boolean notToDropNext = false;
    private Buffer storedBuffer;
    long systemErr;
    static final int MAX_CHUNK_SIZE = 16;
    static /* synthetic */ Class class$com$sun$media$RenderThread;
    static /* synthetic */ Class class$com$sun$media$BasicRendererModule;

    protected BasicRendererModule(Renderer r2) {
        this.setRenderer(r2);
        this.ic = new BasicInputConnector();
        if (r2 instanceof VideoRenderer) {
            this.ic.setSize(4);
        } else {
            this.ic.setSize(1);
        }
        this.ic.setModule(this);
        this.registerInputConnector("input", this.ic);
        this.setProtocol(3);
    }

    public boolean isThreaded() {
        return true;
    }

    public boolean doRealize() {
        this.chunkSize = this.computeChunkSize(this.ic.getFormat());
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable e2) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                Constructor cons = CreateWorkThreadAction.cons;
                this.renderThread = (RenderThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$RenderThread != null ? class$com$sun$media$RenderThread : (class$com$sun$media$RenderThread = BasicRendererModule.class$("com.sun.media.RenderThread")), class$com$sun$media$BasicRendererModule != null ? class$com$sun$media$BasicRendererModule : (class$com$sun$media$BasicRendererModule = BasicRendererModule.class$("com.sun.media.BasicRendererModule")), this));
            }
            catch (Exception exception) {}
        } else {
            this.renderThread = new RenderThread(this);
        }
        return true;
    }

    public boolean doPrefetch() {
        super.doPrefetch();
        if (!this.opened) {
            try {
                this.renderer.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                this.prefetchFailed = true;
                return false;
            }
            this.prefetchFailed = false;
            this.opened = true;
        }
        this.prefetching = true;
        this.renderThread.start();
        return true;
    }

    public void doFailedPrefetch() {
        this.renderThread.pause();
        this.renderer.close();
        this.opened = false;
        this.prefetching = false;
    }

    public void abortPrefetch() {
        this.renderThread.pause();
        this.renderer.close();
        this.prefetching = false;
        this.opened = false;
    }

    public void doStart() {
        super.doStart();
        if (!(this.renderer instanceof Clock)) {
            this.renderer.start();
        }
        this.prerolling = false;
        this.started = true;
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            this.renderThread.start();
        }
    }

    public void doStop() {
        this.started = false;
        this.prefetching = true;
        super.doStop();
        if (!(this.renderer instanceof Clock)) {
            this.renderer.stop();
        }
    }

    public void doDealloc() {
        this.renderer.close();
    }

    public void doClose() {
        this.renderThread.kill();
        this.renderer.close();
    }

    public void triggerReset() {
        this.renderer.reset();
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            if (this.resetted) {
                this.renderThread.start();
            }
        }
    }

    public void doneReset() {
        this.renderThread.pause();
    }

    protected boolean reinitRenderer(Format input) {
        if (this.renderer != null && this.renderer.setInputFormat(input) != null) {
            return true;
        }
        if (this.started) {
            this.renderer.stop();
            this.renderer.reset();
        }
        this.renderer.close();
        this.renderer = null;
        Renderer r2 = MediaEngine.findRenderer(input);
        if (r2 == null) {
            return false;
        }
        this.setRenderer(r2);
        if (this.started) {
            this.renderer.start();
        }
        this.chunkSize = this.computeChunkSize(input);
        return true;
    }

    protected void setRenderer(Renderer r2) {
        this.renderer = r2;
        if (this.renderer instanceof Clock) {
            this.setClock((Clock)((Object)this.renderer));
        }
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    protected void process() {
    }

    protected boolean doProcess() {
        Buffer buffer = this.storedBuffer != null ? this.storedBuffer : this.ic.getValidBuffer();
        if (this.initFailed || this.resetted) {
            if ((buffer.getFlags() & 0x100) != 0) {
                this.resetted = false;
                this.renderThread.pause();
                if (this.moduleListener != null) {
                    this.moduleListener.resetted(this);
                }
            }
            this.storedBuffer = null;
            this.ic.readReport();
            return true;
        }
        this.jmd.moduleIn(this, 0, buffer, true);
        boolean rtn = this.scheduleBuffer(buffer);
        if (this.storedBuffer == null && buffer.isEOM()) {
            if (this.prefetching) {
                this.donePrefetch();
            }
            if ((buffer.getFlags() & 0x40) == 0 && buffer.getTimeStamp() > 0L && buffer.getFormat() != null && !(buffer.getFormat() instanceof AudioFormat)) {
                this.waitForPT(buffer.getTimeStamp());
            }
            this.storedBuffer = null;
            this.ic.readReport();
            this.jmd.moduleIn(this, 0, buffer, false);
            this.doStop();
            if (this.moduleListener != null) {
                this.moduleListener.mediaEnded(this);
            }
            return true;
        }
        if (this.storedBuffer == null) {
            this.ic.readReport();
        }
        this.jmd.moduleIn(this, 0, buffer, false);
        return rtn;
    }

    protected boolean scheduleBuffer(Buffer buffer) {
        int rc = 0;
        Format format = buffer.getFormat();
        if (format == null) {
            format = this.ic.getFormat();
            buffer.setFormat(format);
        }
        if (format != this.ic.getFormat() && !format.equals(this.ic.getFormat()) && !this.handleFormatChange(format)) {
            return false;
        }
        if ((buffer.getFlags() & 0x200) != 0 && this.moduleListener != null) {
            this.moduleListener.markedDataArrived(this, buffer);
            buffer.setFlags(buffer.getFlags() & 0xFFFFFDFF);
        }
        if (this.prefetching || format instanceof AudioFormat || buffer.getTimeStamp() <= 0L || (buffer.getFlags() & 0x60) == 96) {
            if (!buffer.isDiscard()) {
                rc = this.processBuffer(buffer);
            }
        } else {
            long mt = this.getMediaNanoseconds();
            long lateBy = mt / 1000000L - buffer.getTimeStamp() / 1000000L - this.getLatency() / 1000000L;
            if (this.storedBuffer == null && lateBy > 0L) {
                if (buffer.isDiscard()) {
                    this.notToDropNext = true;
                } else {
                    if (this.moduleListener != null && format instanceof VideoFormat) {
                        float fb = (float)lateBy * this.frameRate / 1000.0f;
                        if (fb < 1.0f) {
                            fb = 1.0f;
                        }
                        this.moduleListener.framesBehind(this, fb);
                        this.framesWereBehind = true;
                    }
                    if (lateBy < this.LEEWAY || this.notToDropNext || (buffer.getFlags() & 0x20) != 0 || buffer.getTimeStamp() - this.lastRendered > 1000000000L) {
                        rc = this.processBuffer(buffer);
                        this.lastRendered = buffer.getTimeStamp();
                        this.notToDropNext = false;
                    }
                }
            } else {
                if (this.moduleListener != null && this.framesWereBehind && format instanceof VideoFormat) {
                    this.moduleListener.framesBehind(this, 0.0f);
                    this.framesWereBehind = false;
                }
                if (!buffer.isDiscard()) {
                    if ((buffer.getFlags() & 0x40) == 0) {
                        this.waitForPT(buffer.getTimeStamp());
                    }
                    rc = this.processBuffer(buffer);
                    this.lastRendered = buffer.getTimeStamp();
                }
            }
        }
        this.storedBuffer = rc & true ? null : ((rc & 2) != 0 ? buffer : null);
        return true;
    }

    public int processBuffer(Buffer buffer) {
        int remain = buffer.getLength();
        int offset = buffer.getOffset();
        int rc = 0;
        boolean isEOM = false;
        do {
            int len;
            if (remain <= this.chunkSize || this.prerolling) {
                if (isEOM) {
                    isEOM = false;
                    buffer.setEOM(true);
                }
                len = remain;
            } else {
                if (buffer.isEOM()) {
                    isEOM = true;
                    buffer.setEOM(false);
                }
                len = this.chunkSize;
            }
            buffer.setLength(len);
            buffer.setOffset(offset);
            if (this.prerolling && !this.handlePreroll(buffer)) {
                offset += len;
                remain -= len;
                continue;
            }
            rc = this.renderer.process(buffer);
            if ((rc & 1) != 0) {
                buffer.setDiscard(true);
                if (this.prefetching) {
                    this.donePrefetch();
                }
                return rc;
            }
            if ((rc & 2) != 0) {
                len -= buffer.getLength();
            }
            offset += len;
            remain -= len;
            if (!this.prefetching || this.renderer instanceof Prefetchable && !((Prefetchable)((Object)this.renderer)).isPrefetched()) continue;
            isEOM = false;
            buffer.setEOM(false);
            this.donePrefetch();
            break;
        } while (remain > 0 && !this.resetted);
        if (isEOM) {
            buffer.setEOM(true);
        }
        buffer.setLength(remain);
        buffer.setOffset(offset);
        if (rc == 0) {
            ++this.framesPlayed;
        }
        return rc;
    }

    private boolean handleFormatChange(Format format) {
        float fr;
        if (!this.reinitRenderer(format)) {
            this.storedBuffer = null;
            this.initFailed = true;
            if (this.moduleListener != null) {
                this.moduleListener.formatChangedFailure(this, this.ic.getFormat(), format);
            }
            return false;
        }
        Format oldFormat = this.ic.getFormat();
        this.ic.setFormat(format);
        if (this.moduleListener != null) {
            this.moduleListener.formatChanged(this, oldFormat, format);
        }
        if (format instanceof VideoFormat && (fr = ((VideoFormat)format).getFrameRate()) != -1.0f) {
            this.frameRate = fr;
        }
        return true;
    }

    private void donePrefetch() {
        Object object = this.prefetchSync;
        synchronized (object) {
            if (!this.started && this.prefetching) {
                this.renderThread.pause();
            }
            this.prefetching = false;
        }
        if (this.moduleListener != null) {
            this.moduleListener.bufferPrefetched(this);
        }
    }

    private boolean handlePreroll(Buffer buf) {
        if (buf.getFormat() instanceof AudioFormat ? !this.hasReachAudioPrerollTarget(buf) : (buf.getFlags() & 0x60) == 0 && buf.getTimeStamp() > 0L && buf.getTimeStamp() < this.getMediaNanoseconds()) {
            return false;
        }
        this.prerolling = false;
        return true;
    }

    private boolean hasReachAudioPrerollTarget(Buffer buf) {
        long duration = this.audioLenToDuration(buf.getLength(), (AudioFormat)buf.getFormat());
        long target = this.getMediaNanoseconds();
        this.prerollElapsedTime += duration;
        if (this.prerollElapsedTime >= target) {
            long remain = this.audioDurationToLen(this.prerollElapsedTime - target, (AudioFormat)buf.getFormat());
            int offset = buf.getOffset() + buf.getLength() - (int)remain;
            if (offset >= 0) {
                buf.setOffset(offset);
                buf.setLength((int)remain);
            }
            return true;
        }
        return false;
    }

    private long audioLenToDuration(long length, AudioFormat af) {
        if (af == null) {
            return 0L;
        }
        long bytePerSec = (long)((double)af.getSampleSizeInBits() * af.getSampleRate() * (double)af.getChannels() / 8.0);
        return bytePerSec == 0L ? 0L : length * 1000L / bytePerSec * 1000000L;
    }

    private long audioDurationToLen(long duration, AudioFormat af) {
        if (af == null) {
            return 0L;
        }
        long units = af.getSampleSizeInBits() * af.getChannels();
        long bytePerSec = (long)((double)units * af.getSampleRate() / 8.0);
        return bytePerSec == 0L ? 0L : duration * bytePerSec / 1000000000L / units * units;
    }

    private boolean waitForPT(long pt) {
        long mt = this.getMediaNanoseconds();
        long lastAheadBy = -1L;
        int beenHere = 0;
        long aheadBy = (pt - mt) / 1000000L;
        if (this.rate != 1.0f) {
            aheadBy = (long)((float)aheadBy / this.rate);
        }
        while (aheadBy > this.systemErr && !this.resetted) {
            long interval;
            if (aheadBy == lastAheadBy) {
                interval = aheadBy + (long)(5 * beenHere);
                if (interval > 33L) {
                    interval = 33L;
                } else {
                    ++beenHere;
                }
            } else {
                interval = aheadBy;
                beenHere = 0;
            }
            interval = interval > 125L ? 125L : interval;
            long before = System.currentTimeMillis();
            interval -= this.systemErr;
            try {
                if (interval > 0L) {
                    Thread.currentThread();
                    Thread.sleep(interval);
                }
            }
            catch (InterruptedException interruptedException) {}
            long slept = System.currentTimeMillis() - before;
            this.systemErr = (slept - interval + this.systemErr) / 2L;
            if (this.systemErr < 0L) {
                this.systemErr = 0L;
            }
            mt = this.getMediaNanoseconds();
            lastAheadBy = aheadBy;
            aheadBy = (pt - mt) / 1000000L;
            if (this.rate != 1.0f) {
                aheadBy = (long)((float)aheadBy / this.rate);
            }
            if (this.getState() != 600) break;
        }
        return true;
    }

    public Object[] getControls() {
        return this.renderer.getControls();
    }

    public Object getControl(String s) {
        return this.renderer.getControl(s);
    }

    public Format[] listFormats(Connector connector) {
        return this.renderer.getSupportedInputFormats();
    }

    public void setFormat(Connector connector, Format format) {
        float fr;
        this.renderer.setInputFormat(format);
        if (format instanceof VideoFormat && (fr = ((VideoFormat)format).getFrameRate()) != -1.0f) {
            this.frameRate = fr;
        }
    }

    public int getFramesPlayed() {
        return this.framesPlayed;
    }

    public void resetFramesPlayed() {
        this.framesPlayed = 0;
    }

    private int computeChunkSize(Format format) {
        if (format instanceof AudioFormat && (format.getEncoding().equals("LINEAR") || format.getEncoding().equals("ULAW"))) {
            AudioFormat af = (AudioFormat)format;
            int units = af.getSampleSizeInBits() * af.getChannels() / 8;
            if (units == 0) {
                units = 1;
            }
            int chunks = (int)af.getSampleRate() * units / 16;
            return chunks / units * units;
        }
        return Integer.MAX_VALUE;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }
}

