/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.FrameSetView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

class FrameView
extends ComponentView
implements HyperlinkListener {
    JEditorPane htmlPane;
    JScrollPane scroller;
    boolean editable;
    float width;
    float height;
    URL src;

    public FrameView(Element element) {
        super(element);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        URL uRL = this.src;
        String string = (String)attributeSet.getAttribute(HTML.Attribute.SRC);
        URL uRL2 = ((HTMLDocument)element.getDocument()).getBase();
        try {
            this.src = new URL(uRL2, string);
            if (uRL.equals(this.src)) {
                return;
            }
            this.htmlPane.setPage(this.src);
            HTMLDocument hTMLDocument = (HTMLDocument)this.htmlPane.getDocument();
            hTMLDocument.setFrameDocumentState(true);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {}
    }

    protected Component createComponent() {
        block3: {
            Element element = this.getElement();
            AttributeSet attributeSet = element.getAttributes();
            String string = (String)attributeSet.getAttribute(HTML.Attribute.SRC);
            if (string == null || string.equals("")) break block3;
            try {
                URL uRL = ((HTMLDocument)element.getDocument()).getBase();
                this.src = new URL(uRL, string);
                this.htmlPane = new JEditorPane(this.src);
                this.htmlPane.addHyperlinkListener(this);
                this.htmlPane.setEditable(this.editable);
                HTMLDocument hTMLDocument = (HTMLDocument)this.htmlPane.getDocument();
                hTMLDocument.setFrameDocumentState(true);
                this.setMargin();
                this.createScrollPane();
                this.setBorder();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.scroller;
    }

    private void createScrollPane() {
        AttributeSet attributeSet = this.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.SCROLLING);
        if (string == null) {
            string = "auto";
        }
        this.scroller = !string.equals("no") ? (string.equals("yes") ? new JScrollPane(22, 32) : new JScrollPane()) : new JScrollPane(21, 31);
        JViewport jViewport = this.scroller.getViewport();
        jViewport.add(this.htmlPane);
        jViewport.setBackingStoreEnabled(true);
        this.scroller.setVisible(false);
        this.scroller.setMinimumSize(new Dimension(5, 5));
        this.scroller.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    public float getMaximumSpan(int n) {
        return 2.1474836E9f;
    }

    public float getMinimumSpan(int n) {
        return 5.0f;
    }

    private JEditorPane getOutermostJEditorPane() {
        View view = this.getParent();
        View view2 = null;
        while (view != null) {
            if (view instanceof FrameSetView) {
                view2 = (FrameSetView)view;
            }
            view = view.getParent();
        }
        if (view2 != null) {
            return (JEditorPane)view2.getContainer();
        }
        return null;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        block6: {
            if (!(hyperlinkEvent instanceof HTMLFrameHyperlinkEvent)) {
                return;
            }
            HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
            if (hTMLFrameHyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) break block6;
            JEditorPane jEditorPane = this.getOutermostJEditorPane();
            String string = hTMLFrameHyperlinkEvent.getTarget();
            if (hTMLFrameHyperlinkEvent.getTarget().equals("_parent") && !this.inNestedFrameSet()) {
                string = "_top";
            }
            if (jEditorPane != null && !jEditorPane.isEditable()) {
                jEditorPane.fireHyperlinkUpdate(new HTMLFrameHyperlinkEvent(jEditorPane, hTMLFrameHyperlinkEvent.getEventType(), hTMLFrameHyperlinkEvent.getURL(), hTMLFrameHyperlinkEvent.getDescription(), this.getElement(), string));
                if (string.equals("_top")) {
                    try {
                        jEditorPane.setPage(hTMLFrameHyperlinkEvent.getURL());
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private boolean inNestedFrameSet() {
        FrameSetView frameSetView = (FrameSetView)this.getParent();
        return frameSetView.getParent() instanceof FrameSetView;
    }

    public void paint(Graphics graphics, Shape shape) {
        Container container = this.getContainer();
        if (container != null && this.htmlPane != null && this.htmlPane.isEditable() != ((JTextComponent)container).isEditable()) {
            this.editable = ((JTextComponent)container).isEditable();
            this.htmlPane.setEditable(this.editable);
        }
        super.paint(graphics, shape);
    }

    private void setBorder() {
        AttributeSet attributeSet = this.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.FRAMEBORDER);
        if (string != null && (string.equals("no") || string.equals("0"))) {
            this.scroller.setBorder(null);
        }
    }

    private void setMargin() {
        int n = 0;
        Insets insets = this.htmlPane.getMargin();
        Insets insets2 = new Insets(insets.top, insets.left, insets.right, insets.bottom);
        boolean bl = false;
        AttributeSet attributeSet = this.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.MARGINWIDTH);
        if (string != null && (n = Integer.parseInt(string)) > 0) {
            insets2.left = n;
            insets2.right = n;
            bl = true;
        }
        if ((string = (String)attributeSet.getAttribute(HTML.Attribute.MARGINHEIGHT)) != null && (n = Integer.parseInt(string)) > 0) {
            insets2.top = n;
            insets2.bottom = n;
            bl = true;
        }
        if (bl) {
            this.htmlPane.setMargin(insets2);
        }
    }

    public void setParent(View view) {
        if (view != null) {
            JTextComponent jTextComponent = (JTextComponent)view.getContainer();
            this.editable = jTextComponent.isEditable();
        }
        super.setParent(view);
    }
}

