/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;

public class MetalInternalFrameUI
extends BasicInternalFrameUI {
    private MetalInternalFrameTitlePane titlePane;
    private PropertyChangeListener paletteListener;
    private PropertyChangeListener contentPaneListener;
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    protected static String IS_PALETTE = "JInternalFrame.isPalette";

    public MetalInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new MetalInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalInternalFrameUI((JInternalFrame)jComponent);
    }

    protected void installKeyboardActions() {
    }

    public void installUI(JComponent jComponent) {
        this.frame = (JInternalFrame)jComponent;
        this.paletteListener = new PaletteListener();
        this.contentPaneListener = new ContentPaneListener();
        jComponent.addPropertyChangeListener(this.paletteListener);
        jComponent.addPropertyChangeListener(this.contentPaneListener);
        super.installUI(jComponent);
        Object object = jComponent.getClientProperty(IS_PALETTE);
        if (object != null) {
            this.setPalette((Boolean)object);
        }
        Container container = this.frame.getContentPane();
        this.stripContentBorder(container);
    }

    protected void replacePane(JComponent jComponent, JComponent jComponent2) {
        super.replacePane(jComponent, jComponent2);
        if (jComponent != null && jComponent instanceof MetalInternalFrameTitlePane) {
            this.frame.removePropertyChangeListener((PropertyChangeListener)((Object)jComponent));
        }
    }

    public void setPalette(boolean bl) {
        if (bl) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.paletteBorder");
        } else {
            LookAndFeel.installBorder(this.frame, "InternalFrame.border");
        }
        this.titlePane.setPalette(bl);
    }

    private void stripContentBorder(Object object) {
        JComponent jComponent;
        Border border;
        if (object instanceof JComponent && ((border = (jComponent = (JComponent)object).getBorder()) == null || border instanceof UIResource)) {
            jComponent.setBorder(handyEmptyBorder);
        }
    }

    protected void uninstallKeyboardActions() {
    }

    public void uninstallUI(JComponent jComponent) {
        JComponent jComponent2;
        jComponent.removePropertyChangeListener(this.paletteListener);
        jComponent.removePropertyChangeListener(this.contentPaneListener);
        Container container = ((JInternalFrame)jComponent).getContentPane();
        if (container instanceof JComponent && (jComponent2 = (JComponent)container).getBorder() == handyEmptyBorder) {
            jComponent2.setBorder(null);
        }
        super.uninstallUI(jComponent);
    }

    class PaletteListener
    implements PropertyChangeListener {
        PaletteListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals(IS_PALETTE)) {
                if (propertyChangeEvent.getNewValue() != null) {
                    MetalInternalFrameUI.this.setPalette((Boolean)propertyChangeEvent.getNewValue());
                } else {
                    MetalInternalFrameUI.this.setPalette(false);
                }
            }
        }
    }

    class ContentPaneListener
    implements PropertyChangeListener {
        ContentPaneListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("contentPane")) {
                MetalInternalFrameUI.this.stripContentBorder(propertyChangeEvent.getNewValue());
            }
        }
    }
}

