/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;

public class JTabbedPane
extends JComponent
implements Serializable,
Accessible,
SwingConstants {
    private static final String uiClassID = "TabbedPaneUI";
    protected int tabPlacement = 1;
    protected SingleSelectionModel model;
    private boolean haveRegistered;
    protected ChangeListener changeListener = null;
    Vector pages;
    protected transient ChangeEvent changeEvent = null;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public JTabbedPane() {
        this(1);
    }

    public JTabbedPane(int n) {
        this.setTabPlacement(n);
        this.pages = new Vector(1);
        this.setModel(new DefaultSingleSelectionModel());
        this.updateUI();
    }

    public Component add(Component component) {
        this.addTab(component.getName(), component);
        return component;
    }

    public Component add(Component component, int n) {
        this.insertTab(component.getName(), null, component, null, n);
        return component;
    }

    public void add(Component component, Object object) {
        if (object instanceof String) {
            this.addTab((String)object, component);
        } else if (object instanceof Icon) {
            this.addTab(null, (Icon)object, component);
        } else {
            this.add(component);
        }
    }

    public void add(Component component, Object object, int n) {
        Icon icon = object instanceof Icon ? (Icon)object : null;
        String string = object instanceof String ? (String)object : null;
        this.insertTab(string, icon, component, null, n);
    }

    public Component add(String string, Component component) {
        this.addTab(string, component);
        return component;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener != null ? class$javax$swing$event$ChangeListener : (class$javax$swing$event$ChangeListener = JTabbedPane.class$("javax.swing.event.ChangeListener")), changeListener);
    }

    public void addTab(String string, Component component) {
        this.insertTab(string, null, component, null, this.pages.size());
    }

    public void addTab(String string, Icon icon, Component component) {
        this.insertTab(string, icon, component, null, this.pages.size());
    }

    public void addTab(String string, Icon icon, Component component, String string2) {
        this.insertTab(string, icon, component, string2, this.pages.size());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected ChangeListener createChangeListener() {
        return new ModelListener();
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener != null ? class$javax$swing$event$ChangeListener : JTabbedPane.class$("javax.swing.event.ChangeListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTabbedPane();
        }
        return this.accessibleContext;
    }

    public Color getBackgroundAt(int n) {
        return ((Page)this.pages.elementAt(n)).getBackground();
    }

    public Rectangle getBoundsAt(int n) {
        if (this.ui != null) {
            return ((TabbedPaneUI)this.ui).getTabBounds(this, n);
        }
        return null;
    }

    public Component getComponentAt(int n) {
        return ((Page)this.pages.elementAt((int)n)).component;
    }

    public Icon getDisabledIconAt(int n) {
        return ((Page)this.pages.elementAt((int)n)).disabledIcon;
    }

    public Color getForegroundAt(int n) {
        return ((Page)this.pages.elementAt(n)).getForeground();
    }

    public Icon getIconAt(int n) {
        return ((Page)this.pages.elementAt((int)n)).icon;
    }

    public SingleSelectionModel getModel() {
        return this.model;
    }

    public Component getSelectedComponent() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return this.getComponentAt(n);
    }

    public int getSelectedIndex() {
        return this.model.getSelectedIndex();
    }

    public int getTabCount() {
        return this.pages.size();
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    public int getTabRunCount() {
        if (this.ui != null) {
            return ((TabbedPaneUI)this.ui).getTabRunCount(this);
        }
        return 0;
    }

    public String getTitleAt(int n) {
        return ((Page)this.pages.elementAt((int)n)).title;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n;
        if (this.ui != null && (n = ((TabbedPaneUI)this.ui).tabForCoordinate(this, mouseEvent.getX(), mouseEvent.getY())) != -1) {
            return ((Page)this.pages.elementAt((int)n)).tip;
        }
        return super.getToolTipText(mouseEvent);
    }

    public TabbedPaneUI getUI() {
        return (TabbedPaneUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public int indexOfComponent(Component component) {
        int n = 0;
        while (n < this.getTabCount()) {
            if (this.getComponentAt(n).equals(component)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOfTab(String string) {
        int n = 0;
        while (n < this.getTabCount()) {
            if (this.getTitleAt(n).equals(string == null ? "" : string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOfTab(Icon icon) {
        int n = 0;
        while (n < this.getTabCount()) {
            if (this.getIconAt(n).equals(icon)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        ImageIcon imageIcon = null;
        if (icon != null && icon instanceof ImageIcon) {
            imageIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
        }
        this.pages.insertElementAt(new Page(this, string != null ? string : "", icon, imageIcon, component, string2), n);
        if (component != null) {
            component.setVisible(false);
            this.addImpl(component, null, -1);
        }
        if (this.pages.size() == 1) {
            this.setSelectedIndex(0);
        }
        if (!this.haveRegistered && string2 != null) {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.haveRegistered = true;
        }
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", null, component);
        }
        this.revalidate();
        this.repaint();
    }

    public boolean isEnabledAt(int n) {
        return ((Page)this.pages.elementAt(n)).isEnabled();
    }

    protected String paramString() {
        String string = this.tabPlacement == 1 ? "TOP" : (this.tabPlacement == 3 ? "BOTTOM" : (this.tabPlacement == 2 ? "LEFT" : (this.tabPlacement == 4 ? "RIGHT" : "")));
        String string2 = this.haveRegistered ? "true" : "false";
        return String.valueOf(super.paramString()) + ",haveRegistered=" + string2 + ",tabPlacement=" + string;
    }

    public void remove(Component component) {
        int n = this.indexOfComponent(component);
        if (n != -1) {
            this.removeTabAt(n);
        }
    }

    public void removeAll() {
        this.setSelectedIndex(-1);
        int n = this.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.getComponentAt(n2);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleVisibleData", component, null);
            }
            ++n2;
        }
        super.removeAll();
        this.pages.removeAllElements();
        this.revalidate();
        this.repaint();
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener != null ? class$javax$swing$event$ChangeListener : (class$javax$swing$event$ChangeListener = JTabbedPane.class$("javax.swing.event.ChangeListener")), changeListener);
    }

    public void removeTabAt(int n) {
        int n2 = this.getTabCount();
        int n3 = this.getSelectedIndex();
        if (n3 >= n2 - 1) {
            this.setSelectedIndex(n3 - 1);
        }
        Component component = this.getComponentAt(n);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", component, null);
        }
        if (component != null) {
            super.remove(component);
            component.setVisible(true);
        }
        this.pages.removeElementAt(n);
        this.revalidate();
        this.repaint();
    }

    public void setBackgroundAt(int n, Color color) {
        Rectangle rectangle;
        Color color2 = ((Page)this.pages.elementAt((int)n)).background;
        ((Page)this.pages.elementAt(n)).setBackground(color);
        if (!(color != null && color2 != null && color.equals(color2) || (rectangle = this.getBoundsAt(n)) == null)) {
            this.repaint(rectangle);
        }
    }

    public void setComponentAt(int n, Component component) {
        Page page = (Page)this.pages.elementAt(n);
        if (component != page.component) {
            if (page.component != null) {
                Object object = this.getTreeLock();
                synchronized (object) {
                    int n2 = this.getComponentCount();
                    Component[] componentArray = this.getComponents();
                    int n3 = 0;
                    while (n3 < n2) {
                        if (componentArray[n3] == page.component) {
                            this.remove(n3);
                        }
                        ++n3;
                    }
                }
            }
            page.component = component;
            component.setVisible(this.getSelectedIndex() == n);
            this.addImpl(component, null, -1);
            this.revalidate();
        }
    }

    public void setDisabledIconAt(int n, Icon icon) {
        Icon icon2 = ((Page)this.pages.elementAt((int)n)).disabledIcon;
        ((Page)this.pages.elementAt((int)n)).disabledIcon = icon;
        if (icon != icon2 && !this.isEnabledAt(n)) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setEnabledAt(int n, boolean bl) {
        boolean bl2 = ((Page)this.pages.elementAt(n)).isEnabled();
        ((Page)this.pages.elementAt(n)).setEnabled(bl);
        if (bl != bl2) {
            this.repaint(this.getBoundsAt(n));
        }
    }

    public void setForegroundAt(int n, Color color) {
        Rectangle rectangle;
        Color color2 = ((Page)this.pages.elementAt((int)n)).foreground;
        ((Page)this.pages.elementAt(n)).setForeground(color);
        if (!(color != null && color2 != null && color.equals(color2) || (rectangle = this.getBoundsAt(n)) == null)) {
            this.repaint(rectangle);
        }
    }

    public void setIconAt(int n, Icon icon) {
        Icon icon2 = ((Page)this.pages.elementAt((int)n)).icon;
        ((Page)this.pages.elementAt((int)n)).icon = icon;
        AccessibleContext accessibleContext = this.getAccessibleContext();
        if (icon2 != icon && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        if (icon != icon2) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setModel(SingleSelectionModel singleSelectionModel) {
        SingleSelectionModel singleSelectionModel2 = this.getModel();
        if (singleSelectionModel2 != null) {
            singleSelectionModel2.removeChangeListener(this.changeListener);
            this.changeListener = null;
        }
        this.model = singleSelectionModel;
        if (singleSelectionModel != null) {
            this.changeListener = this.createChangeListener();
            singleSelectionModel.addChangeListener(this.changeListener);
        }
        this.firePropertyChange("model", singleSelectionModel2, singleSelectionModel);
        this.repaint();
    }

    public void setSelectedComponent(Component component) {
        int n = this.indexOfComponent(component);
        if (n == -1) {
            throw new IllegalArgumentException("component not found in tabbed pane");
        }
        this.setSelectedIndex(n);
    }

    public void setSelectedIndex(int n) {
        Page page;
        int n2 = this.model.getSelectedIndex();
        this.model.setSelectedIndex(n);
        if (n2 >= 0 && n2 != n) {
            page = (Page)this.pages.elementAt(n2);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
            }
        }
        if (n >= 0 && n2 != n) {
            page = (Page)this.pages.elementAt(n);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            }
        }
    }

    public void setTabPlacement(int n) {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new IllegalArgumentException("illegal tab placement: must be TOP, BOTTOM, LEFT, or RIGHT");
        }
        if (this.tabPlacement != n) {
            int n2 = this.tabPlacement;
            this.tabPlacement = n;
            this.firePropertyChange("tabPlacement", n2, n);
            this.revalidate();
            this.repaint();
        }
    }

    public void setTitleAt(int n, String string) {
        String string2 = ((Page)this.pages.elementAt((int)n)).title;
        ((Page)this.pages.elementAt((int)n)).title = string;
        if (string2 != string && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, string);
        }
        if (string == null || string2 == null || !string.equals(string2)) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setUI(TabbedPaneUI tabbedPaneUI) {
        super.setUI(tabbedPaneUI);
    }

    public void updateUI() {
        this.setUI((TabbedPaneUI)UIManager.getUI(this));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected class ModelListener
    implements ChangeListener,
    Serializable {
        protected ModelListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane.this.fireStateChanged();
        }
    }

    protected class AccessibleJTabbedPane
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ChangeListener {
        public AccessibleJTabbedPane() {
            JTabbedPane.this.model.addChangeListener(this);
        }

        public void addAccessibleSelection(int n) {
            JTabbedPane.this.setSelectedIndex(n);
        }

        public void clearAccessibleSelection() {
        }

        public Accessible getAccessibleAt(Point point) {
            int n = ((TabbedPaneUI)JTabbedPane.this.ui).tabForCoordinate(JTabbedPane.this, point.x, point.y);
            if (n == -1) {
                n = JTabbedPane.this.getSelectedIndex();
            }
            return this.getAccessibleChild(n);
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= JTabbedPane.this.getTabCount()) {
                return null;
            }
            return (Accessible)JTabbedPane.this.pages.elementAt(n);
        }

        public int getAccessibleChildrenCount() {
            return JTabbedPane.this.getTabCount();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int n) {
            int n2 = JTabbedPane.this.getSelectedIndex();
            if (n2 == -1) {
                return null;
            }
            return (Accessible)JTabbedPane.this.pages.elementAt(n2);
        }

        public int getAccessibleSelectionCount() {
            return 1;
        }

        public boolean isAccessibleChildSelected(int n) {
            return n == JTabbedPane.this.getSelectedIndex();
        }

        public void removeAccessibleSelection(int n) {
        }

        public void selectAllAccessibleSelection() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            this.firePropertyChange("AccessibleSelection", null, object);
        }
    }

    private class Page
    extends AccessibleContext
    implements Serializable,
    Accessible,
    AccessibleComponent {
        String title;
        Color background;
        Color foreground;
        Icon icon;
        Icon disabledIcon;
        JTabbedPane parent;
        Component component;
        String tip;
        boolean enabled = true;
        boolean needsUIUpdate;

        Page(JTabbedPane jTabbedPane2, String string, Icon icon, Icon icon2, Component component, String string2) {
            AccessibleContext accessibleContext;
            this.title = string;
            this.icon = icon;
            this.disabledIcon = icon2;
            this.parent = jTabbedPane2;
            this.setAccessibleParent(jTabbedPane2);
            this.component = component;
            this.tip = string2;
            if (component instanceof Accessible && (accessibleContext = ((Accessible)((Object)component)).getAccessibleContext()) != null) {
                accessibleContext.setAccessibleParent(this);
            }
        }

        public void addFocusListener(FocusListener focusListener) {
        }

        public boolean contains(Point point) {
            Rectangle rectangle = this.getBounds();
            return rectangle.contains(point);
        }

        public Accessible getAccessibleAt(Point point) {
            if (this.component instanceof Accessible) {
                return (Accessible)((Object)this.component);
            }
            return null;
        }

        public Accessible getAccessibleChild(int n) {
            if (this.component instanceof Accessible) {
                return (Accessible)((Object)this.component);
            }
            return null;
        }

        public int getAccessibleChildrenCount() {
            if (this.component instanceof Accessible) {
                return 1;
            }
            return 0;
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public AccessibleContext getAccessibleContext() {
            return this;
        }

        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            if (this.tip != null) {
                return this.tip;
            }
            return null;
        }

        public int getAccessibleIndexInParent() {
            return this.parent.indexOfTab(this.title);
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (this.title != null) {
                return this.title;
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = this.parent.getAccessibleContext().getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            int n = this.parent.indexOfTab(this.title);
            if (n == this.parent.getSelectedIndex()) {
                accessibleStateSet.add(AccessibleState.SELECTED);
            }
            return accessibleStateSet;
        }

        public Color getBackground() {
            return this.background != null ? this.background : this.parent.getBackground();
        }

        public Rectangle getBounds() {
            return this.parent.getUI().getTabBounds(this.parent, this.parent.indexOfTab(this.title));
        }

        public Cursor getCursor() {
            return this.parent.getCursor();
        }

        public Font getFont() {
            return this.parent.getFont();
        }

        public FontMetrics getFontMetrics(Font font) {
            return this.parent.getFontMetrics(font);
        }

        public Color getForeground() {
            return this.foreground != null ? this.foreground : this.parent.getForeground();
        }

        public Locale getLocale() {
            return this.parent.getLocale();
        }

        public Point getLocation() {
            Rectangle rectangle = this.getBounds();
            return new Point(rectangle.x, rectangle.y);
        }

        public Point getLocationOnScreen() {
            Point point = this.parent.getLocationOnScreen();
            Point point2 = this.getLocation();
            point2.translate(point.x, point.y);
            return point2;
        }

        public Dimension getSize() {
            Rectangle rectangle = this.getBounds();
            return new Dimension(rectangle.width, rectangle.height);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public boolean isShowing() {
            return this.parent.isShowing();
        }

        public boolean isVisible() {
            return this.parent.isVisible();
        }

        public void removeFocusListener(FocusListener focusListener) {
        }

        public void requestFocus() {
        }

        public void setBackground(Color color) {
            this.background = color;
        }

        public void setBounds(Rectangle rectangle) {
        }

        public void setCursor(Cursor cursor) {
            this.parent.setCursor(cursor);
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setFont(Font font) {
            this.parent.setFont(font);
        }

        public void setForeground(Color color) {
            this.foreground = color;
        }

        public void setLocation(Point point) {
        }

        public void setSize(Dimension dimension) {
        }

        public void setVisible(boolean bl) {
            this.parent.setVisible(bl);
        }
    }
}

