/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.BasicPlayer;
import com.sun.media.controls.ProgressControl;
import com.sun.media.controls.StringControl;
import com.sun.media.controls.VideoSizingControl;
import com.sun.media.ui.BufferedPanel;
import com.sun.media.ui.DefaultControlPanel;
import com.sun.media.ui.Group;
import com.sun.media.ui.ImageComponent;
import com.sun.media.ui.StringComponent;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.ControllerAdapter;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.Player;
import javax.media.Time;

public class PropertySheet {
    Frame frame;
    Dialog dialog;
    Window win;
    Window sheet;
    Point panelPos;
    Panel infoPanel;
    Container centerPanel;
    Container buttonPanel;
    boolean firstTime = true;
    StringComponent durationLabel;
    Player player;
    ProgressControl progressControl;
    Button okButton;
    String urlName;
    static long NS_TO_HOUR = 3600000000000L;
    static long NS_TO_MIN = 60000000000L;
    static long NS_TO_SEC = 1000000000L;
    static long NS_TO_MS = 1000000L;

    public PropertySheet(Frame f2, Player player, ProgressControl pc, VideoSizingControl vsc, String urlName) {
        String header;
        this.player = player;
        this.progressControl = pc;
        if (urlName == null) {
            header = "Media Properties";
        } else {
            if (urlName.length() > 35) {
                urlName = "..." + urlName.substring(urlName.length() - 35);
            }
            header = urlName;
        }
        this.urlName = urlName;
        this.frame = f2;
        if (this.frame == null) {
            this.frame = new Frame(header);
            this.sheet = this.frame;
        } else {
            this.dialog = new Dialog(this.frame, header, false);
            this.sheet = this.dialog;
        }
        this.sheet.addWindowListener(new 1());
        this.sheet.setLayout(new BorderLayout());
        ((Component)this.sheet).setBackground(DefaultControlPanel.BackgroundColor);
        this.centerPanel = new Group(new BorderLayout(), 4);
        this.infoPanel = this.createInfoPanel(pc);
        this.centerPanel.add("Center", this.infoPanel);
        this.sheet.add("Center", this.centerPanel);
        this.buttonPanel = new Panel(new FlowLayout());
        this.okButton = new Button(JMFI18N.getResource("propertysheet.close"));
        this.okButton.addActionListener(new 2());
        this.buttonPanel.add(this.okButton);
        this.sheet.add("South", this.buttonPanel);
        this.sheet.pack();
        if (player != null) {
            player.addControllerListener(new 3());
            this.updateDuration(player.getDuration());
        }
    }

    public synchronized void dispose() {
        if (this.sheet == null) {
            return;
        }
        this.sheet.removeAll();
        ((Component)this.sheet).hide();
        if (this.sheet instanceof Frame) {
            ((Frame)this.sheet).dispose();
        }
        this.sheet = null;
        this.frame = null;
        this.progressControl = null;
    }

    private Panel createInfoPanel(ProgressControl pc) {
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagConstraints labelConstraints = new GridBagConstraints();
        GridBagConstraints valueConstraints = new GridBagConstraints();
        GridBagConstraints groupConstraints = new GridBagConstraints();
        GridBagConstraints groupValueConstraints = new GridBagConstraints();
        StringControl bitrate = null;
        StringControl vcodec = null;
        StringControl vsize = null;
        StringControl fps = null;
        StringControl acodec = null;
        StringControl aquality = null;
        int row = 0;
        Container version = null;
        if (pc != null) {
            bitrate = pc.getBitRate();
            vcodec = pc.getVideoCodec();
            vsize = pc.getVideoProperties();
            fps = pc.getFrameRate();
            acodec = pc.getAudioCodec();
            aquality = pc.getAudioProperties();
        }
        GridBagLayout gbl = new GridBagLayout();
        BufferedPanel panel = new BufferedPanel(gbl);
        panel.setBackground(new Color(95, 95, 95));
        panel.setForeground(Color.white);
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 0;
        labelConstraints.gridwidth = 3;
        labelConstraints.anchor = 13;
        labelConstraints.fill = 2;
        labelConstraints.insets = new Insets(-2, 25, -2, 2);
        valueConstraints.gridx = 3;
        valueConstraints.gridy = 0;
        valueConstraints.gridwidth = 0;
        valueConstraints.anchor = 17;
        valueConstraints.fill = 2;
        valueConstraints.insets = new Insets(-2, 2, -2, 15);
        groupConstraints.gridx = 0;
        groupConstraints.gridy = 0;
        groupConstraints.gridwidth = 1;
        groupConstraints.anchor = 17;
        groupConstraints.insets = new Insets(7, 15, -2, 2);
        groupValueConstraints = (GridBagConstraints)valueConstraints.clone();
        groupValueConstraints.insets = new Insets(7, 2, -2, 15);
        version = this.createVersionGroup();
        gbc.gridwidth = 0;
        gbc.insets = new Insets(10, 15, 5, 0);
        gbc.anchor = 17;
        panel.add(version);
        gbl.setConstraints(version, gbc);
        StringComponent label = this.newLabel("propertysheet.url", true);
        panel.add(label);
        groupConstraints.gridy = ++row;
        gbl.setConstraints(label, groupConstraints);
        groupConstraints.gridwidth = 2;
        if (this.urlName != null) {
            label = this.newValue(this.urlName);
            panel.add(label);
        } else {
            label = this.newValue(this.getString("propertysheet.unknown"));
            panel.add(label);
        }
        groupValueConstraints.gridy = row++;
        groupValueConstraints.gridx = 1;
        gbl.setConstraints(label, groupValueConstraints);
        label = this.newLabel("propertysheet.duration");
        panel.add(label);
        labelConstraints.gridy = row;
        gbl.setConstraints(label, labelConstraints);
        this.durationLabel = this.newValue(this.getString("propertysheet.unknown"));
        panel.add(this.durationLabel);
        valueConstraints.gridy = row++;
        gbl.setConstraints(this.durationLabel, valueConstraints);
        label = this.newLabel("propertysheet.bit.rate");
        panel.add(label);
        labelConstraints.gridy = row;
        gbl.setConstraints(label, labelConstraints);
        label = this.newValue(this.getString("mediaplayer.N/A"));
        panel.add(label);
        valueConstraints.gridy = row;
        gbl.setConstraints(label, valueConstraints);
        if (bitrate != null) {
            label.setControl(bitrate);
        }
        if (vcodec != null || vsize != null || fps != null) {
            label = this.newLabel("propertysheet.video", true);
            panel.add(label);
            groupConstraints.gridy = ++row;
            gbl.setConstraints(label, groupConstraints);
        }
        if (vcodec != null) {
            label = this.newLabel("propertysheet.video.codec");
            panel.add(label);
            labelConstraints.gridy = ++row;
            gbl.setConstraints(label, labelConstraints);
            label = this.newValue(this.getString("mediaplayer.N/A"));
            panel.add(label);
            valueConstraints.gridy = row;
            gbl.setConstraints(label, valueConstraints);
            label.setControl(vcodec);
        }
        if (vsize != null) {
            label = this.newLabel("propertysheet.video.size");
            panel.add(label);
            labelConstraints.gridy = ++row;
            gbl.setConstraints(label, labelConstraints);
            label = this.newValue(this.getString("mediaplayer.N/A"));
            panel.add(label);
            valueConstraints.gridy = row;
            gbl.setConstraints(label, valueConstraints);
            label.setControl(vsize);
        }
        if (fps != null) {
            label = this.newLabel("propertysheet.video.rate");
            panel.add(label);
            labelConstraints.gridy = ++row;
            gbl.setConstraints(label, labelConstraints);
            label = this.newValue(this.getString("mediaplayer.N/A"));
            panel.add(label);
            valueConstraints.gridy = row;
            gbl.setConstraints(label, valueConstraints);
            label.setControl(fps);
        }
        if (acodec != null || aquality != null) {
            label = this.newLabel("propertysheet.audio", true);
            panel.add(label);
            groupConstraints.gridy = ++row;
            gbl.setConstraints(label, groupConstraints);
        }
        if (acodec != null) {
            label = this.newLabel("propertysheet.audio.codec");
            panel.add(label);
            labelConstraints.gridy = ++row;
            gbl.setConstraints(label, labelConstraints);
            label = this.newValue(this.getString("mediaplayer.N/A"));
            panel.add(label);
            valueConstraints.gridy = row;
            gbl.setConstraints(label, valueConstraints);
            label.setControl(acodec);
        }
        if (aquality != null) {
            label = this.newLabel("propertysheet.audio.quality");
            panel.add(label);
            labelConstraints.gridy = ++row;
            gbl.setConstraints(label, labelConstraints);
            label = this.newValue(this.getString("mediaplayer.N/A"));
            panel.add(label);
            valueConstraints.gridy = row;
            gbl.setConstraints(label, valueConstraints);
            label.setControl(aquality);
        }
        label = this.newValue(" ");
        panel.add(label);
        labelConstraints.gridy = ++row;
        gbl.setConstraints(label, labelConstraints);
        return panel;
    }

    protected Container createVersionGroup() {
        GridBagLayout gbl = new GridBagLayout();
        Group group = new Group(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        ImageComponent icon = new ImageComponent("", "logo.gif");
        group.add(icon);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbl.setConstraints(icon, gbc);
        StringComponent label = new StringComponent(this.getString("propertysheet.JavaMediaPlayer"), 1, true);
        group.add(label);
        gbc.gridx = 1;
        gbc.gridheight = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(-2, 0, -2, 0);
        gbl.setConstraints(label, gbc);
        label = new StringComponent(BasicPlayer.VERSION, 1, false);
        group.add(label);
        gbc.gridy = 1;
        gbl.setConstraints(label, gbc);
        return group;
    }

    public void showAt(int x, int y) {
        if (this.firstTime) {
            ((Component)this.sheet).setLocation(x, y);
            ((Component)this.sheet).setVisible(true);
            ((Component)this.sheet).setSize(this.sheet.getPreferredSize());
            this.firstTime = false;
        } else {
            ((Component)this.sheet).setVisible(true);
        }
    }

    public void hide() {
        if (this.sheet != null) {
            ((Component)this.sheet).setVisible(false);
        }
    }

    protected String getString(String resource) {
        return JMFI18N.getResource(resource);
    }

    protected StringComponent newLabel(String property, boolean bold) {
        return new StringComponent(this.getString(property), 2, bold);
    }

    protected StringComponent newLabel(String property) {
        return this.newLabel(property, false);
    }

    protected StringComponent newValue(String initial, boolean bold) {
        return new StringComponent(initial, 0, bold);
    }

    protected StringComponent newValue(String initial) {
        return this.newValue(initial, false);
    }

    protected void updateDuration(Time duration) {
        if (this.durationLabel != null) {
            if (duration == Duration.DURATION_UNKNOWN || duration == Duration.DURATION_UNBOUNDED) {
                this.durationLabel.setText(this.getString("propertysheet.unknown"));
            } else {
                String value = this.toHMS(duration.getNanoseconds());
                if (value.equals("")) {
                    this.durationLabel.setText(this.getString("propertysheet.unknown"));
                } else {
                    this.durationLabel.setText(value);
                }
            }
        }
    }

    protected String toHMS(long time) {
        String s = "";
        long hour = time / NS_TO_HOUR;
        time -= hour * NS_TO_HOUR;
        if (hour > 0L) {
            s = String.valueOf(s) + hour + " hr ";
        }
        long min = time / NS_TO_MIN;
        time -= min * NS_TO_MIN;
        if (min > 0L) {
            s = String.valueOf(s) + min + " min ";
        }
        long sec = time / NS_TO_SEC;
        time -= sec * NS_TO_SEC;
        if (sec > 0L) {
            s = String.valueOf(s) + sec + " sec ";
        }
        return s;
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent we) {
            PropertySheet.this.hide();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e2) {
            PropertySheet.this.hide();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends ControllerAdapter {
        public void durationUpdate(DurationUpdateEvent e2) {
            PropertySheet.this.updateDuration(e2.getDuration());
        }

        /* synthetic */ 3() {
        }
    }
}

