/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.controls.AtomicControl;
import com.sun.media.controls.ControlChangeEvent;
import com.sun.media.controls.ControlChangeListener;
import com.sun.media.controls.NumericControl;
import com.sun.media.controls.SliderRegionControl;
import com.sun.media.ui.AtomicComponent;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12PriorityAction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class ProgressSlider
extends AtomicComponent
implements ControlChangeListener,
MouseListener,
MouseMotionListener,
Runnable {
    Image imageGrabber;
    Image imageGrabberDown;
    int grabberWidth;
    int grabberHeight;
    boolean grabbed;
    boolean entered;
    int grabberPosition;
    int leftBorder;
    int rightBorder;
    int sliderWidth;
    MediaThread timer;
    protected boolean justSeeked = false;
    protected SliderRegionControl displayControl;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    static /* synthetic */ Class class$com$sun$media$util$MediaThread;

    public ProgressSlider(String tip) {
        super(tip);
        this.imageGrabber = AtomicComponent.fetchImage("grabber.gif");
        this.imageGrabberDown = AtomicComponent.fetchImage("grabber-pressed.gif");
        this.grabberWidth = this.imageGrabber.getWidth(this);
        this.grabberHeight = this.imageGrabber.getHeight(this);
        this.rightBorder = this.leftBorder = this.grabberWidth / 2;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.grabberPosition = 0;
        this.grabbed = false;
        this.entered = false;
        this.height = 18;
        this.width = 20;
        this.sliderWidth = this.width - this.leftBorder - this.rightBorder;
    }

    public void addNotify() {
        super.addNotify();
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("netscape")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable e2) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                ProgressSlider slider = this;
                Constructor cons = jdk12CreateThreadRunnableAction.cons;
                this.timer = (MediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$util$MediaThread != null ? class$com$sun$media$util$MediaThread : (class$com$sun$media$util$MediaThread = ProgressSlider.class$("com.sun.media.util.MediaThread")), this));
                this.timer.setName("Progress Slider thread");
                cons = jdk12PriorityAction.cons;
                jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(this.timer, new Integer(MediaThread.getControlPriority())));
                this.timer.start();
            }
            catch (Exception exception) {}
        } else {
            this.timer = new MediaThread(this);
            this.timer.setName("Progress Slider thread");
            this.timer.useControlPriority();
            this.timer.start();
        }
    }

    public void removeNotify() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        super.removeNotify();
    }

    public void dispose() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = null;
    }

    public void run() {
        while (true) {
            try {
                if (this.control instanceof NumericControl) {
                    NumericControl nc = (NumericControl)this.control;
                    this.seek(nc.getValue() / nc.getUpperLimit());
                }
            }
            catch (Exception exception) {}
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
            if (!this.justSeeked) continue;
            this.justSeeked = false;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public void paint(Graphics g2) {
        g2.setColor(this.getBackground());
        int y = this.height / 2 - 2;
        int grabberY = this.height / 2 - this.grabberHeight / 2;
        if (this.isEnabled()) {
            g2.draw3DRect(2, y, this.width - 4, 3, false);
            if (this.displayControl != null && this.displayControl.isEnable()) {
                int percent = (int)this.displayControl.getMaxValue();
                if (percent < 100) {
                    g2.setColor(Color.yellow);
                    int x = this.sliderWidth * percent / 100 + 3;
                    g2.drawLine(x, y += 2, this.width - 4, y);
                    g2.setColor(Color.green);
                    g2.drawLine(0, y, x, y);
                } else {
                    g2.setColor(Color.green);
                    g2.drawLine(0, y += 2, this.width - 4, y);
                }
            }
            if (this.grabbed || this.entered) {
                g2.drawImage(this.imageGrabberDown, this.grabberPosition + this.leftBorder - this.grabberWidth / 2, grabberY, this);
            } else {
                g2.drawImage(this.imageGrabber, this.grabberPosition + this.leftBorder - this.grabberWidth / 2, grabberY, this);
            }
        }
    }

    public void controlChanged(ControlChangeEvent e2) {
        if (this.control instanceof NumericControl) {
            NumericControl nc = (NumericControl)this.control;
            float mediaTime = ((NumericControl)this.control).getValue();
            float uL = nc.getUpperLimit();
            if (uL <= 1.0f) {
                this.setEnabled(false);
                this.repaint();
            } else if (!this.isEnabled()) {
                this.setEnabled(true);
            }
            if (uL != 0.0f) {
                this.seek(nc.getValue() / nc.getUpperLimit());
            }
        }
    }

    public void setControl(NumericControl nc) {
        super.setControl(nc);
        float uL = nc.getUpperLimit();
        if (uL <= 1.0f) {
            this.setEnabled(false);
            this.repaint();
        } else {
            this.seek(nc.getValue() / uL);
        }
    }

    public void setDisplayControl(SliderRegionControl display) {
        this.displayControl = display;
        this.repaint();
    }

    private void sliderSeek(float fraction) {
        if (this.control != null && this.control instanceof NumericControl) {
            NumericControl nc = (NumericControl)this.control;
            float value = fraction * nc.getUpperLimit();
            if (!this.isEnabled() && value >= 0.0f) {
                this.setEnabled(true);
            }
            if (value < 0.0f) {
                this.setEnabled(false);
            }
            this.justSeeked = true;
            nc.setValue(value);
        }
    }

    public void seek(float fraction) {
        if (this.justSeeked) {
            return;
        }
        if (!this.isEnabled() && ((NumericControl)this.control).getUpperLimit() > 0.0f) {
            this.setEnabled(true);
        }
        if (!this.grabbed) {
            int newPosition = (int)(fraction * (float)this.sliderWidth);
            if (newPosition > this.sliderWidth) {
                newPosition = this.sliderWidth;
            }
            if (newPosition < 0) {
                newPosition = 0;
            }
            this.grabberPosition = newPosition;
            this.repaint();
        }
    }

    public void setSize(int w, int h2) {
        if (w < 30) {
            w = 30;
        }
        super.setSize(w, this.height);
        this.grabberPosition = (int)((float)this.grabberPosition * ((float)(w - this.leftBorder - this.rightBorder) / (float)(this.width - this.leftBorder - this.rightBorder)));
        this.width = w;
        this.sliderWidth = this.width - this.leftBorder - this.rightBorder;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public float sliderToSeek(int x) {
        float s = (float)x / (float)this.sliderWidth;
        return s;
    }

    public int mouseToSlider(int x) {
        if (x < this.leftBorder) {
            x = this.leftBorder;
        }
        if (x > this.width - this.rightBorder) {
            x = this.width - this.rightBorder;
        }
        return x -= this.leftBorder;
    }

    public void mousePressed(MouseEvent me) {
        if (!this.isEnabled() || !((AtomicControl)this.control).getEnabled()) {
            return;
        }
        this.grabbed = true;
        this.grabberPosition = this.mouseToSlider(me.getX());
        this.repaint();
    }

    public void mouseReleased(MouseEvent me) {
        if (!this.isEnabled() || !((AtomicControl)this.control).getEnabled()) {
            return;
        }
        this.grabbed = false;
        this.grabberPosition = this.mouseToSlider(me.getX());
        float seek = this.sliderToSeek(this.grabberPosition);
        this.sliderSeek(seek);
        this.repaint();
    }

    public void mouseClicked(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
        if (!((AtomicControl)this.control).getEnabled()) {
            return;
        }
        this.entered = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent me) {
        if (!((AtomicControl)this.control).getEnabled()) {
            return;
        }
        this.entered = false;
        this.repaint();
    }

    public void mouseMoved(MouseEvent me) {
    }

    public void mouseDragged(MouseEvent me) {
        if (!this.isEnabled() || !((AtomicControl)this.control).getEnabled()) {
            return;
        }
        int newPosition = this.mouseToSlider(me.getX());
        if (newPosition != this.grabberPosition) {
            this.grabberPosition = newPosition;
            this.repaint();
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }
}

