/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtsp;

import com.sun.media.rtsp.Debug;
import com.sun.media.rtsp.MessageProcessor;
import com.sun.media.rtsp.RtspManager;
import com.sun.media.rtsp.RtspPort;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class Connection
extends Thread
implements Runnable {
    public int connectionId;
    private Socket socket;
    private RtspManager rtspManager;
    private MessageProcessor mp;

    public Connection(RtspManager rtspManager, int connectionId, byte[] dstAddress) throws UnknownHostException, ConnectException {
        this.rtspManager = rtspManager;
        this.connectionId = connectionId;
        String domain = new String(dstAddress);
        InetAddress dst = InetAddress.getByName(domain);
        try {
            System.err.println("dst: " + dst);
            this.socket = new Socket(dst, RtspPort.getPort());
            System.err.println("TI Socket: " + this.socket.toString());
            this.start();
        }
        catch (IOException iOException) {
            throw new ConnectException();
        }
    }

    public Connection(RtspManager rtspManager, int connectionId, Socket socket) {
        this.rtspManager = rtspManager;
        this.connectionId = connectionId;
        this.socket = socket;
        this.start();
    }

    public void sendData(byte[] message) {
        Debug.println("RTSP::Connection:sendData=" + new String(message));
        System.out.println("Socket: " + this.socket.toString());
        try {
            OutputStream out = this.socket.getOutputStream();
            out.write(message);
            out.flush();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void run() {
        try {
            try {
                System.out.println("Connection-" + this.connectionId + " running...");
                InputStream in = this.socket.getInputStream();
                DataInputStream din = new DataInputStream(in);
                while (true) {
                    byte ch = din.readByte();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    baos.write(ch);
                    while (!this.eomReached(baos.toByteArray())) {
                        baos.write(din.readByte());
                    }
                    int length = this.getContentLength(new String(baos.toByteArray()));
                    int i2 = 0;
                    while (i2 < length) {
                        baos.write(din.readByte());
                        ++i2;
                    }
                    if (this.mp == null) {
                        this.mp = new MessageProcessor(this.connectionId, this.rtspManager);
                    }
                    this.mp.processMessage(baos.toByteArray());
                }
            }
            catch (IOException iOException) {
                Debug.println("RTSP::Connection:connection terminated.");
                Object var2_7 = null;
                this.cleanup();
            }
        }
        catch (Throwable throwable) {
            Object var2_8 = null;
            this.cleanup();
            throw throwable;
        }
    }

    private boolean eomReached(byte[] buffer) {
        boolean endReached = false;
        int size = buffer.length;
        if (size >= 4 && buffer[size - 4] == 13 && buffer[size - 3] == 10 && buffer[size - 2] == 13 && buffer[size - 1] == 10) {
            endReached = true;
        }
        return endReached;
    }

    private int getContentLength(String msg_header) {
        int length;
        System.out.println("msg_header: " + msg_header);
        int start = msg_header.indexOf("Content-length");
        if (start == -1) {
            start = msg_header.indexOf("Content-Length");
        }
        if (start == -1) {
            length = 0;
        } else {
            start = msg_header.indexOf(58, start) + 2;
            int end = msg_header.indexOf(13, start);
            String length_str = msg_header.substring(start, end);
            length = new Integer(length_str);
        }
        return length;
    }

    public void cleanup() {
        Debug.println("RTSP::Connection:cleanup, id=" + this.connectionId);
        this.close();
        this.rtspManager.removeConnection(this.connectionId);
    }

    public void close() {
        try {
            if (this.socket != null) {
                Debug.println("close socket=" + this.socket);
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public String getIpAddress() {
        return this.socket.getInetAddress().getHostAddress();
    }
}

