/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import com.sun.media.rtp.util.PacketFilter;
import com.sun.media.rtp.util.RTPPacket;
import com.sun.media.rtp.util.RTPPacketSender;
import com.sun.media.rtp.util.UDPPacket;
import com.sun.media.rtp.util.UDPPacketSender;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class RTPRawSender
extends PacketFilter {
    private InetAddress destaddr;
    private int destport;

    public String filtername() {
        return "RTP Raw Packet Sender";
    }

    public RTPRawSender(int port, String address) throws UnknownHostException, IOException {
        this.destaddr = InetAddress.getByName(address);
        this.destport = port;
        this.destaddresslist = null;
    }

    public RTPRawSender(int port, String address, UDPPacketSender sender) throws UnknownHostException, IOException {
        this(port, address);
        this.setConsumer(sender);
        this.destaddresslist = null;
    }

    public RTPRawSender(RTPPacketSender sender) {
        this.setConsumer(sender);
    }

    public InetAddress getRemoteAddr() {
        return this.destaddr;
    }

    public Packet handlePacket(Packet p2, int i2) {
        return null;
    }

    public Packet handlePacket(Packet p2) {
        this.assemble((RTPPacket)p2);
        PacketConsumer consumer = this.getConsumer();
        if (consumer instanceof RTPPacketSender) {
            return p2;
        }
        UDPPacket udpp = new UDPPacket();
        udpp.received = false;
        udpp.data = p2.data;
        udpp.offset = p2.offset;
        udpp.length = p2.length;
        udpp.remoteAddress = this.destaddr;
        udpp.remotePort = this.destport;
        return udpp;
    }

    public void assemble(RTPPacket p2) {
        int len = p2.calcLength();
        p2.assemble(len, false);
    }
}

