/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTPSessionMgr;
import com.sun.media.rtp.util.RTPMediaThread;
import java.util.Vector;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionListener;
import javax.media.rtp.event.RTPEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemoteEvent;
import javax.media.rtp.event.SendStreamEvent;
import javax.media.rtp.event.SessionEvent;

public class RTPEventHandler
extends RTPMediaThread {
    private RTPSessionMgr sm;
    private Vector eventQueue = new Vector();

    public RTPEventHandler(RTPSessionMgr sm) {
        super("RTPEventHandler");
        this.sm = sm;
        this.useControlPriority();
        this.setDaemon(true);
        this.start();
    }

    protected void processEvent(RTPEvent evt) {
        if (evt instanceof SessionEvent) {
            int i2 = 0;
            while (i2 < this.sm.sessionlistener.size()) {
                ((SessionListener)this.sm.sessionlistener.elementAt(i2)).update((SessionEvent)evt);
                ++i2;
            }
            return;
        }
        if (evt instanceof RemoteEvent) {
            int i3 = 0;
            while (i3 < this.sm.remotelistener.size()) {
                ((RemoteListener)this.sm.remotelistener.elementAt(i3)).update((RemoteEvent)evt);
                ++i3;
            }
            return;
        }
        if (evt instanceof ReceiveStreamEvent) {
            int i4 = 0;
            while (i4 < this.sm.streamlistener.size()) {
                ((ReceiveStreamListener)this.sm.streamlistener.elementAt(i4)).update((ReceiveStreamEvent)evt);
                ++i4;
            }
            return;
        }
        if (evt instanceof SendStreamEvent) {
            int i5 = 0;
            while (i5 < this.sm.sendstreamlistener.size()) {
                ((SendStreamListener)this.sm.sendstreamlistener.elementAt(i5)).update((SendStreamEvent)evt);
                ++i5;
            }
        }
    }

    protected synchronized void dispatchEvents() {
        try {
            while (this.eventQueue.size() == 0) {
                this.wait();
            }
        }
        catch (InterruptedException e2) {
            System.err.println("RTPEventThread " + e2);
            return;
        }
        RTPEvent evt = (RTPEvent)this.eventQueue.elementAt(0);
        this.eventQueue.removeElementAt(0);
        this.processEvent(evt);
    }

    public synchronized void postEvent(RTPEvent evt) {
        this.eventQueue.addElement(evt);
        this.notifyAll();
    }

    public void close() {
        this.stop();
    }

    public void run() {
        while (true) {
            this.dispatchEvents();
        }
    }
}

