/* PhotoOrganizer - $RCSfile: PlaybackProperties.java,v $                         
 * Copyright (C) 2001 Dmitriy Rogatkin.  All rights reserved.                   
 * Redistribution and use in source and binary forms, with or without           
 * modification, are permitted provided that the following conditions           
 * are met:                                                                     
 * 1. Redistributions of source code must retain the above copyright            
 *    notice, this list of conditions and the following disclaimer.             
 * 2. Redistributions in binary form must reproduce the above copyright         
 *    notice, this list of conditions and the following disclaimer in the       
 *    documentation and/or other materials provided with the distribution.      
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND      
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE       
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE  
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR  
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL      
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR  
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER  
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT          
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY   
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF      
 *  SUCH DAMAGE.                                                                
 *                                                                              
 *  Visit http://drogatkin.openestate.net to get the latest infromation         
 *  about Rogatkin's products.                                                  
 *  $Id: PlaybackProperties.java,v 1.3 2001/07/19 07:58:31 rogatkin Exp $          
 */                                                                             

package photoorganizer.renderer;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
import java.io.File;

import rogatkin.*;      
import photoorganizer.*;
import photoorganizer.formats.*;
import photoorganizer.media.*;

public class PlaybackProperties extends JPanel { 
	
	public static final int START_YEAR = 1938;
	public static final String PLAY_ATTRIBUTES[] = {                                   
		AbstractInfo.ALBUM, AbstractInfo.ARTISTWEBPAGE, AbstractInfo.AUDIOFILEWEBPAGE,
		AbstractInfo.AUDIOSOURCEWEBPAGE, AbstractInfo.BAND, AbstractInfo.CDIDENTIFIER, AbstractInfo.COMMENTS,
		AbstractInfo.COMPOSER, AbstractInfo.CONDUCTOR, AbstractInfo.CONTENTGROUP, AbstractInfo.COPYRIGHTTEXT,
		AbstractInfo.COPYRIGHT, AbstractInfo.COPYRIGHTWEBPAGE,	AbstractInfo.FILEOWNER, AbstractInfo.FILETYPE,
		AbstractInfo.INITIALKEY, AbstractInfo.INTERNETRADIOSTATIONNAME, AbstractInfo.INTERNETRADIOSTATIONOWNER,
		AbstractInfo.INTERNETRADIOSTATIONWEBPAGE, AbstractInfo.ISRC, AbstractInfo.LANGUAGE, AbstractInfo.LYRICIST,
		AbstractInfo.MEDIATYPE, AbstractInfo.ORIGINAL, AbstractInfo.ORIGINALARTIST,	AbstractInfo.ORIGINALLYRICIST,
		AbstractInfo.ORIGINALTITLE, AbstractInfo.ORIGINALYEAR, AbstractInfo.OWNERSHIP,
		AbstractInfo.PUBLISHER, AbstractInfo.PUBLISHERSWEBPAGE, AbstractInfo.RECORDINGDATES,
		AbstractInfo.REMIXER, AbstractInfo.REVERB, AbstractInfo.SUBTITLE, AbstractInfo.TITLE,
		AbstractInfo.TRACK, AbstractInfo.UNIQUEFILEIDENTIFIER, AbstractInfo.USERDEFINEDTEXT,
		AbstractInfo.BITRATE, AbstractInfo.MODE, AbstractInfo.SAMPLERATE
	};
		
	public PlaybackProperties(Controller controller, Window window) {
		setLayout(new GranulatedLayout(5, 13, Resources.CTRL_VERT_SIZE, 
									   Resources.CTRL_VERT_GAP, Resources.CTRL_HORIS_INSET,             
									   Resources.CTRL_HORIZ_GAP));
		this.controller = controller;
		if (window == null)
			throw new IllegalArgumentException("Window cannot be null.");
		this.window = window;
		add(new JLabel(Resources.LABEL_SCHEMA_NAME), "0,0");
		add(cb_schema = new JComboBox(), "1,0,2");
		cb_schema.setEditable(true);
		JTabbedPane propPanel = new JTabbedPane(SwingConstants.TOP);
		propPanel.insertTab(Resources.TAB_GENRE, (Icon)null,
				  			 gsp = new GenreSelectionPanel(),
				  			 Resources.TTIP_GENRE,
				  			 0);
		propPanel.insertTab(Resources.TAB_ARTIST, (Icon)null,
				  			 asp = new ArtistSelectionPanel(),
				  			 Resources.TTIP_ARTIST,
				  			 1);
		propPanel.insertTab(Resources.TAB_YEARS, (Icon)null,
				  			 ysp = new YearSelectionPanel(),
				  			 Resources.TTIP_YEARS,
				  			 2);
		propPanel.insertTab(Resources.TAB_ADDITIONS, (Icon)null,
				  			 dsp = new AdditionsSelectionPanel(),
				  			 Resources.TTIP_ADDITIONS,
				  			 3);
		add(propPanel, "0,1,5,9");
		
		ButtonGroup group = new ButtonGroup();
		add(rb_rand = new JRadioButton(Resources.LABEL_RANDOM), "0,10");
		group.add(rb_rand);
		rb_rand.setSelected(true);
		add(rb_shuffl = new JRadioButton(Resources.LABEL_SHUFFLE), "1,10");
		group.add(rb_shuffl);
		add(cb_exclude = new JCheckBox(Resources.LABEL_EXCLUDE), "2,10");
		// digest mode
		add(cb_intro = new JCheckBox(Resources.LABEL_INTROMODE), "3,10,2");
		
		JPanel buttons = new JPanel();
		buttons.setLayout(new FlowLayout());
		JButton b;
		buttons.add(b = new JButton(Resources.CMD_OK));
		b.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// process
				matcher = new ContentMatcher();
				matcher.setGenres(gsp.getData());
				matcher.setArtists(asp.getData());
				matcher.setYears(ysp.getData());
				matcher.setExcludeMode(cb_exclude.isSelected());
				matcher.setExtraConditions(dsp.getData());
				PlaybackProperties.this.window.dispose();
			}
			}
			);
		buttons.add(b = new JButton(Resources.CMD_CANCEL));
		b.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {		
				PlaybackProperties.this.window.dispose();		
			}		
			}		
			);
		buttons.add(new JButton(Resources.CMD_HELP));    
		buttons.add(new JButton(Resources.CMD_ADVANCED));
		add(buttons, "1,11,4,2");
	}
	
	public ContentMatcher getMatcher() {
		return matcher;
	}
	
	public void applyTo(PlaybackRequest request) {
		request.matcher = getMatcher();
		if (!cb_intro.isSelected())
			request.introFrames = 0;
		request.shuffled = rb_shuffl.isSelected();
		
	}
	
	// TODO: add version getting the list from flat file
	// TODO: add version returning request structure used for matching the selected criterias
	
	public static void doModal(Controller controller, PlaybackRequest request) {
		JFrame frame = new JFrame(Resources.TITLE_CONTENT_SELECTION_CRITERIA);
		frame.setIconImage(controller.getMainIcon());
		final PlaybackProperties pbps = new PlaybackProperties(controller, frame);
		frame.setContentPane(pbps);
		frame.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosed(WindowEvent e) {
				synchronized(pbps) {
					pbps.notify();
				}
			}
			}
			);
		frame.pack();
		frame.setVisible(true);
		synchronized(pbps) {
			try {
				pbps.wait();
				pbps.applyTo(request);				
			} catch(InterruptedException ie) {
			}
		}
	}
	
	public static PlaybackProperties doPropertiesDialog(Controller controller, Frame frame) {
		PlaybackProperties result = null;
		JDialog dialog = new JDialog(frame==null?controller.getMainFrame():frame, Resources.TITLE_CONTENT_SELECTION_CRITERIA, true);
		dialog.setContentPane(result = new PlaybackProperties(controller, dialog));
		dialog.pack();
		dialog.show();
		return result;
	}
	
	public static Object[] doModal(Controller controller, Object[] medias) {
		if (medias == null || medias.length == 0)
			return null;
		// TODO: make desc from frame and override dispose to notify
		JFrame frame = new JFrame(Resources.TITLE_CONTENT_SELECTION_CRITERIA);
		frame.setIconImage(controller.getMainIcon());
		final PlaybackProperties pbps = new PlaybackProperties(controller, frame);
		frame.getContentPane().add(pbps, "Center");
		frame.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE );
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosed(WindowEvent e) {
				synchronized(pbps) {
					pbps.notify();
				}
			}
			}
			);
		frame.pack();
		frame.setVisible(true);
		synchronized(pbps) {
			try {
				pbps.wait();
			} catch(InterruptedException ie) {
				return null;
			}
		}
		ContentMatcher matcher = pbps.getMatcher();
		if (matcher == null) 
			return null;
		int k=0;
		for (int i=0; i<medias.length; i++)
			if (medias[i] instanceof AbstractFormat)
				if (matcher.match((AbstractFormat)medias[i]))
					medias[k++] = medias[i];
				else;
			else if (medias[i] instanceof File)
				if (matcher.match(MediaFormatFactory.createMediaFormat((File)medias[i])))
					medias[k++] = medias[i];
				else;
		if (k == 0)
			return null;
		Object []result = new Object[k];
		System.arraycopy(medias, 0, result, 0, k);
		return result;
	}		
	
	class ListSelectionPanel extends JPanel implements ActionListener, ListSelectionListener {
		ListSelectionPanel() {
			setLayout(new GranulatedLayout(5, 8, Resources.CTRL_VERT_SIZE,                    
										   Resources.CTRL_VERT_GAP, Resources.CTRL_HORIS_INSET,
										   Resources.CTRL_HORIZ_GAP));
			add(new JScrollPane(resultList = new JList(new DefaultListModel())), "0,1,2,6");
			resultList.addListSelectionListener(this);
			add(btnCopy = new JButton(Resources.CMD_COPY), "2,2");
			btnCopy.addActionListener(this);
			add(btnCopyAll = new JButton(Resources.CMD_COPY_ALL), "2,3");
			btnCopyAll.addActionListener(this);
			add(btnDelete = new JButton(Resources.CMD_DELETE), "2,4");
			btnDelete.addActionListener(this);
			add(btnDeleteAll = new JButton(Resources.CMD_DELETE_ALL), "2,5");
			btnDeleteAll.addActionListener(this);			
		}
		
		public void actionPerformed(ActionEvent e) {
			String cmd = e.getActionCommand();
			DefaultListModel model = (DefaultListModel)resultList.getModel();
			if(Resources.CMD_COPY.equals(cmd)) {
				addElements(getSelectedItems(), model);
				clearSelection();
			} else if(Resources.CMD_COPY_ALL.equals(cmd)) {
				addElements(getAllItems(), model);
			} else if(Resources.CMD_DELETE.equals(cmd)) {				
				removeElements(resultList.getSelectedValues(), model);
			} else if(Resources.CMD_DELETE_ALL.equals(cmd)) {
				model.removeAllElements();
			}
		}
		
		public void valueChanged(ListSelectionEvent e) {
			updateUiState();
		}
		
		Object[] getData() {
			DefaultListModel model = (DefaultListModel)resultList.getModel();
			return model.toArray();
		}
		
		void updateUiState() {
			Object[] si = getSelectedItems();
			btnCopy.setEnabled(si != null && si.length > 0);
			btnCopyAll.setEnabled(getAllItems() != null);
			si = resultList.getSelectedValues();
			btnDelete.setEnabled(si != null && si.length > 0); 
			btnDeleteAll.setEnabled(((DefaultListModel)resultList.getModel()).size() > 0);
		}
		
		void addElements(Object []elements, DefaultListModel model) {
			for (int l=0; elements != null && l < elements.length; l++)
				if (!model.contains(elements[l]))
					model.addElement(elements[l]);
		}

		void removeElements(Object []elements, DefaultListModel model) {
			for (int l=0; elements != null && l < elements.length; l++)
				model.removeElement(elements[l]);
		}
		
		Object[] getSelectedItems() {
			return null;
		}
		
		void clearSelection() {
		}

		Object[] getAllItems() {
			return null;
		}
		
		JList resultList;
		JButton btnCopy, btnCopyAll, btnDelete, btnDeleteAll;
	}
	
	class GenreSelectionPanel extends ListSelectionPanel {
		GenreSelectionPanel() {
			String[] genreSorted = (String[])MP3.GENRES.clone();
			Arrays.sort(genreSorted);
			add(new JScrollPane(l_genres = new JList(genreSorted)), "3,1,2,6");
			l_genres.addListSelectionListener(this);
			updateUiState();
		}		 

		Object[] getSelectedItems() {
			return l_genres.getSelectedValues();
		}

		void clearSelection() {
			l_genres.removeSelectionInterval(0,MP3.GENRES.length-1);
		}
		
		Object[] getAllItems() {
			return MP3.GENRES;
			// Object allEls[] = new Object[l_genres.getModel().getSize()]
			// for (int i=0; i<allEls.length; i++)
			// allEls[i] = l_genres.getModel().getElementAt(i);
			// return allEls;
			// return l_genres.getModel().toArray();
		}
		JList l_genres;
	}

	class ArtistSelectionPanel extends ListSelectionPanel {
		ArtistSelectionPanel() {
			add(tf_artist = new JTextField(), "3,1,2");
			tf_artist.getDocument().addDocumentListener( new DocumentListener() {
				public void changedUpdate(DocumentEvent e) {
				}
				public void removeUpdate(DocumentEvent e) {
					updateUiState();
				}
				public void insertUpdate(DocumentEvent e) {
					updateUiState();
				}
				});
			updateUiState();
		}		 

		Object[] getSelectedItems() {
			String result = tf_artist.getText().trim();
			if(result.length() == 0)
				return null;
			selectedItems[0] = result;
			return selectedItems;
		}
		
		void clearSelection() {
			tf_artist.setText("");
		}

		Object[] getAllItems() {
			return null;
		}

		JTextField tf_artist;
		Object[] selectedItems = new Object[1];
	}

	class YearSelectionPanel extends ListSelectionPanel {
		YearSelectionPanel() {
			add(new JScrollPane(l_years = new JList(new DefaultListModel())), "3,1,1,6");
			int currYear = Calendar.getInstance().get(Calendar.YEAR);
			DefaultListModel model = (DefaultListModel)l_years.getModel();
			for (int y=START_YEAR; y<=currYear; y++)
				//model.addElement(String.valueOf(y));
			model.addElement(new Integer(y));
			l_years.addListSelectionListener(this);
			updateUiState();				
		}		 

		Object[] getSelectedItems() {
			return l_years.getSelectedValues();
		}

		void clearSelection() {
			l_years.removeSelectionInterval(0,((DefaultListModel)l_years.getModel()).size()-1);
		}
		
		Object[] getAllItems() {
			 return ((DefaultListModel)l_years.getModel()).toArray();
		}
		JList l_years;
	}

	class AdditionsSelectionPanel extends ListSelectionPanel {
		AdditionsSelectionPanel() {
			add(tf_addition = new JTextField(), "3,1,2");
			add(new JScrollPane(l_types = new JList(PLAY_ATTRIBUTES)), "3,2,2,5");
			tf_addition.getDocument().addDocumentListener( new DocumentListener() {
				public void changedUpdate(DocumentEvent e) {
				}
				public void removeUpdate(DocumentEvent e) {
					updateUiState();
				}
				public void insertUpdate(DocumentEvent e) {
					updateUiState();
				}
				});
			updateUiState();
		}		 

		Object[] getSelectedItems() {
			String result = tf_addition.getText().trim();
			if(result.length() == 0)
				return null;
			Object[] types = l_types.getSelectedValues();
			if (types != null && types.length > 0) {
				result += "{"+types[0];
				for (int t=1; t<types.length; t++)
					result += ","+types[t];
				result += "}";
			}
			selectedItems[0] = result;
			return selectedItems;			
		}

		void clearSelection() {
			l_types.removeSelectionInterval(0,PLAY_ATTRIBUTES.length-1);
			tf_addition.setText("");
		}
		
		Object[] getAllItems() {
			 return null;
		}
		JList l_types;
		JTextField tf_addition;
		Object[] selectedItems = new Object[1];
	}
		
	protected Controller controller;
	protected Window window;
	protected ListSelectionPanel gsp, asp, ysp, dsp;
	protected JCheckBox cb_intro, cb_exclude;
	protected JRadioButton rb_rand, rb_shuffl;
	protected ContentMatcher matcher;
	protected JComboBox cb_schema;
	//Object monitor = new Object();
}
