/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import photoorganizer.Controller;
import photoorganizer.Resources;
import photoorganizer.directory.JDirectoryChooser;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.FileNameFormat;
import rogatkin.GranulatedLayout;
import rogatkin.Helpable;
import rogatkin.Persistable;
import rogatkin.Serializer;

public class MiscellaneousOptionsTab
extends JPanel
implements ActionListener,
Persistable,
Helpable {
    public static final String SECNAME = "MiscellaneousOptions";
    public static final String DATEFORMAT = "DateFormat";
    public static final String TIMEFORMAT = "TimeFormat";
    public static final String TOOLBAR = "ToolBar";
    public static final String STATUSBAR = "StatusBar";
    public static final String MENUBAR = "MenuBar";
    public static final String TABPOS = "TabPosition";
    public static final String FC_FOLDER = "FlashCardDirectory";
    public static final String SHOWWARNDLG = "ShowWarnDlg";
    public static final String COUNTRY = "Country";
    public static final String LANGUAGE = "Language";
    public static final String SPLITVERT = "SplitVertically";
    public static final String ENCODING = "Encoding";
    public static final String LAF = "L&F";
    static final Integer[] TABPOSTABLE = new Integer[]{new Integer(1), new Integer(3), new Integer(2), new Integer(4)};
    static final String formathelp = "<html>\n<pre>\n Symbol   Meaning                 Presentation        Example\n ------   -------                 ------------        -------\n G        era designator          (Text)              AD\n y        year                    (Number)            1996\n M        month in year           (Text &amp; Number)     July &amp; 07\n d        day in month            (Number)            10\n h        hour in am/pm (1~12)    (Number)            12\n H        hour in day (0~23)      (Number)            0\n m        minute in hour          (Number)            30\n s        second in minute        (Number)            55\n S        millisecond             (Number)            978\n E        day in week             (Text)              Tuesday\n D        day in year             (Number)            189\n F        day of week in month    (Number)            2 (2nd Wed in July)\n w        week in year            (Number)            27\n W        week in month           (Number)            2\n a        am/pm marker            (Text)              PM\n k        hour in day (1~24)      (Number)            24\n K        hour in am/pm (0~11)    (Number)            0\n z        time zone               (Text)              Pacific Standard Time  \n '        escape for text         (Delimiter)\n ''       single quote            (Literal)           '\n </pre>";
    Controller controller;
    JTextField tf_date;
    JTextField tf_time;
    JTextField tf_fc_folder;
    JTextField tf_encoding;
    JTextField tf_laf;
    JCheckBox cb_menu;
    JCheckBox cb_status;
    JCheckBox cb_tool;
    JCheckBox cb_warn;
    JComboBox mb_positions;
    JComboBox cb_country;
    JComboBox cb_lang;
    JRadioButton rb_split_horz;
    JRadioButton rb_split_vert;

    public MiscellaneousOptionsTab(Controller controller) {
        this.controller = controller;
        this.setLayout((LayoutManager)new GranulatedLayout(8, 7, 20, 4, 8, 8));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Show"));
        jPanel.setOpaque(false);
        this.add((Component)jPanel, "0,0,8,4,16,8");
        this.cb_menu = new JCheckBox("Menu");
        this.add((Component)this.cb_menu, "1,1");
        this.cb_tool = new JCheckBox(TOOLBAR);
        this.add((Component)this.cb_tool, "2,1");
        this.cb_warn = new JCheckBox("Confirmation dialogs");
        this.add((Component)this.cb_warn, "2,2,2");
        this.cb_status = new JCheckBox(STATUSBAR);
        this.add((Component)this.cb_status, "1,2");
        this.add((Component)new JLabel("Tab position", 2), "6,1,2,1,34");
        this.mb_positions = new JComboBox<String>(Resources.POSITIONS);
        this.add(this.mb_positions, "6,2,2,1,34");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rb_split_vert = new JRadioButton("Split vertically");
        this.add((Component)this.rb_split_vert, "4,1,2");
        buttonGroup.add(this.rb_split_vert);
        this.rb_split_horz = new JRadioButton("Split horizontally");
        this.add((Component)this.rb_split_horz, "4,2,2");
        buttonGroup.add(this.rb_split_horz);
        this.add((Component)new JLabel("Locales", 4), "0,4");
        this.cb_country = new JComboBox<String>(Resources.COUNTRIES);
        this.add(this.cb_country, "1,4");
        this.cb_lang = new JComboBox<String>(Resources.LANGUAGES);
        this.add(this.cb_lang, "2,4");
        this.add((Component)new JLabel("CF directory", 4), "0,6,2");
        this.tf_fc_folder = new JTextField();
        this.add((Component)this.tf_fc_folder, "2,6,4");
        JButton jButton = new JButton("Browse");
        this.add((Component)jButton, "6,6,2");
        jButton.addActionListener(this);
        this.add((Component)new JLabel("Page/comment encoding", 4), "4,4,2");
        this.tf_encoding = new JTextField();
        this.add((Component)this.tf_encoding, "6,4,2");
        this.add((Component)new JLabel("Date format", 4), "0,5");
        this.tf_date = new JTextField();
        this.add((Component)this.tf_date, "1,5");
        this.add((Component)new JLabel("Time format", 4), "2,5");
        this.tf_time = new JTextField();
        this.add((Component)this.tf_time, "3,5");
        this.add((Component)new JLabel(LAF, 4), "4,5");
        this.tf_laf = new JTextField();
        this.add((Component)this.tf_laf, "5,5,3");
    }

    public String getHelp() {
        return formathelp;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JDirectoryChooser jDirectoryChooser;
        if (actionEvent.getActionCommand() == "Browse" && (jDirectoryChooser = new JDirectoryChooser(new JFrame(), this.tf_fc_folder.getText(), null)).getDirectory() != null) {
            this.tf_fc_folder.setText(jDirectoryChooser.getDirectory());
        }
    }

    public void load() {
        Serializer serializer = this.controller.getSerializer();
        this.tf_date.setText(Serializer.arrayToString((Object)serializer.getProperty((Object)SECNAME, (Object)DATEFORMAT)));
        this.tf_time.setText(Serializer.arrayToString((Object)serializer.getProperty((Object)SECNAME, (Object)TIMEFORMAT)));
        this.tf_fc_folder.setText(Serializer.arrayToString((Object)serializer.getProperty((Object)SECNAME, (Object)FC_FOLDER)));
        this.cb_menu.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)MENUBAR), (int)1) == 1);
        this.cb_status.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)STATUSBAR), (int)1) == 1);
        this.cb_tool.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)TOOLBAR), (int)0) == 1);
        this.cb_warn.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)SHOWWARNDLG), (int)0) == 1);
        if (Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)SPLITVERT), (int)1) == 1) {
            this.rb_split_vert.setSelected(true);
        } else {
            this.rb_split_horz.setSelected(true);
        }
        switch (Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)TABPOS), (int)3)) {
            case 1: {
                this.mb_positions.setSelectedIndex(0);
                break;
            }
            case 3: {
                this.mb_positions.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.mb_positions.setSelectedIndex(2);
                break;
            }
            case 4: {
                this.mb_positions.setSelectedIndex(3);
            }
        }
        String string = (String)serializer.getProperty((Object)SECNAME, (Object)COUNTRY);
        if (string == null) {
            string = Locale.getDefault().getCountry();
        }
        this.cb_country.setSelectedItem(string);
        string = (String)serializer.getProperty((Object)SECNAME, (Object)LANGUAGE);
        if (string == null) {
            string = Locale.getDefault().getLanguage();
        }
        this.cb_lang.setSelectedItem(string);
        string = (String)serializer.getProperty((Object)SECNAME, (Object)ENCODING);
        if (string != null) {
            this.tf_encoding.setText(string);
        }
        if ((string = (String)serializer.getProperty((Object)SECNAME, (Object)LAF)) != null) {
            this.tf_laf.setText(string);
        }
    }

    public void save() {
        Serializer serializer = this.controller.getSerializer();
        FileNameFormat.datemask = this.tf_date.getText().trim();
        serializer.setProperty((Object)SECNAME, (Object)DATEFORMAT, (Object)FileNameFormat.datemask);
        FileNameFormat.timemask = this.tf_time.getText().trim();
        serializer.setProperty((Object)SECNAME, (Object)TIMEFORMAT, (Object)FileNameFormat.timemask);
        serializer.setProperty((Object)SECNAME, (Object)FC_FOLDER, (Object)this.tf_fc_folder.getText());
        serializer.setProperty((Object)SECNAME, (Object)LAF, (Object)this.tf_laf.getText());
        serializer.setProperty((Object)SECNAME, (Object)ENCODING, (Object)this.tf_encoding.getText());
        serializer.setProperty((Object)SECNAME, (Object)MENUBAR, (Object)(this.cb_menu.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)STATUSBAR, (Object)(this.cb_status.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)TOOLBAR, (Object)(this.cb_tool.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)SHOWWARNDLG, (Object)(this.cb_warn.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)SPLITVERT, (Object)(this.rb_split_vert.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)TABPOS, (Object)TABPOSTABLE[this.mb_positions.getSelectedIndex()]);
        serializer.setProperty((Object)SECNAME, (Object)COUNTRY, this.cb_country.getSelectedItem());
        serializer.setProperty((Object)SECNAME, (Object)LANGUAGE, this.cb_lang.getSelectedItem());
        BasicJpeg.setEncoding(MiscellaneousOptionsTab.getEncoding(this.controller));
    }

    public static String getEncoding(Controller controller) {
        String string = (String)controller.getSerializer().getProperty((Object)SECNAME, (Object)ENCODING);
        return string == null || string.trim().length() == 0 ? null : string;
    }
}

