/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.Bytes;
import de.vdheide.mp3.ID3v2DecompressionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ID3v2Frame
implements Serializable {
    public static final byte NO_COMPRESSION = 0;
    public static final byte IS_COMPRESSED = 1;
    public static final byte DO_COMPRESS = 2;
    public static final String ID_INVALID = null;
    private String id = null;
    private boolean tag_alter_preservation = false;
    private boolean file_alter_preservation = false;
    private boolean read_only = false;
    private byte encryption_id = 0;
    private int decompressed_length = 0;
    private boolean compression = false;
    private byte group = 0;
    private boolean uses_unsynch = false;
    private byte[] content;
    private byte[] compressed_content;
    private static final byte FLAG_TAG_ALTER_PRESERVATION = -128;
    private static final byte FLAG_FILE_ALTER_PRESERVATION = 64;
    private static final byte FLAG_READ_ONLY = 32;
    private static final byte FLAG_COMPRESSION = -128;
    private static final byte FLAG_ENCRYPTION = 64;
    private static final byte FLAG_GROUPING = 32;

    public ID3v2Frame(String string, byte[] byArray, boolean bl, boolean bl2, boolean bl3, byte by, byte by2, byte by3) throws ID3v2DecompressionException {
        this.id = string;
        this.content = byArray;
        this.tag_alter_preservation = bl;
        this.file_alter_preservation = bl2;
        this.read_only = bl3;
        this.compression = by == 2 || by == 1;
        this.encryption_id = by2;
        this.group = by3;
        if (by == 2) {
            this.decompressed_length = this.content.length;
            this.compressContent();
        } else if (by == 1) {
            this.compressed_content = byArray;
            this.decompressContent();
            this.decompressed_length = this.content.length;
        } else {
            this.decompressed_length = this.content.length;
            this.compressed_content = this.content;
        }
    }

    public ID3v2Frame(InputStream inputStream) throws IOException, ID3v2DecompressionException {
        byte[] byArray = new byte[10];
        inputStream.read(byArray);
        if (byArray[0] == 0) {
            this.id = ID_INVALID;
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(4);
        int n = 0;
        while (n < 4) {
            stringBuffer.append((char)(byArray[n] & 0xFF));
            ++n;
        }
        this.id = stringBuffer.toString();
        int n2 = (int)new Bytes(byArray, 4, 4).getValue();
        if ((byArray[8] & 0xFF & 0xFFFFFF80) > 0) {
            this.tag_alter_preservation = true;
        }
        if ((byArray[8] & 0xFF & 0x40) > 0) {
            this.file_alter_preservation = true;
        }
        if ((byArray[8] & 0xFF & 0x20) > 0) {
            this.read_only = true;
        }
        if ((byArray[9] & 0xFF & 0xFFFFFF80) > 0) {
            this.compression = true;
        }
        boolean bl = false;
        if ((byArray[9] & 0xFF & 0x40) > 0) {
            bl = true;
        }
        boolean bl2 = false;
        if ((byArray[9] & 0xFF & 0x20) > 0) {
            bl2 = true;
        }
        if (this.compression) {
            byte[] byArray2 = new byte[4];
            inputStream.read(byArray2);
            this.decompressed_length = (int)new Bytes(byArray2).getValue();
            n2 -= 4;
        }
        if (bl) {
            this.encryption_id = (byte)inputStream.read();
            --n2;
        }
        if (bl2) {
            this.group = (byte)inputStream.read();
            --n2;
        } else {
            this.group = 0;
        }
        this.content = new byte[n2];
        inputStream.read(this.content);
        if (this.compression) {
            this.compressed_content = new byte[this.content.length];
            System.arraycopy(this.content, 0, this.compressed_content, 0, this.content.length);
            this.decompressContent();
        }
    }

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    public boolean getTagAlterPreservation() {
        return this.tag_alter_preservation;
    }

    public void setTagAlterPreservation(boolean bl) {
        this.tag_alter_preservation = bl;
    }

    public boolean getFileAlterPreservation() {
        return this.file_alter_preservation;
    }

    public void setFileAlterPreservation(boolean bl) {
        this.file_alter_preservation = bl;
    }

    public boolean getReadOnly() {
        return this.read_only;
    }

    public void setReadOnly(boolean bl) {
        this.read_only = bl;
    }

    public boolean getCompression() {
        return this.compression;
    }

    public void setCompression(boolean bl) {
        this.compression = bl;
    }

    public byte getEncryptionID() {
        return this.encryption_id;
    }

    public void setEncryption(byte by) {
        this.encryption_id = by;
    }

    public byte getGroup() {
        return this.group;
    }

    public void setGroup(byte by) {
        this.group = by;
    }

    public int getLength() {
        int n = 10;
        if (this.compression) {
            n += 4;
        }
        if (this.encryption_id != 0) {
            ++n;
        }
        if (this.group != 0) {
            ++n;
        }
        n = this.compression ? (n += this.compressed_content.length) : (n += this.content.length);
        return n;
    }

    public byte[] getContent() {
        return this.content;
    }

    public byte[] getBytes() {
        int n = this.getLength();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < 4) {
            byArray[n2] = this.id.length() < n2 - 1 ? (byte)0 : (byte)this.id.charAt(n2);
            ++n2;
        }
        byte[] byArray2 = new Bytes(n - 10, 4).getBytes();
        System.arraycopy(byArray2, 0, byArray, 4, 4);
        int n3 = 0;
        if (this.tag_alter_preservation) {
            n3 = (byte)(n3 | 0xFFFFFF80);
        }
        if (this.file_alter_preservation) {
            n3 = (byte)(n3 + (byte)(n3 | 0x40));
        }
        if (this.read_only) {
            n3 = (byte)(n3 + (byte)(n3 | 0x20));
        }
        byArray[8] = n3;
        int n4 = 0;
        if (this.compression) {
            n4 = (byte)(n4 + (byte)(n4 | 0xFFFFFF80));
        }
        if (this.encryption_id != 0) {
            n4 = (byte)(n4 + (byte)(n4 | 0x40));
        }
        if (this.group > 0) {
            n4 = (byte)(n4 + (byte)(n4 | 0x20));
        }
        byArray[9] = n4;
        int n5 = 10;
        if (this.compression) {
            byte[] byArray3 = new Bytes(n, 4).getBytes();
            System.arraycopy(byArray3, 0, byArray, n5, 4);
            n5 = (short)(n5 + 4);
        }
        if (this.encryption_id != 0) {
            byArray[n5] = this.encryption_id;
            n5 = (short)(n5 + 1);
        }
        if (this.group > 0) {
            byArray[n5] = this.group;
            n5 = (short)(n5 + 1);
        }
        if (this.compression) {
            this.compressContent();
            System.arraycopy(this.compressed_content, 0, byArray, n5, this.compressed_content.length);
        } else {
            System.arraycopy(this.content, 0, byArray, n5, this.content.length);
        }
        return byArray;
    }

    private void compressContent() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(this.content, 0, this.content.length);
            gZIPOutputStream.close();
            this.compressed_content = byteArrayOutputStream.toByteArray();
            if (this.content.length <= this.compressed_content.length) {
                this.compression = false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void decompressContent() throws ID3v2DecompressionException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.compressed_content);
        try {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            while ((n = gZIPInputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            this.content = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ID3v2DecompressionException();
        }
    }
}

