/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.Bytes;
import java.io.IOException;
import java.io.InputStream;

public class ID3v2ExtendedHeader {
    private int padding_size = 0;
    private boolean crc_present = false;
    private int crc = 0;
    private static final byte FLAG_CRC_PRESENT = -128;

    public ID3v2ExtendedHeader() {
        this(false, 0, 0);
    }

    public ID3v2ExtendedHeader(boolean bl, int n, int n2) {
        this.crc_present = bl;
        this.crc = this.crc_present ? n : 0;
        this.padding_size = n2;
    }

    public ID3v2ExtendedHeader(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[10];
        inputStream.read(byArray);
        int n = (int)new Bytes(byArray, 0, 4).getValue();
        if ((byArray[4] & 0xFF & 0xFFFFFF80) > 0) {
            this.crc_present = true;
        }
        this.padding_size = (int)new Bytes(byArray, 6, 4).getValue();
        if (this.crc_present) {
            byte[] byArray2 = new byte[4];
            inputStream.read(byArray2);
            this.crc = (int)new Bytes(byArray2).getValue();
        }
    }

    public int getSize() {
        return this.crc_present ? 10 : 6;
    }

    public int getPaddingSize() {
        return this.padding_size;
    }

    public void setPaddingSize(int n) {
        this.padding_size = n;
    }

    public boolean hasCRC() {
        return this.crc_present;
    }

    public void setHasCRC(boolean bl) {
        bl = false;
        if (false) {
            this.crc = 0;
        }
        this.crc_present = bl;
    }

    public long getCRC() {
        return this.crc;
    }

    public void setCRC(int n) {
        this.crc = n;
        this.crc_present = true;
    }

    public byte[] getBytes() {
        byte[] byArray;
        if (this.crc_present) {
            byArray = new byte[14];
            byArray[0] = 0;
            byArray[1] = 0;
            byArray[2] = 0;
            byArray[3] = 10;
            byArray[4] = -128;
            byArray[5] = 0;
        } else {
            byArray = new byte[10];
            byArray[0] = 0;
            byArray[1] = 0;
            byArray[2] = 0;
            byArray[3] = 10;
            byArray[4] = 0;
            byArray[5] = 0;
        }
        byte[] byArray2 = new Bytes(this.padding_size, 4).getBytes();
        System.arraycopy(byArray2, 0, byArray, 6, 4);
        if (this.crc_present) {
            byte[] byArray3 = new Bytes(this.crc, 4).getBytes();
            System.arraycopy(byArray3, 0, byArray, 10, 4);
        }
        return byArray;
    }
}

