          TITLE   REAL*8 FUNCTION DISTMNDL(REAL,IMAG,N)
;
;P. A. Seeger, Los Alamos National Laboratory, November 15, 1991
;    (derived from MANDEL, version of Nov. 14, 1991)
;         Modified for Microsoft Fortran, December 15, 1992
;         Inserted into template from PowerStation Fortran, May 1, 1996
;
;Iterate  z <== z*z + c, starting from z = 0 + 0*i, where c = REAL + IMAG*i,
;   N times, keeping the derivative z' (= 2zz'+1) as well.  Return the
;   distance from the Mandelbrot set on the top of the coprocessor stack:
;         DISTMNDL = ln(|z*z|)*|z|/|z'|
;
;         REAL = Re(c), REAL*8
;         IMAG = Im(c), REAL*8
;         N = number of iterations, INTEGER*2
;
;         new Re(z)  := Re(z)*Re(z) - Im(z)*Im(z) + REAL
;         new Im(z)  := 2*Re(z)*Im(z) + IMAG
;         new Re(z') := 2*(Re(z)*Re(z') - Im(z)*Im(z')) + 1
;         new Im(z') := 2*(Re(z)*Im(z') + Im(z)*Re(z'))
;
.386P
.model FLAT
EXTRN	__FFljj:NEAR
_DATA	SEGMENT
_DISTMNDL  DB 'DISTMNDL.ASM', 00H
_DATA	ENDS
PUBLIC _DISTMNDL@12
EXTRN __fltused:NEAR
;
_TEXT	SEGMENT
_DISTMNDL$ = -8
_A$ = 8
_B$ = 12
_N$ = 16
_DISTMNDL@12 PROC NEAR
;
 	mov	ecx, DWORD PTR _A$[esp-4]  ;address of a = Re(c)
	sub	esp, 8
	push	ebx
          FLD     QWORD PTR [ecx]  ;send a to processor stack
	push	esi
	push	ebp
	mov	edx, DWORD PTR _B$[esp+16]  ;address of b = Im(c)
	mov	ebp, DWORD PTR _N$[esp+16]  ;address of N
          FLD     QWORD PTR [edx]  ;send b to processor stack
          FLD     ST(1)            ;initial Re(z) = x := Re(c) = a
          FLD     ST(1)            ;initial Im(z) = y := Im(c) = b
          FLD1                     ;initial Re(z') = x' := 1
          FLDZ                     ;initial Im(z') = y' := 0
;
          MOV     ecx, [ebp]       ;put N in loop count register
                                   ;Stack:  y'     x'    y    x  b  a  -  -
AGAIN:    FLD     ST(0)            ;        y'     y'    x'   y  x  b  a  -
          FMUL    ST(0),ST(3)      ;        yy'    y'    x'   y  x  b  a  -
          FLD     ST(2)            ;        x'     yy'   y'   x' y  x  b  a
          FMUL    ST(0),ST(5)      ;        xx'    yy'   y'   x' y  x  b  a
          FSUBRP  ST(1),ST(0)      ;       xx'-yy' y'    x'   y  x  b  a  -
          FADD    ST(0),ST(0)      ;      2(xx'-yy') y'  x'   y  x  b  a  -
          FLD1                     ;        1  2(xx'-yy') y'  x' y  x  b  a
          FADDP   ST(1),ST(0)      ;        X'     y'    x'   y  x  b  a  -
;
          FXCH    ST(2)            ;        x'     y'    X'   y  x  b  a  -
          FMUL    ST(0),ST(3)      ;        yx'    y'    X'   y  x  b  a  -
          FXCH    ST(1)            ;        y'    yx'    X'   y  x  b  a  -
          FMUL    ST(0),ST(4)      ;        xy'   yx'    X'   y  x  b  a  -
          FADDP   ST(1),ST(0)      ;      xy'+yx'  X'    y    x  b  a  -  -
          FADD    ST(0),ST(0)      ;         Y'    X'    y    x  b  a  -  - 
;
          FLD     ST(3)            ;        x      X'    X'   y  x  b  a  -
          FMUL    ST(0),ST(0)      ;        x2     Y'    X'   y  x  b  a  -
          FLD     ST(3)            ;        y      x2    Y'   X' y  x  b  a
          FMUL    ST(0),ST(0)      ;        y2     x2    Y'   X' y  x  b  a
          FSUBP   ST(1),ST(0)      ;       x2-y2   Y'    X'   y  x  b  a  -
          FADD    ST(0),ST(6)      ;        X      Y'    X'   y  x  b  a  -
;
          FXCH    ST(4)            ;        x      Y'    X'   y  X  b  a  -
          FMUL    ST(0),ST(3)      ;        x*y    Y'    X'   y  X  b  a  -
          FADD    ST(0),ST(0)      ;       2*x*y   Y'    X'   y  X  b  a  -
          FADD    ST(0),ST(5)      ;        Y      Y'    X'   y  X  b  a  -
          FSTP    ST(3)            ;        Y'     X'    Y    X  b  a  -  -
;
          LOOP    AGAIN            ;repeat  N  times
;
          FMUL    ST(0),ST(0)      ;        y'2      x'     y    x  b  a  -  -
          FXCH    ST(1)            ;        x'       y'2    y    x  b  a  -  -
          FMUL    ST(0),ST(0)      ;        x'2      y'2    y    x  b  a  -  -
          FADDP   ST(1),ST(0)      ;      |z'*z'|    y      x    b  a  -  -  -
;
          FXCH    ST(1)            ;        y     |z'*z'|   x    b  a  -  -  -
          FMUL    ST(0),ST(0)      ;        y2    |z'*z'|   x    b  a  -  -  -
          FXCH    ST(2)            ;        x     |z'*z'|   y2   b  a  -  -  -
          FMUL    ST(0),ST(0)      ;        x2    |z'*z'|   y2   b  a  -  -  -
          FADDP   ST(2),ST(0)      ;     |z'*z'|   |z*z|    b    a  -  -  -  -
;
          FDIVR   ST(0),ST(1)      ;   |z*z|/|z'*z'| |z*z|   b   a  -  -  -  -
          FSQRT                    ;       |z|/|z'|  |z*z|   b   a  -  -  -  -
          FXCH    ST(1)            ;       |z*z|    z|/|z'|  b   a  -  -  -  -
;
          FLDLN2                   ;      ln(2)   |z*z| |z|/|z'| b  a  -  -  -
          FXCH    ST(1)            ;      |z*z|   ln(2) |z|/|z'| b  a  -  -  -
          FYL2X                    ;     ln|z*z|  |z|/|z'|   b   a  -  -  -  -
          FMULP   ST(1),ST(0)      ;Distance = (2*ln|z|)*(|z|/|z'|)
;
	fst	QWORD PTR _DISTMNDL$[esp+20]
          FFREE   ST(2)            ;eliminate  a  from stack
          FFREE   ST(1)            ;eliminate  b  from stack
	pop	ebp
	pop	esi
	pop	ebx
	add	esp, 8
	ret	12
_DISTMNDL@12 ENDP
_TEXT	ENDS
END
