/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.util.Enumeration;
import tools.Tree;

public class TreeIterator {
    Tree t;
    Tree end;
    int n;
    int baseLevel;

    public TreeIterator(Tree tree) {
        this.t = tree;
        this.end = TreeIterator.getNextSibling(tree);
        if (this.t != null) {
            this.baseLevel = this.t.getLevel();
        }
    }

    public Tree getNext() {
        if (this.t == null) {
            return null;
        }
        Tree tree = this.t = this.t.expanded && this.t.nodes != null ? (Tree)this.t.nodes.elementAt(0) : TreeIterator.getNextSibling(this.t);
        if (this.t == null) {
            return null;
        }
        if (this.t == this.end) {
            return null;
        }
        Tree tree2 = this.t;
        if (tree2.name.startsWith("Problems")) {
            return this.getNext();
        }
        ++this.n;
        return this.t;
    }

    static boolean filter(Tree tree) {
        return tree.name.startsWith("Problems");
    }

    static Tree getNextSibling(Tree tree) {
        if (tree == null || tree.parent == null) {
            return null;
        }
        int n = tree.parent.nodes.indexOf(tree);
        if (n + 1 < tree.parent.nodes.size()) {
            return (Tree)tree.parent.nodes.elementAt(n + 1);
        }
        return TreeIterator.getNextSibling(tree.parent);
    }

    public static boolean isLastSibling(Tree tree) {
        if (tree == null || tree.parent == null || tree.parent.nodes == null) {
            return true;
        }
        int n = tree.parent.nodes.indexOf(tree) + 1;
        while (n < tree.parent.nodes.size()) {
            Tree tree2 = (Tree)tree.parent.nodes.elementAt(n);
            if (!tree2.name.startsWith("Problems")) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean hasChildren(Tree tree) {
        if (tree == null || tree.nodes == null) {
            return false;
        }
        Enumeration enumeration = tree.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Tree tree2 = (Tree)enumeration.nextElement();
            if (tree2.name.startsWith("Problems")) continue;
            return true;
        }
        return false;
    }

    public int getLevel() {
        if (this.t == null) {
            return 0;
        }
        return this.t.getLevel() - this.baseLevel;
    }
}

