/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Value;

import X10Gimli.Debug;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueCommand;
import X10Gimli.Value.ValueDay;
import X10Gimli.Value.ValueMonth;
import X10Gimli.Value.ValueNothing;
import X10Gimli.Value.ValueType;
import X10Gimli.Value.ValueX10;

public final class ValueNumber
extends Value {
    private int iNumber;

    public ValueNumber() {
    }

    public ValueNumber(String string) {
        this.setNumber(string);
    }

    public ValueNumber(int number) {
        this.setNumber(number);
    }

    public void setNumber(int number) {
        this.iNumber = number;
        this.makeString();
    }

    public void setNumber(String number) {
        this.iNumber = Integer.parseInt(number);
        this.makeString();
    }

    public int getNumber() {
        return this.iNumber;
    }

    public int getDeviceCode() {
        return this.iNumber;
    }

    public Value applyArithmetic(String op, ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueNumber || cmp instanceof ValueX10 || cmp instanceof ValueDay || cmp instanceof ValueMonth || cmp instanceof ValueCommand) {
            if (op == "+") {
                return new ValueNumber(this.getNumber() + cmp.getNumber());
            }
            if (op == "-") {
                return new ValueNumber(this.getNumber() - cmp.getNumber());
            }
            if (op == "*") {
                return new ValueNumber(this.getNumber() * cmp.getNumber());
            }
            if (op == "/") {
                return new ValueNumber(this.getNumber() / cmp.getNumber());
            }
        }
        Debug.error(102, "(Runtime) Incompatible arithmetic operation for NUMBER type.");
        return ValueNothing.value;
    }

    public int compareTo(ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueNumber || cmp instanceof ValueX10 || cmp instanceof ValueMonth || cmp instanceof ValueDay || cmp instanceof ValueCommand) {
            if (this.getNumber() > cmp.getNumber()) {
                return 1;
            }
            if (this.getNumber() < cmp.getNumber()) {
                return -1;
            }
            if (this.getNumber() == cmp.getNumber()) {
                return 0;
            }
            return 100;
        }
        Debug.error(101, "(WARNING) Incompatible comparison to NUMBER type : ".concat(String.valueOf(String.valueOf(cmp.string))));
        return 100;
    }

    public String toString() {
        this.sbuf.setLength(0);
        return this.sbuf.append(this.iNumber).toString();
    }

    public String toX10GIMLI() {
        return this.toString();
    }
}

