/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.System;

import X10Gimli.Command.BeginCommand;
import X10Gimli.Command.Command;
import X10Gimli.Command.MotionCommand;
import X10Gimli.Command.TriggerCommand;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueIdent;
import java.util.ArrayList;

public class Function {
    private String sName;
    private ArrayList vIdents = new ArrayList();
    private Command cCommand;

    public void setName(String name) {
        this.sName = name.toUpperCase().intern();
    }

    public void setIdents(ArrayList idents) {
        if (idents != null) {
            // empty if block
        }
        this.vIdents = idents;
    }

    public void setCommand(Command command) {
        this.cCommand = command;
    }

    public String getName() {
        return this.sName;
    }

    public Command getCommand() {
        return this.cCommand;
    }

    public ArrayList getIdents() {
        return this.vIdents;
    }

    public Value getIdent(int num) {
        if (this.vIdents != null) {
            return (Value)this.vIdents.get(num);
        }
        return null;
    }

    public String toX10GIMLI(int depth) {
        int i;
        char[] sBytes = new char[15];
        for (i = 0; i < 15; ++i) {
            sBytes[i] = 32;
        }
        StringBuffer sBuf = new StringBuffer("");
        int indent = depth * 2;
        sBuf.append(sBytes, 0, indent);
        sBuf.append(this.sName);
        sBuf.append("(");
        for (i = 0; i < this.vIdents.size(); ++i) {
            sBuf.append(((ValueIdent)this.vIdents.get(i)).toX10GIMLI());
            if (i + 1 >= this.vIdents.size()) continue;
            sBuf.append(", ");
        }
        if (this.cCommand instanceof BeginCommand || this.cCommand instanceof MotionCommand || this.cCommand instanceof TriggerCommand) {
            sBuf.append(")\r\n");
            sBuf.append(this.cCommand.toX10GIMLI(depth + 1));
        } else {
            sBuf.append(") ");
            sBuf.append(this.cCommand.toX10GIMLI(0));
        }
        return sBuf.toString();
    }
}

