/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.System;

import X10Gimli.Debug;
import X10Gimli.Parser;
import X10Gimli.System.Environment;
import X10Gimli.System.SystemModel;
import java.io.File;
import java.util.ArrayList;

public class AllImports {
    private static ArrayList vImportTitles = new ArrayList();
    private static ArrayList vImports = new ArrayList();
    private static ArrayList vPaths = new ArrayList();

    public static void addPath(String path) {
        if (!vPaths.contains(path)) {
            vPaths.add(path);
        }
    }

    public static void addPaths(ArrayList paths) {
        for (int i = 0; i < paths.size(); ++i) {
            AllImports.addPath((String)paths.get(i));
        }
    }

    public static String resolvePath(String fname) {
        if (fname != null) {
            String path = "";
            int size = vPaths.size();
            for (int i = 0; i < size; ++i) {
                path = String.valueOf(String.valueOf((String)vPaths.get(i))).concat(String.valueOf(String.valueOf(fname)));
                if (new File(path).exists()) {
                    return path;
                }
                path = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf((String)vPaths.get(i)))).append("\\").append(fname)));
                if (!new File(path).exists()) continue;
                return path;
            }
        }
        return null;
    }

    private static int findImport(String name) {
        if (name != null) {
            int size = vImportTitles.size();
            for (int i = 0; i < size; ++i) {
                String title = (String)vImportTitles.get(i);
                if (!title.equalsIgnoreCase(name)) continue;
                return i;
            }
        }
        return -1;
    }

    public static Environment loadImport(String name) {
        String path = AllImports.resolvePath(name);
        int imp = AllImports.findImport(path);
        if (imp != -1) {
            return (Environment)vImports.get(imp);
        }
        if (path == null) {
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Unable to access \"").append(name).append("\" for import.\""))));
            return null;
        }
        Parser parser = new Parser();
        parser.setInputFile(path);
        SystemModel model = new SystemModel();
        vImportTitles.add(path.toUpperCase());
        vImports.add(model);
        parser.productionX10Gimli(model);
        Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Finished import of \"").append(name).append("\".\""))));
        return model;
    }

    public static void startupAll() {
        int size = vImports.size();
        for (int i = 0; i < size; ++i) {
            SystemModel m = (SystemModel)vImports.get(i);
            m.startInitCommands();
        }
    }

    static {
        vPaths.add("");
        vPaths.add(".");
    }
}

