/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Interface.Gateway;

import X10Gimli.Debug;
import X10Gimli.Interface.InputListener;
import X10Gimli.Interface.InputOutputGateway;
import X10Gimli.Interface.OutputListener;
import X10Gimli.System.Packet.ConnectionPacket;
import X10Gimli.System.Packet.Packet;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueIdent;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueString;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;

public class TCPGateway
extends InputOutputGateway
implements Runnable,
InputListener,
OutputListener {
    private ServerSocket sServer;
    private Socket newConnect;
    private Vector ioClients = new Vector();
    private Vector serverPackets = new Vector();
    private int inputPort;

    public void multicastConnectionServer() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    Debug.log(1, "\"Multicast connection server thread started.\"");
                    InetAddress group = InetAddress.getByName("239.249.231.206");
                    MulticastSocket dsInput = new MulticastSocket(5879);
                    dsInput.joinGroup(group);
                    while (true) {
                        DatagramPacket dpInput = new DatagramPacket(new byte[1024], 1024);
                        dsInput.receive(dpInput);
                        Packet pack = new Packet(dpInput.getData()).getPacketType();
                        if (!(pack instanceof ConnectionPacket)) continue;
                        ConnectionPacket packet = (ConnectionPacket)pack;
                        try {
                            if (packet.getCommand().getValueString().equals("TCP_CONNECT_REQUEST")) {
                                Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Received connection request from ").append(packet.getValue("ADDRESS").getValueString()).append(":").append(packet.getValue("PORT").getNumber()).append(".\""))));
                                TCPGateway.this.connect(InetAddress.getByName(packet.getValue("ADDRESS").getValueString()), packet.getValue("PORT").getNumber());
                                continue;
                            }
                            if (!packet.getCommand().getValueString().equals("TCP_IDENT_REQUEST")) continue;
                            ConnectionPacket p = new ConnectionPacket();
                            Debug.log(1, "\"Received server identification request.\"");
                            p.setCommand(new ValueIdent("TCP_SERVER"));
                            p.setSegment("ADDRESS", new ValueString(InetAddress.getLocalHost().getHostName()));
                            p.setSegment("PORT", new ValueNumber(TCPGateway.this.inputPort));
                            DatagramPacket response = new DatagramPacket(p.getBytes(), (int)p.getLength(), group, 5879);
                            dsInput.send(response);
                        }
                        catch (Exception e) {
                            Debug.printCallStack("Exception handling multicast connection server.", e);
                        }
                    }
                }
                catch (Exception e) {
                    Debug.printCallStack(e);
                    return;
                }
            }
        });
        t.start();
    }

    public void autoConnectThread() {
        Thread t1 = new Thread(new Runnable(){

            public void run() {
                try {
                    Debug.log(1, "\"Automatic client connection thread started.\"");
                    InetAddress group = InetAddress.getByName("239.249.231.206");
                    MulticastSocket dsInput = new MulticastSocket(5879);
                    dsInput.joinGroup(group);
                    while (true) {
                        DatagramPacket dpInput = new DatagramPacket(new byte[1024], 1024);
                        dsInput.receive(dpInput);
                        Packet pack = new Packet(dpInput.getData()).getPacketType();
                        if (!(pack instanceof ConnectionPacket)) continue;
                        ConnectionPacket packet = (ConnectionPacket)pack;
                        try {
                            if (!packet.getCommand().getValueString().equals("TCP_SERVER")) continue;
                            boolean dup = false;
                            int size = TCPGateway.this.serverPackets.size();
                            for (int i = 0; i < size; ++i) {
                                Packet tpack = (Packet)TCPGateway.this.serverPackets.get(i);
                                if (!tpack.getValue("ADDRESS").getValueString().equals(packet.getValue("ADDRESS").getValueString()) || tpack.getValue("PORT").getNumber() != packet.getValue("PORT").getNumber()) continue;
                                dup = true;
                            }
                            if (dup) continue;
                            TCPGateway.this.serverPackets.add(packet);
                        }
                        catch (Exception e) {
                            Debug.printCallStack("Exception in autoconnect thread.", e);
                        }
                    }
                }
                catch (Exception e) {
                    Debug.printCallStack("Exception in autoconnect thread.", e);
                    return;
                }
            }
        });
        t1.start();
        Thread t2 = new Thread(new Runnable(){

            public void run() {
                Debug.log(1, "\"Connection keep-alive thread started.\"");
                block8: while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        Debug.printCallStack("Exception in sleep of keep-alive thread.", e);
                    }
                    if (TCPGateway.this.ioClients.size() == 0) {
                        try {
                            TCPGateway.this.serverPackets = new Vector();
                            InetAddress group = InetAddress.getByName("239.249.231.206");
                            MulticastSocket dsInput = new MulticastSocket(5879);
                            dsInput.joinGroup(group);
                            ConnectionPacket cp = new ConnectionPacket();
                            cp.setCommand(new ValueIdent("TCP_IDENT_REQUEST"));
                            DatagramPacket request = new DatagramPacket(cp.getBytes(), (int)cp.getLength(), group, 5879);
                            dsInput.send(request);
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (Exception e) {
                                Debug.printCallStack("Exception in sleep of keep-alive thread.", e);
                            }
                            for (int i = 0; i < TCPGateway.this.serverPackets.size(); ++i) {
                                Packet p = (Packet)TCPGateway.this.serverPackets.get(i);
                                TCPGateway.this.connect(InetAddress.getByName(p.getValue("ADDRESS").getValueString()), p.getValue("PORT").getNumber());
                            }
                            dsInput.leaveGroup(group);
                            dsInput.close();
                        }
                        catch (Exception e) {
                            Debug.printCallStack("Exception in sleep of keep-alive thread.", e);
                        }
                    }
                    while (true) {
                        if (TCPGateway.this.ioClients.size() <= 0) continue block8;
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception e) {
                            Debug.printCallStack("Exception in sleep of keep-alive thread.", e);
                        }
                        if (TCPGateway.this.ioClients.size() != 0) continue;
                        Debug.log(1, "\"All connections have been lost.\"");
                    }
                    break;
                }
            }
        });
        t2.start();
    }

    private static String localAddress() {
        try {
            String string = InetAddress.getLocalHost().getHostAddress();
            return string;
        }
        catch (Exception e) {
            Debug.printCallStack("Problem getting host name.", e);
            return null;
        }
    }

    public boolean initialize(Value portname) {
        if (portname instanceof ValueNumber) {
            int portreceive = portname.getNumber();
            try {
                this.sServer = new ServerSocket(portreceive);
            }
            catch (BindException b) {
                Debug.log(1, "\"Failed to activate TCP gateway.\"");
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                Debug.printCallStack("Exception in TCP initialization.", e);
                boolean bl = false;
                return bl;
            }
            this.inputPort = portreceive;
            this.multicastConnectionServer();
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Successfully activated TCP gateway on port ").append(portname.getNumber()).append(".\""))));
            return true;
        }
        if (portname == null) {
            this.sServer = null;
            this.inputPort = 0;
            Debug.log(1, "\"Successfully activated non-listening TCP gateway.\"");
            return true;
        }
        Debug.error(100, "\"Numerical port value expected to activate TCP.\"");
        return false;
    }

    public void connect(InetAddress i, int port) {
        this.connect(i, port, "");
    }

    public void connect(InetAddress i, int port, String source) {
        Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Connecting to ").append(i.getHostAddress()).append(":").append(port).append("...\""))));
        try {
            Socket s = new Socket(i, port);
            ClientThread ct = new ClientThread(s);
            this.ioClients.add(ct);
            Thread client = new Thread(ct);
            client.start();
            if (source != null) {
                ConnectionPacket newpacket = new ConnectionPacket(new ValueIdent("SET_SOURCE"), new ValueString(source));
                newpacket.packData();
                OutputStream out = s.getOutputStream();
                out.write(newpacket.getLength() >> 8 & 0xFF);
                out.write(newpacket.getLength() & 0xFF);
                out.write(newpacket.getBytes(), 0, newpacket.getLength());
            }
        }
        catch (Exception e) {
            Debug.printCallStack("Exception in connection attempt.", e);
            Debug.error(302, "\"Unable to successfully connect.\"");
        }
    }

    public void disconnectPacket(Packet p) {
        this.sendPacket(p);
    }

    public void run() {
        if (this.sServer != null) {
            while (true) {
                try {
                    while (true) {
                        Socket connection = this.sServer.accept();
                        Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Adding TCP connection to ").append(connection.getInetAddress().getHostAddress()).append(":").append(connection.getPort()).append("...\""))));
                        ClientThread ct = new ClientThread(connection);
                        Thread client = new Thread(ct);
                        this.ioClients.add(ct);
                        client.start();
                    }
                }
                catch (Exception e) {
                    Debug.printCallStack("Exception in TCP connection thread.", e);
                    continue;
                }
                break;
            }
        }
    }

    public void sendPacket(Packet p) {
        p.packData();
        int cnt = this.ioClients.size();
        if (p.getType().equals("CONNECTION") && p.getValue("COMMAND").getValueString().equals("DISCONNECT")) {
            if (p.getValue("EXTRA") != null) {
                String address = p.getValue("EXTRA").getValueString();
                for (int i = 0; i < cnt; ++i) {
                    ClientThread ct = (ClientThread)this.ioClients.get(i);
                    if (!ct.sourcename.equals(address)) continue;
                    ct.stop();
                }
                return;
            }
            for (int i = 0; i < cnt; ++i) {
                ClientThread ct = (ClientThread)this.ioClients.get(i);
                ct.stop();
            }
            return;
        }
        short size = p.getLength();
        for (int i = 0; i < cnt; ++i) {
            try {
                ClientThread client = (ClientThread)this.ioClients.elementAt(i);
                if (client.sourcename != "" && p.getDest() != "" && p.getDest() != client.sourcename) continue;
                OutputStream out = client.client.getOutputStream();
                out.write(size >> 8 & 0xFF);
                out.write(size & 0xFF);
                out.write(p.getBytes(), 0, size);
                continue;
            }
            catch (Exception e) {
                Debug.printCallStack("Exception sending TCP packet.", e);
            }
        }
    }

    public void receivePacket(Packet packet) {
        this.transmitPacket(packet);
    }

    public boolean isDestination(Packet p) {
        return true;
    }

    public class ClientThread
    implements Runnable {
        public Socket client;
        public String sourcename;
        private boolean bGo = true;

        public ClientThread(Socket c) {
            this.client = c;
            this.sourcename = "";
        }

        public void stop() {
            this.bGo = false;
            try {
                this.client.close();
            }
            catch (Exception e) {
                Debug.printCallStack("Problem trying to close the client socket.", e);
            }
        }

        public void run() {
            try {
                InputStream io = this.client.getInputStream();
                while (this.bGo) {
                    byte[] packetdata;
                    int read;
                    int size = io.read();
                    if (size == -1) {
                        this.bGo = false;
                    }
                    if ((size = size << 8 | io.read()) <= 0 || (read = io.read(packetdata = new byte[size], 0, size)) != size) continue;
                    Packet p = new Packet(packetdata).getPacketType();
                    if (p instanceof ConnectionPacket) {
                        ConnectionPacket packet = (ConnectionPacket)p;
                        if (!packet.getCommand().getValueString().equals("SET_SOURCE")) continue;
                        this.sourcename = packet.getExtra().getValueString().intern();
                        continue;
                    }
                    TCPGateway.this.inputReceived(p);
                }
            }
            catch (SocketException io) {
            }
            catch (Exception e) {
                Debug.printCallStack("Exception in socket connection.", e);
            }
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Dropping TCP connection to ").append(this.client.getInetAddress().getHostAddress()).append(":").append(this.client.getPort()).append("...\""))));
            ConnectionPacket newpacket = new ConnectionPacket(new ValueIdent("DISCONNECT"), null);
            newpacket.setSource(this.sourcename);
            TCPGateway.this.inputReceived(newpacket);
            TCPGateway.this.ioClients.remove(this);
        }
    }
}

