/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Hashtable;
import org.webmacro.resource.User;
import org.webmacro.resource.UserProvider;
import org.webmacro.util.Base64;
import org.webmacro.util.Log;

class UserImpl
implements User,
Serializable {
    static final boolean debug_ = false;
    static final Log log_ = new Log("user", "user information");
    private String myName;
    private String myDigestPwd;
    private Hashtable myMap;

    public void setPassword(String string) {
        this.myDigestPwd = string != null ? this.crypt(string) : null;
    }

    public String getName() {
        return this.myName;
    }

    public boolean authenticate(String string) {
        return this.myDigestPwd != null && this.crypt(string).equals(this.myDigestPwd);
    }

    public Enumeration elements() {
        return this.myMap.elements();
    }

    public Object get(String string) {
        return this.myMap.get(string);
    }

    public Object put(String string, Object object) {
        return this.myMap.put(string, object);
    }

    public Object remove(String string) {
        return this.myMap.remove(string);
    }

    public int size() {
        return this.myMap.size();
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String crypt(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            return Base64.encode(messageDigest.digest(string.getBytes()));
        }
        catch (Exception exception) {
            UserProvider.log_.error("Encryption services unavailable.");
            return null;
        }
    }

    public String toString() {
        return "User(" + this.myName + "," + this.myDigestPwd + ")";
    }

    protected UserImpl(String string, String string2) {
        this.myName = string;
        this.setPassword(string2);
    }
}

