/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import org.webmacro.engine.Block;
import org.webmacro.engine.Macro;
import org.webmacro.engine.ParseException;
import org.webmacro.engine.ParseTool;
import org.webmacro.engine.QuotedText;
import org.webmacro.util.DictionaryTool;
import org.webmacro.util.InvalidContextException;
import org.webmacro.util.Log;
import org.webmacro.util.java2.HashMap;

final class UseDirective
implements Macro {
    private static final Hashtable languages = new Hashtable();
    public static final String DEFAULT_END_TOKEN = "#end";
    private final String myLangDefn;
    private final String myContent;

    public static final Object parse(ParseTool parseTool) throws IOException, ParseException {
        String string;
        String string2;
        if (!parseTool.parseWord("use")) {
            return null;
        }
        parseTool.parseSpaces();
        if (parseTool.ttype == 34 || parseTool.ttype == 39) {
            string2 = QuotedText.parseQuotedText(parseTool);
        } else if (parseTool.ttype == -3) {
            string2 = parseTool.sval;
            parseTool.nextToken();
        } else {
            throw new ParseException(parseTool, "UseDirective: unexpected character '" + (char)parseTool.ttype + "' found, expecting a word or a quoted string.");
        }
        if (string2 == null) {
            throw new ParseException(parseTool, "UseDirective: unable to determine language type" + ", which should be the first argument after #use.");
        }
        if (languages.get(string2) == null) {
            throw new ParseException(parseTool, "UseDirective: " + string2 + " is not a supported language." + " Valid values are: " + new DictionaryTool(languages).keyString());
        }
        parseTool.parseSpaces();
        if (!parseTool.parseWord("until")) {
            string = DEFAULT_END_TOKEN;
        } else {
            parseTool.parseSpaces();
            if (parseTool.ttype == 34 || parseTool.ttype == 39) {
                string = QuotedText.parseQuotedText(parseTool);
            } else if (parseTool.ttype == -3) {
                string = parseTool.sval;
                parseTool.nextToken();
            } else {
                throw new ParseException(parseTool, "UseDirective: until not followed by boundary token");
            }
        }
        parseTool.parseSpaces();
        if (parseTool.ttype != 10) {
            throw new ParseException(parseTool, "Unexpected content (" + (char)parseTool.ttype + ") at end of line in #use");
        }
        parseTool.nextToken();
        String string3 = parseTool.parseLine();
        StringBuffer stringBuffer = new StringBuffer(1024);
        while (parseTool.ttype != -1) {
            if (string3.indexOf(string) != -1 && string3.trim().equals(string.trim())) break;
            stringBuffer.append(string3);
            string3 = parseTool.parseLine();
        }
        if (string3.indexOf(string) == -1) {
            throw new ParseException(parseTool, "Expected endToken before EOF");
        }
        return new UseDirective(string2, stringBuffer.toString());
    }

    public final Object evaluate(Object object) {
        return this.myContent;
    }

    public final void write(Writer writer, Object object) throws InvalidContextException, IOException {
        writer.write(this.myContent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void main(String[] stringArray) {
        System.out.println("Testing UseDirective:");
        Log.setLevel(Log.DEBUG);
        Log.traceExceptions(true);
        HashMap hashMap = new HashMap();
        String[] stringArray2 = new String[]{"use", "use_default"};
        System.out.println("- - - - - - - - - - - - - - - - -");
        int n = 0;
        while (n < stringArray2.length) {
            File file = new File("examples", stringArray2[n] + ".wm");
            File file2 = new File("examples", stringArray2[n] + ".html");
            System.out.println("TESTING input file: " + file);
            try {
                ParseTool parseTool = new ParseTool(file);
                parseTool.nextToken();
                Block block = (Block)Block.parse(parseTool);
                if (block == null) {
                    System.out.println("FAILED--null returned from parse().");
                } else {
                    FileWriter fileWriter = new FileWriter(file2);
                    block.write(fileWriter, hashMap);
                    ((Writer)fileWriter).close();
                }
            }
            catch (Exception exception) {
                System.out.println("FAILED--threw exception:");
                exception.printStackTrace();
                System.out.println();
            }
            System.out.println("- - - - - - - - - - - - - - - - -");
            ++n;
        }
        System.out.println();
        System.out.println("Done.");
    }

    UseDirective(String string, String string2) {
        this.myLangDefn = string;
        this.myContent = string2;
    }

    static {
        languages.put("text", "text");
    }
}

