package com.unipro.products.smgui;

import java.util.*;
import javax.swing.table.*;

import com.unipro.smlib.*;

/**
 * This class holds the data for Messages table.
 *
 * @author Alexey Skorokhodov
 * @version 1.0
 */
public class MessagesTableModel
    extends DefaultTableModel {

    public static final int MODEL_COLUMN_TIME = 0;
    public static final int MODEL_COLUMN_SENDER = 1;
    public static final int MODEL_COLUMN_TEXT = 2;

    /**
     * This array holds the default column names for the table.
     */
    public static final String[] MODEL_DEFAULT_COLUMNS_NAMES = {
        "Time", "Sender", "Text"};

    /**
     * This array holds the default columns visibility settings
     * for the table.
     */
    public static final boolean[] MODEL_DEFAULT_COLUMNS_VISIBILITY = {
        true, true, true};

    /**
     * This array holds the default column value types for the
     * table (e.g. some columns can store images, some - strings, etc...).
     */
    public static final Class[] MODEL_DEFAULT_COLUMNS_TYPES = {
        String.class, String.class, String.class};

    /** Indicates which columns are visible */
    private boolean[] columnsVisible;

    /**
     * This constructor creates default MessagesTableModel object with empty
     * Data vector, default columns names and visibility settings.
     */
    public MessagesTableModel() {
        dataVector = new Vector();
        // set default values
        setColumnIdentifiers(MODEL_DEFAULT_COLUMNS_NAMES);
        columnsVisible = new boolean[columnIdentifiers.size()];
        setColumnVisibility(MODEL_DEFAULT_COLUMNS_VISIBILITY);
    }

    /**
     * This constructor creates MessagesTableModel object with the given Data
     * vector, with default columns names and visibility settings.
     *
     * @param dataVector the vector to use for the model
     */
    public MessagesTableModel(Vector dataVector) {
        this.dataVector = dataVector;
        // set default values

//  with jdk 1.3 and jdk 1.4  - BAD       setColumnIdentifiers(MODEL_DEFAULT_COLUMNS_NAMES);
        Vector v = new Vector();
        for (int i=0; i < MODEL_DEFAULT_COLUMNS_NAMES.length; i++) {
            v.add(MODEL_DEFAULT_COLUMNS_NAMES[i]);
        }
        this.columnIdentifiers = v;

        columnsVisible = new boolean[columnIdentifiers.size()];
        setColumnVisibility(MODEL_DEFAULT_COLUMNS_VISIBILITY);
    }

    /**
     * Inserts the object to the passed position of the data vector.
     *
     * @param message the message to insert
     * @param position of the message to insert
     */
    public void insertMessage(InMessage message, int position){
        dataVector.insertElementAt(new MessageBean(message), position);
        //System.err.println("MailTableModel: row inserted. rows=" + this.getRowCount());
    }

    /**
     * Inserts the object to the passed position of the data vector.
     *
     * @param message the message to insert
     * @param position of the message to insert
     */
    public void insertMessage(MessageBean message, int position) {
        dataVector.insertElementAt(message, position);
        //System.err.println("MailTableModel: row inserted. rows=" + this.getRowCount());
    }

    /**
     * Adds the object to the end of the data vector.
     *
     * @param message the message to add
     */
    public void addMessage(InMessage message){
        dataVector.add(new MessageBean(message));
        //System.err.println("MailTableModel: row added. rows=" + this.getRowCount());
    }

    /**
     * Adds the object to the end of the data vector.
     *
     * @param message the message to add
     */
    public void addMessage(MessageBean message) {
        dataVector.add(message);
        //System.err.println("MailTableModel: row added. rows=" + this.getRowCount());
    }

    /**
     * Gets the MessageBean object with the given row number.
     *
     * @param which the number of the row in the table
     * @return the ACKBean
     */
    public MessageBean getMessage(int which) {
        return (MessageBean) dataVector.elementAt(which);
    }

    //---------------------
    // Implementation of the TableModel methods
    //---------------------

    /**
     * Returns an attribute value for the cell at <code>row</code>
     * and <code>column</code>.
     *
     * @param   row             the row whose value is to be queried
     * @param   column          the column whose value is to be queried
     * @return                  the value Object at the specified cell
     * @exception  ArrayIndexOutOfBoundsException  if an invalid row or
     *               column was given
     */
    public Object getValueAt(int row, int column) {
        MessageBean messageBean = (MessageBean) dataVector.elementAt(row);
        return messageBean.getField(getNumber(column));
    }

    /**
     * Sets the visibility for the table columns.
     *
     * @param newVisibility array of visibility flags for columns
     */
    public void setColumnVisibility(boolean newVisibility[]) {
        // if the length is acceptable
        if ( (newVisibility != null) &&
            (newVisibility.length <= this.columnsVisible.length)) {
            for (int i = 0; i < newVisibility.length; i++) {
                columnsVisible[i] = newVisibility[i];
            }
        }
    }

    /**
     * Clears the data in the model.
     */
    public void clearData() {
        this.dataVector.clear();
    }

    /**
     * This function converts a column number in the table view
     * to the right number of the table model.
     *
     * @param col the number of the column in the table view
     * @return the number of the column of the table
     */
    protected int getNumber(int col) {
        int n = col; // right number to return
        int i = 0;
        do {
            if (! (columnsVisible[i])) {
                n++;
            }
            i++;
        }
        while (i < n);
        // If we are on an invisible column,
        // we have to go one step further
        while (! (columnsVisible[n])) {
            n++;
        }
        return n;
    }

    /**
     * This method is overriden to disable 'editable' feature for cells.
     * It always returns 'false' for any 'row' and 'column' value.
     *
     * @param row this value is ignored
     * @param column this value is ignored
     * @return always returns false
     */
    public boolean isCellEditable(int row, int column) {
        return false;
    }
}