package com.unipro.products.smgui;

import java.io.*;

import com.unipro.smlib.*;

/**
 * This class holds the Message object.
 *
 * @author Aleksey Skorokhodov
 * @version 1.0
 */
public class MessageBean
    implements Serializable {

    private InMessage message = null;

    /**
     * This constructor creates new MessageBean object from InMessage.
     *
     * @param message MessageBean object
     */
    public MessageBean(InMessage message) {
        if (message == null) {
            throw new NullPointerException("InMessage object passed is null");
        }
        this.message = message;
    }

    /**
     * Gets the stored InMessage.
     *
     * @return the InMessage
     */
    public InMessage getMessage() {
        return message;
    }

    /**
     * This method is specially for displaying a message in Mails Table.
     * This method returns the value of the column given.
     * The column number is considered to be in the Model coordinates, not any View coordinates.
     *
     * This method is called normally only from MessagesTableModel.getValueAt() method.
     *
     * @param i the ID of the column
     * @return the value for the given column ID
     */
    public Object getField(int i) {
        Object o = null;
        switch (i) {
            case MessagesTableModel.MODEL_COLUMN_TIME:
                o = getMessage().getSMSCTime().getTime();
                break;

            case MessagesTableModel.MODEL_COLUMN_SENDER:
                o = getMessage().getSenderNumber();
                break;

            case MessagesTableModel.MODEL_COLUMN_TEXT:
                o = getMessage().getText();
                break;

            default:

        }
        return o;
    }
}