package tester;

/**
 * @(#)TestLoader.java	03/19/02
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as published
 *   by the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details.
 */
import java.io.*;

/**
 * TestLoader is the object that handles the question
 * loading from the question database. It also reads and
 * returns the contents of the log file with all taken tests.
 *
 * @author	Panagiotis Plevrakis
 *
 * Email: pplevrakis@hotmail.com
 * URL:   http://anzwers.org/free/plevrakis/
 */
public class TestLoader {

	BufferedReader buf1,buf2;
	static String files[] = new String[59];
	int fcounter = 0;

    /**
     * Creates a new TestLoader object.
     */
	public TestLoader() {
		for ( int i = 1;i < files.length + 1;i++) {
			files[(i-1)]= new String( "tester" + File.separator + "testfiles" +
			                                     File.separator + i + ".txt" );
	    }
    }

    /**
     * Reads the next question file.
     */
	public String nextQuestion() {
		try {
			StringBuffer buffer = new StringBuffer();
			buf1 = new BufferedReader( new FileReader( files[fcounter] ) );
            String s = "";
			while( (s = buf1.readLine() ) != null )
			buffer.append( s +"\n" );
            fcounter++;
            return buffer.toString();
        } catch ( IOException e ) {
        return "Error while loading file";
        }
        finally {
			try {
				if ( buf1!= null && fcounter == (files.length-1) ) {
	 				buf1.close();
					buf1 = null;
					System.gc();
    			}
			} catch ( IOException ex ) {
			System.out.println( ex.getMessage() );
			}
		}
	}

    /**
     * Reads the contents of the log file.
     */
	public String history() {
		try {
			StringBuffer buffer = new StringBuffer();
			buf2 = new BufferedReader( new FileReader( "testlog.txt" ) );
			String s = "";
			while ( (s = buf2.readLine()) != null )
			buffer.append( s + "\n" );
			return buffer.toString();
		} catch ( IOException e ) {
		return "Error while loading file";
		}
		finally {
			try {
				if ( buf2!= null ) {
					buf2.close();
					buf2 = null;
					System.gc();
				}
			} catch ( IOException ex ) {
			System.out.println( ex.getMessage() );
			}
		}
	}

} //end class