/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Insets;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCTextComponent;
import jclass.util.JCVector;

public class JCTextField
extends JCTextComponent {
    char echo_char;
    String actionCommand;
    protected JCVector actionListeners = new JCVector(0);
    private static final String base = "textfield";
    private static int nameCounter;

    public JCTextField() {
        this("", 20);
    }

    public JCTextField(String string) {
        this(string, 20);
    }

    public JCTextField(String string, int n) {
        this(string, null, null);
        this.columns = n;
    }

    public JCTextField(String string, Applet applet, String string2) {
        super(applet, string2);
        this.setInsets(new Insets(2, 2, 2, 2));
        if (string2 == null) {
            this.setName(base + nameCounter++);
        }
        this.setText(string);
    }

    protected void getParameters() {
        super.getParameters();
    }

    public char getEchoChar() {
        return this.echo_char;
    }

    public void setEchoChar(char c) {
        this.echo_char = c;
        this.repaint();
    }

    public String getEchoCharString() {
        if (this.echo_char == '\u0000') {
            return null;
        }
        char[] cArray = new char[]{this.echo_char};
        return new String(cArray);
    }

    public void setEchoCharString(String string) {
        this.echo_char = string != null && string.length() > 0 ? string.charAt(0) : (char)'\u0000';
    }

    public boolean echoCharIsSet() {
        return this.echo_char != '\u0000';
    }

    char[] getOutputChars() {
        if (this.echo_char == '\u0000') {
            return this.getTextChars();
        }
        char[] cArray = new char[this.num_char];
        int n = 0;
        while (n < this.num_char) {
            cArray[n] = this.echo_char;
            ++n;
        }
        return cArray;
    }

    protected String getOutputText() {
        return new String(this.getOutputChars(), 0, this.num_char);
    }

    public int positionToX(int n) {
        if (this.getPeer() == null) {
            return 0;
        }
        this.getDrawingArea(this.rect);
        n = Math.max(0, Math.min(n, this.num_char));
        int n2 = 0;
        char[] cArray = this.getOutputChars();
        switch (this.alignment) {
            case 2: {
                return this.rect.x + this.rect.width - this.fm.charsWidth(cArray, n, this.num_char - n);
            }
            case 1: {
                n2 = (this.rect.width - this.fm.charsWidth(cArray, 0, this.num_char)) / 2;
            }
        }
        return this.rect.x + this.fm.charsWidth(cArray, 0, n) + n2;
    }

    public void showPosition(int n) {
        if (this.getPeer() == null) {
            return;
        }
        int n2 = this.positionToX(n);
        int n3 = this.horiz_origin;
        this.getDrawingArea(this.rect);
        if (this.rect.width == 0 || this.rect.height == 0) {
            return;
        }
        if (n2 < this.horiz_origin + this.rect.x) {
            this.horiz_origin = n2 - this.rect.x - 2;
        } else if (n2 > this.horiz_origin + this.rect.x + this.rect.width) {
            this.horiz_origin = n2 - (this.rect.x + this.rect.width) + 5;
        }
        if (n3 != this.horiz_origin) {
            this.repaint();
        }
        this.cursor_pos = n;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        if (this.actionCommand == null) {
            return "";
        }
        return this.actionCommand;
    }

    public void addActionListener(JCActionListener jCActionListener) {
        this.actionListeners.add(jCActionListener);
    }

    public void removeActionListener(JCActionListener jCActionListener) {
        this.actionListeners.removeElement(jCActionListener);
    }

    final int drawLine(Graphics graphics, String string, int n, int n2) {
        graphics.drawString(string, n, n2);
        return this.fm.stringWidth(string);
    }

    public Dimension getMinimumSize(int n) {
        if (this.getPeer() != null) {
            return new Dimension(n * this.fm.charWidth('N'), this.preferredHeight());
        }
        return super.minimumSize();
    }

    protected void paintComponent(Graphics graphics) {
        graphics.translate(-this.horiz_origin, 0);
        String string = this.getOutputText();
        this.getDrawingArea(this.rect);
        int n = this.rect.x;
        switch (this.alignment) {
            case 1: {
                n += (this.rect.width - this.fm.stringWidth(string)) / 2;
                break;
            }
            case 2: {
                n += this.rect.width - this.fm.stringWidth(string);
            }
        }
        int n2 = this.fm.getHeight();
        int n3 = n2 - this.fm.getAscent();
        int n4 = this.rect.y + n2 - n3;
        if (!this.isEnabled()) {
            Color color = graphics.getColor();
            graphics.setColor(Color.lightGray.darker().darker());
            graphics.drawString(string, n, n4);
            graphics.setColor(color);
        } else if (this.select_start != this.select_end) {
            if (this.select_start > 0) {
                n += this.drawLine(graphics, string.substring(0, this.select_start), n, n4);
            }
            int n5 = this.positionToX(this.select_start);
            int n6 = this.fm.charsWidth(this.getOutputChars(), this.select_start, this.select_end - this.select_start);
            this.setSelectedBg(graphics);
            graphics.fillRect(n5, 0, n6, this.size().height);
            this.setSelectedFg(graphics);
            n += this.drawLine(graphics, string.substring(this.select_start, this.select_end), n, n4);
            graphics.setColor(this.getForeground());
            this.drawLine(graphics, string.substring(this.select_end), n, n4);
        } else {
            graphics.drawString(string, n, n4);
        }
        graphics.translate(this.horiz_origin, 0);
        this.blinkCursor(true);
    }

    public int pointToPosition(int n, int n2) {
        char[] cArray = this.getOutputChars();
        int[] nArray = this.fm.getWidths();
        this.size();
        this.getDrawingArea(this.rect);
        switch (this.alignment) {
            case 1: {
                n -= this.rect.x + (this.rect.width - this.fm.charsWidth(cArray, 0, this.num_char)) / 2;
                break;
            }
            case 2: {
                n -= this.rect.x + this.rect.width - this.fm.charsWidth(cArray, 0, this.num_char) - this.horiz_origin;
                break;
            }
            default: {
                n -= this.rect.x - this.horiz_origin;
            }
        }
        int n3 = 0;
        while (n3 < this.num_char) {
            int n4 = nArray[cArray[n3]];
            if (this.overstrike ? n < n4 : n < n4 / 2) {
                return n3;
            }
            n -= n4;
            ++n3;
        }
        return this.num_char;
    }

    protected void postActionEvent(Event event) {
        String string = this.getActionCommand();
        if (event == null) {
            event = new Event(this, 0, string);
        }
        JCActionEvent jCActionEvent = new JCActionEvent(this, event.id, string, event.modifiers);
        int n = 0;
        while (n < this.actionListeners.size()) {
            ((JCActionListener)this.actionListeners.elementAt(n)).actionPerformed(jCActionEvent);
            ++n;
        }
    }

    public boolean keyDown(Event event, int n) {
        if (n == 10) {
            this.postActionEvent(event);
            return true;
        }
        return super.keyDown(event, n);
    }
}

